/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.gui.plaintext;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.jfree.base.config.ModifiableConfiguration;
import org.jfree.report.JFreeReport;
import org.jfree.report.modules.gui.base.components.AbstractExportDialog;
import org.jfree.report.modules.gui.plaintext.EncodingSelector;
import org.jfree.report.modules.output.pageable.plaintext.Epson24PinPrinterDriver;
import org.jfree.report.modules.output.pageable.plaintext.Epson9PinPrinterDriver;
import org.jfree.report.modules.output.pageable.plaintext.IBMCompatiblePrinterDriver;
import org.jfree.report.modules.output.pageable.plaintext.PlainTextOutputTarget;
import org.jfree.report.modules.output.pageable.plaintext.PrinterSpecification;
import org.jfree.report.modules.output.pageable.plaintext.PrinterSpecificationManager;
import org.jfree.report.util.EncodingSupport;
import org.jfree.report.util.StringUtil;
import org.jfree.ui.KeyedComboBoxModel;
import org.jfree.ui.action.AbstractFileSelectionAction;
import org.jfree.ui.action.ActionButton;
import org.jfree.ui.action.ActionRadioButton;
import org.jfree.util.Configuration;

public class PlainTextExportDialog
extends AbstractExportDialog {
    public static final int TYPE_PLAIN_OUTPUT = 0;
    public static final int TYPE_EPSON9_OUTPUT = 1;
    public static final int TYPE_IBM_OUTPUT = 2;
    public static final int TYPE_EPSON24_OUTPUT = 3;
    private static final String[] PRINTER_NAMES = new String[]{"plain-text-exportdialog.printer.plain", "plain-text-exportdialog.printer.epson9", "plain-text-exportdialog.printer.ibm", "plain-text-exportdialog.printer.epson24"};
    public static final Float LPI_6 = new Float(6.0f);
    public static final Float LPI_10 = new Float(10.0f);
    public static final Float CPI_10 = new Float(10.0f);
    public static final Float CPI_12 = new Float(12.0f);
    public static final Float CPI_15 = new Float(15.0f);
    public static final Float CPI_17 = new Float(17.14f);
    public static final Float CPI_20 = new Float(20.0f);
    private EncodingSelector encodingSelector;
    private JRadioButton rbPlainPrinterCommandSet;
    private JRadioButton rbEpson9PrinterCommandSet;
    private JRadioButton rbEpson24PrinterCommandSet;
    private JRadioButton rbIBMPrinterCommandSet;
    private JTextField txFilename;
    private JComboBox cbLinesPerInch;
    private JComboBox cbCharsPerInch;
    private JComboBox cbEpson9PrinterType;
    private JComboBox cbEpson24PrinterType;
    private KeyedComboBoxModel epson9Printers;
    private KeyedComboBoxModel epson24Printers;

    public PlainTextExportDialog() {
        this.init();
    }

    public PlainTextExportDialog(Dialog owner) {
        super(owner);
        this.init();
    }

    public PlainTextExportDialog(Frame owner) {
        super(owner);
        this.init();
    }

    public void clear() {
        this.txFilename.setText("");
        this.setSelectedPrinter(0);
        this.cbEpson9PrinterType.setEnabled(false);
        this.cbEpson9PrinterType.setSelectedItem(Epson9PinPrinterDriver.getDefaultPrinter());
        this.cbEpson24PrinterType.setEnabled(false);
        this.cbEpson24PrinterType.setSelectedItem(Epson24PinPrinterDriver.getDefaultPrinter());
        this.cbCharsPerInch.setSelectedItem(CPI_10);
        this.cbLinesPerInch.setSelectedItem(LPI_6);
        this.setEncoding(EncodingSupport.getPlatformDefaultEncoding());
    }

    private JPanel createButtonPanel() {
        ActionButton btnCancel = new ActionButton(this.getCancelAction());
        ActionButton btnConfirm = new ActionButton(this.getConfirmAction());
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(1, 2, 5, 5));
        buttonPanel.add((Component)btnConfirm);
        buttonPanel.add((Component)btnCancel);
        btnConfirm.setDefaultCapable(true);
        buttonPanel.registerKeyboardAction(this.getConfirmAction(), KeyStroke.getKeyStroke(10, 0), 1);
        JPanel buttonCarrier = new JPanel();
        buttonCarrier.setLayout(new FlowLayout(2));
        buttonCarrier.add(buttonPanel);
        return buttonCarrier;
    }

    private JComponent createContentPane() {
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new GridBagLayout());
        contentPane.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        JLabel lblPrinterSelect = new JLabel(this.getResources().getString("plain-text-exportdialog.printer"));
        JLabel lblFileName = new JLabel(this.getResources().getString("plain-text-exportdialog.filename"));
        JLabel lblEncoding = new JLabel(this.getResources().getString("plain-text-exportdialog.encoding"));
        ActionButton btnSelect = new ActionButton((Action)((Object)new ActionSelectFile(this.getResources())));
        JLabel lblCharsPerInch = new JLabel(this.getResources().getString("plain-text-exportdialog.chars-per-inch"));
        JLabel lblLinesPerInch = new JLabel(this.getResources().getString("plain-text-exportdialog.lines-per-inch"));
        JLabel lblFontSettings = new JLabel(this.getResources().getString("plain-text-exportdialog.font-settings"));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(3, 1, 1, 1);
        contentPane.add((Component)lblFileName, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.insets = new Insets(1, 1, 1, 1);
        contentPane.add((Component)lblPrinterSelect, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.insets = new Insets(1, 1, 1, 1);
        contentPane.add((Component)lblEncoding, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.ipadx = 120;
        gbc.gridwidth = 2;
        gbc.insets = new Insets(3, 1, 1, 1);
        contentPane.add((Component)this.txFilename, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.gridx = 3;
        gbc.gridy = 0;
        contentPane.add((Component)btnSelect, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 0.0;
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.gridwidth = 2;
        gbc.insets = new Insets(1, 1, 1, 1);
        contentPane.add((Component)this.rbPlainPrinterCommandSet, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 0.0;
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.gridwidth = 2;
        gbc.insets = new Insets(1, 1, 1, 1);
        contentPane.add((Component)this.rbIBMPrinterCommandSet, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 0.0;
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.gridwidth = 2;
        gbc.insets = new Insets(1, 1, 1, 1);
        contentPane.add((Component)this.rbEpson9PrinterCommandSet, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.gridx = 3;
        gbc.gridy = 3;
        gbc.gridwidth = 1;
        gbc.insets = new Insets(1, 1, 1, 1);
        gbc.fill = 2;
        contentPane.add((Component)this.cbEpson9PrinterType, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 0.0;
        gbc.gridx = 1;
        gbc.gridy = 4;
        gbc.gridwidth = 2;
        gbc.insets = new Insets(1, 1, 1, 1);
        contentPane.add((Component)this.rbEpson24PrinterCommandSet, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.gridx = 3;
        gbc.gridy = 4;
        gbc.gridwidth = 1;
        gbc.insets = new Insets(1, 1, 1, 1);
        gbc.fill = 2;
        contentPane.add((Component)this.cbEpson24PrinterType, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 0.0;
        gbc.gridx = 1;
        gbc.gridy = 5;
        gbc.gridwidth = 3;
        gbc.insets = new Insets(1, 1, 1, 1);
        contentPane.add((Component)this.encodingSelector, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.gridx = 0;
        gbc.gridy = 6;
        gbc.insets = new Insets(1, 1, 1, 1);
        contentPane.add((Component)lblFontSettings, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 0.0;
        gbc.gridx = 2;
        gbc.gridy = 6;
        gbc.insets = new Insets(1, 1, 1, 1);
        contentPane.add((Component)lblCharsPerInch, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 0.0;
        gbc.gridx = 1;
        gbc.gridy = 6;
        gbc.insets = new Insets(1, 1, 1, 1);
        contentPane.add((Component)this.cbCharsPerInch, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 0.0;
        gbc.gridx = 2;
        gbc.gridy = 7;
        gbc.insets = new Insets(1, 1, 1, 1);
        contentPane.add((Component)lblLinesPerInch, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 0.0;
        gbc.gridx = 1;
        gbc.gridy = 7;
        gbc.insets = new Insets(1, 1, 1, 1);
        contentPane.add((Component)this.cbLinesPerInch, gbc);
        return contentPane;
    }

    public float getCharsPerInch() {
        Float i = (Float)this.cbCharsPerInch.getSelectedItem();
        if (i == null) {
            return CPI_10.floatValue();
        }
        return i.floatValue();
    }

    protected String getConfigurationSuffix() {
        return "_plaintextexport";
    }

    public Properties getDialogContents() {
        Properties p = new Properties();
        p.setProperty("filename", this.getFilename());
        p.setProperty("encoding", this.getEncoding());
        if (this.getSelected9PinPrinterModel() != null) {
            p.setProperty("epson-9pin-printer-model", this.getSelected9PinPrinterModel());
        }
        if (this.getSelected24PinPrinterModel() != null) {
            p.setProperty("epson-24pin-printer-model", this.getSelected24PinPrinterModel());
        }
        p.setProperty("chars-per-inch", String.valueOf(this.getCharsPerInch()));
        p.setProperty("lines-per-inch", String.valueOf(this.getLinesPerInch()));
        p.setProperty("selected-printer", String.valueOf(this.getSelectedPrinter()));
        return p;
    }

    public String getEncoding() {
        return this.encodingSelector.getSelectedEncoding();
    }

    public String getFilename() {
        return this.txFilename.getText();
    }

    public float getLinesPerInch() {
        Float i = (Float)this.cbLinesPerInch.getSelectedItem();
        if (i == null) {
            return LPI_6.floatValue();
        }
        return i.floatValue();
    }

    protected String getResourceBaseName() {
        return "org.jfree.report.modules.gui.plaintext.resources/plaintext-export-resources";
    }

    public String getSelected24PinPrinterModel() {
        return (String)this.cbEpson24PrinterType.getSelectedItem();
    }

    public String getSelected9PinPrinterModel() {
        return (String)this.cbEpson9PrinterType.getSelectedItem();
    }

    public int getSelectedPrinter() {
        if (this.rbPlainPrinterCommandSet.isSelected()) {
            return 0;
        }
        if (this.rbEpson9PrinterCommandSet.isSelected()) {
            return 1;
        }
        if (this.rbEpson24PrinterCommandSet.isSelected()) {
            return 3;
        }
        return 2;
    }

    private void init() {
        this.setCancelAction(new ActionCancel(this.getResources()));
        this.setConfirmAction(new ActionConfirm(this.getResources()));
        this.setTitle(this.getResources().getString("plain-text-exportdialog.dialogtitle"));
        this.epson9Printers = this.loadEpson9Printers();
        this.epson24Printers = this.loadEpson24Printers();
        this.cbEpson9PrinterType = new JComboBox(this.epson9Printers);
        this.cbEpson9PrinterType.addActionListener(new SelectEpsonModelAction());
        this.cbEpson24PrinterType = new JComboBox(this.epson24Printers);
        this.cbEpson24PrinterType.addActionListener(new SelectEpsonModelAction());
        Float[] lpiModel = new Float[]{LPI_6, LPI_10};
        Float[] cpiModel = new Float[]{CPI_10, CPI_12, CPI_15, CPI_17, CPI_20};
        this.cbLinesPerInch = new JComboBox<Float>(new DefaultComboBoxModel<Float>(lpiModel));
        this.cbCharsPerInch = new JComboBox<Float>(new DefaultComboBoxModel<Float>(cpiModel));
        String plainPrinterName = this.getResources().getString(PRINTER_NAMES[0]);
        String epson9PrinterName = this.getResources().getString(PRINTER_NAMES[1]);
        String epson24PrinterName = this.getResources().getString(PRINTER_NAMES[3]);
        String ibmPrinterName = this.getResources().getString(PRINTER_NAMES[2]);
        this.rbPlainPrinterCommandSet = new ActionRadioButton((Action)new ActionSelectPrinter(plainPrinterName, 0));
        this.rbEpson9PrinterCommandSet = new ActionRadioButton((Action)new ActionSelectPrinter(epson9PrinterName, 1));
        this.rbEpson24PrinterCommandSet = new ActionRadioButton((Action)new ActionSelectPrinter(epson24PrinterName, 3));
        this.rbIBMPrinterCommandSet = new ActionRadioButton((Action)new ActionSelectPrinter(ibmPrinterName, 2));
        this.txFilename = new JTextField();
        this.encodingSelector = new EncodingSelector();
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.rbPlainPrinterCommandSet);
        bg.add(this.rbIBMPrinterCommandSet);
        bg.add(this.rbEpson9PrinterCommandSet);
        bg.add(this.rbEpson24PrinterCommandSet);
        JPanel rootPane = new JPanel();
        rootPane.setLayout(new BorderLayout());
        rootPane.add((Component)this.createButtonPanel(), "South");
        rootPane.add((Component)this.createContentPane(), "Center");
        JPanel contentWithStatus = new JPanel();
        contentWithStatus.setLayout(new BorderLayout());
        contentWithStatus.add((Component)rootPane, "Center");
        contentWithStatus.add((Component)this.getStatusBar(), "South");
        this.setContentPane(contentWithStatus);
        this.getFormValidator().registerTextField(this.txFilename);
        this.getFormValidator().registerButton(this.rbEpson24PrinterCommandSet);
        this.getFormValidator().registerButton(this.rbEpson9PrinterCommandSet);
        this.getFormValidator().registerButton(this.rbIBMPrinterCommandSet);
        this.getFormValidator().registerButton(this.rbPlainPrinterCommandSet);
        this.clear();
    }

    public void initFromConfiguration(Configuration config) {
        this.setEncoding(config.getConfigProperty("org.jfree.report.modules.output.pageable.plaintext.Encoding", PlainTextOutputTarget.TEXT_OUTPUT_ENCODING_DEFAULT));
        this.setSelected9PinPrinterModel(config.getConfigProperty("org.jfree.report.modules.output.pageable.plaintext.epson.9PinPrinterType", this.getSelected9PinPrinterModel()));
        this.setSelected24PinPrinterModel(config.getConfigProperty("org.jfree.report.modules.output.pageable.plaintext.epson.24PinPrinterType", this.getSelected24PinPrinterModel()));
        try {
            this.setLinesPerInch(StringUtil.parseFloat(config.getConfigProperty("org.jfree.report.modules.output.pageable.plaintext.LinesPerInch", "6"), this.getLinesPerInch()));
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            this.setCharsPerInch(StringUtil.parseFloat(config.getConfigProperty("org.jfree.report.modules.output.pageable.plaintext.CharsPerInch", "10"), this.getCharsPerInch()));
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    private KeyedComboBoxModel loadEpson24Printers() {
        KeyedComboBoxModel epsonPrinters = new KeyedComboBoxModel();
        PrinterSpecificationManager spec24Manager = Epson24PinPrinterDriver.loadSpecificationManager();
        Object[] printer24Names = spec24Manager.getPrinterNames();
        Arrays.sort(printer24Names);
        int i = 0;
        while (i < printer24Names.length) {
            PrinterSpecification pspec = spec24Manager.getPrinter((String)printer24Names[i]);
            epsonPrinters.add((Object)pspec, (Object)pspec.getDisplayName());
            ++i;
        }
        return epsonPrinters;
    }

    private KeyedComboBoxModel loadEpson9Printers() {
        KeyedComboBoxModel epsonPrinters = new KeyedComboBoxModel();
        PrinterSpecificationManager spec9Manager = Epson9PinPrinterDriver.loadSpecificationManager();
        Object[] printer9Names = spec9Manager.getPrinterNames();
        Arrays.sort(printer9Names);
        int i = 0;
        while (i < printer9Names.length) {
            PrinterSpecification pspec = spec9Manager.getPrinter((String)printer9Names[i]);
            epsonPrinters.add((Object)pspec, (Object)pspec.getDisplayName());
            ++i;
        }
        return epsonPrinters;
    }

    public static void main(String[] args) {
        PlainTextExportDialog dialog = new PlainTextExportDialog();
        dialog.setModal(true);
        dialog.pack();
        dialog.performQueryForExport(new JFreeReport());
        System.exit(0);
    }

    protected boolean performConfirm() {
        String filename = this.getFilename();
        File f = new File(filename);
        if (f.exists()) {
            String key1 = "plain-text-exportdialog.targetOverwriteConfirmation";
            String key2 = "plain-text-exportdialog.targetOverwriteTitle";
            if (JOptionPane.showConfirmDialog(this, MessageFormat.format(this.getResources().getString("plain-text-exportdialog.targetOverwriteConfirmation"), this.getFilename()), this.getResources().getString("plain-text-exportdialog.targetOverwriteTitle"), 0, 3) == 1) {
                return false;
            }
        }
        return true;
    }

    public boolean performValidate() {
        this.getStatusBar().clear();
        String filename = this.getFilename();
        if (filename.trim().length() == 0) {
            this.getStatusBar().setStatus(3, this.getResources().getString("plain-text-exportdialog.targetIsEmpty"));
            return false;
        }
        File f = new File(filename);
        if (f.exists()) {
            if (!f.isFile()) {
                this.getStatusBar().setStatus(3, this.getResources().getString("plain-text-exportdialog.targetIsNoFile"));
                return false;
            }
            if (!f.canWrite()) {
                this.getStatusBar().setStatus(3, this.getResources().getString("plain-text-exportdialog.targetIsNotWritable"));
                return false;
            }
            String message = MessageFormat.format(this.getResources().getString("plain-text-exportdialog.targetOverwriteWarning"), filename);
            this.getStatusBar().setStatus(2, message);
        }
        return true;
    }

    public void setCharsPerInch(float cpi) {
        Float cpiObj = new Float(cpi);
        ComboBoxModel model = this.cbCharsPerInch.getModel();
        int i = 0;
        while (i < model.getSize()) {
            if (cpiObj.equals(model.getElementAt(i))) {
                this.cbCharsPerInch.setSelectedIndex(i);
                return;
            }
            ++i;
        }
        throw new IllegalArgumentException("There is no such CPI: " + cpi);
    }

    public void setDialogContents(Properties p) {
        this.setSelectedPrinter(StringUtil.parseInt(p.getProperty("selected-printer"), this.getSelectedPrinter()));
        this.setCharsPerInch(StringUtil.parseFloat(p.getProperty("chars-per-inch"), this.getCharsPerInch()));
        this.setLinesPerInch(StringUtil.parseFloat(p.getProperty("lines-per-inch"), this.getLinesPerInch()));
        this.setEncoding(p.getProperty("encoding", this.getEncoding()));
        this.setFilename(p.getProperty("filename", this.getFilename()));
        this.setSelected9PinPrinterModel(p.getProperty("epson-9pin-printer-model", this.getSelected9PinPrinterModel()));
        this.setSelected24PinPrinterModel(p.getProperty("epson-24pin-printer-model", this.getSelected24PinPrinterModel()));
    }

    public void setEncoding(String encoding) {
        if (encoding == null) {
            throw new NullPointerException("Encoding must not be null");
        }
        this.encodingSelector.setSelectedEncoding(encoding);
    }

    public void setFilename(String filename) {
        this.txFilename.setText(filename);
    }

    public void setLinesPerInch(float lpi) {
        Float lpiObj = new Float(lpi);
        ComboBoxModel model = this.cbLinesPerInch.getModel();
        int i = 0;
        while (i < model.getSize()) {
            if (lpiObj.equals(model.getElementAt(i))) {
                this.cbLinesPerInch.setSelectedIndex(i);
                return;
            }
            ++i;
        }
        throw new IllegalArgumentException("There is no such LPI: " + lpi);
    }

    public void setSelected24PinPrinterModel(String selectedPrinterModel) {
        int size = this.epson24Printers.getSize();
        int i = 0;
        while (i < size) {
            PrinterSpecification spec = (PrinterSpecification)this.epson24Printers.getKeyAt(i);
            if (spec.getDisplayName().equals(selectedPrinterModel)) {
                this.epson24Printers.setSelectedKey((Object)spec);
                return;
            }
            ++i;
        }
        this.epson24Printers.setSelectedKey(null);
    }

    public void setSelected9PinPrinterModel(String selectedPrinterModel) {
        int size = this.epson9Printers.getSize();
        int i = 0;
        while (i < size) {
            PrinterSpecification spec = (PrinterSpecification)this.epson9Printers.getKeyAt(i);
            if (spec.getDisplayName().equals(selectedPrinterModel)) {
                this.epson9Printers.setSelectedKey((Object)spec);
                return;
            }
            ++i;
        }
        this.epson9Printers.setSelectedKey(null);
    }

    public void setSelectedPrinter(int type) {
        String oldEncoding = this.getEncoding();
        if (type == 1) {
            this.rbEpson9PrinterCommandSet.setSelected(true);
            this.cbEpson9PrinterType.setEnabled(true);
            this.cbEpson24PrinterType.setEnabled(false);
            this.updateEpson9Encoding();
        } else if (type == 3) {
            this.rbEpson24PrinterCommandSet.setSelected(true);
            this.cbEpson24PrinterType.setEnabled(true);
            this.cbEpson9PrinterType.setEnabled(false);
            this.updateEpson24Encoding();
        } else if (type == 2) {
            this.rbIBMPrinterCommandSet.setSelected(true);
            this.cbEpson9PrinterType.setEnabled(false);
            this.cbEpson24PrinterType.setEnabled(false);
            this.encodingSelector.setEncodings(new IBMCompatiblePrinterDriver.GenericIBMPrinterSpecification());
        } else if (type == 0) {
            this.rbPlainPrinterCommandSet.setSelected(true);
            this.cbEpson9PrinterType.setEnabled(false);
            this.cbEpson24PrinterType.setEnabled(false);
            this.encodingSelector.setEncodings(new EncodingSelector.GenericPrinterSpecification());
        } else {
            throw new IllegalArgumentException();
        }
        if (oldEncoding != null) {
            this.setEncoding(oldEncoding);
        }
    }

    public void storeToConfiguration(ModifiableConfiguration config) {
        config.setConfigProperty("org.jfree.report.modules.output.pageable.plaintext.Encoding", this.getEncoding());
        config.setConfigProperty("org.jfree.report.modules.output.pageable.plaintext.CharsPerInch", String.valueOf(this.getCharsPerInch()));
        config.setConfigProperty("org.jfree.report.modules.output.pageable.plaintext.LinesPerInch", String.valueOf(this.getLinesPerInch()));
        config.setConfigProperty("org.jfree.report.modules.output.pageable.plaintext.epson.9PinPrinterType", this.getSelected9PinPrinterModel());
        config.setConfigProperty("org.jfree.report.modules.output.pageable.plaintext.epson.24PinPrinterType", this.getSelected24PinPrinterModel());
    }

    protected void updateEpson24Encoding() {
        PrinterSpecification spec = (PrinterSpecification)this.epson9Printers.getSelectedKey();
        if (spec == null) {
            this.encodingSelector.setEncodings(PrinterSpecificationManager.getGenericPrinter());
        } else {
            this.encodingSelector.setEncodings(spec);
        }
    }

    protected void updateEpson9Encoding() {
        PrinterSpecification spec = (PrinterSpecification)this.epson9Printers.getSelectedKey();
        if (spec == null) {
            this.encodingSelector.setEncodings(PrinterSpecificationManager.getGenericPrinter());
        } else {
            this.encodingSelector.setEncodings(spec);
        }
    }

    private class ActionConfirm
    extends AbstractExportDialog.AbstractConfirmAction {
        public ActionConfirm(ResourceBundle resources) {
            this.putValue("Name", resources.getString("plain-text-exportdialog.confirm"));
        }
    }

    private class ActionCancel
    extends AbstractExportDialog.AbstractCancelAction {
        public ActionCancel(ResourceBundle resources) {
            this.putValue("Name", resources.getString("plain-text-exportdialog.cancel"));
        }
    }

    private class ActionSelectFile
    extends AbstractFileSelectionAction {
        private final ResourceBundle resources;

        public ActionSelectFile(ResourceBundle resources) {
            super((Component)PlainTextExportDialog.this);
            this.resources = resources;
            ((AbstractAction)((Object)this)).putValue("Name", resources.getString("plain-text-exportdialog.selectFile"));
        }

        public void actionPerformed(ActionEvent e) {
            File selectedFile = this.performSelectFile(new File(PlainTextExportDialog.this.getFilename()), 1, true);
            if (selectedFile != null) {
                PlainTextExportDialog.this.setFilename(selectedFile.getPath());
            }
        }

        protected String getFileDescription() {
            return this.resources.getString("plain-text-exportdialog.fileDescription");
        }

        protected String getFileExtension() {
            return ".txt";
        }
    }

    private class ActionSelectPrinter
    extends AbstractAction {
        private int printer;

        public ActionSelectPrinter(String printerName, int printer) {
            this.putValue("Name", printerName);
            this.printer = printer;
        }

        public void actionPerformed(ActionEvent e) {
            PlainTextExportDialog.this.setSelectedPrinter(this.printer);
        }
    }

    private class SelectEpsonModelAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent e) {
            if (PlainTextExportDialog.this.getSelectedPrinter() == 1) {
                PlainTextExportDialog.this.updateEpson9Encoding();
            } else if (PlainTextExportDialog.this.getSelectedPrinter() == 3) {
                PlainTextExportDialog.this.updateEpson24Encoding();
            }
        }
    }
}

