/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.gui.print;

import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import org.jfree.report.JFreeReport;
import org.jfree.report.JFreeReportBoot;
import org.jfree.report.ReportProcessingException;
import org.jfree.report.modules.gui.base.AbstractExportPlugin;
import org.jfree.report.modules.gui.base.PreviewProxy;
import org.jfree.report.modules.gui.base.ReportPane;
import org.jfree.report.util.PageFormatFactory;
import org.jfree.util.Log;
import org.jfree.util.ResourceBundleSupport;

public class PageSetupPlugin
extends AbstractExportPlugin {
    private ResourceBundleSupport resources = new ResourceBundleSupport("org.jfree.report.modules.gui.print.resources.print-export-resources");
    private ReportPane reportPane;
    private RepaginationListener repaginationListener = new RepaginationListener();

    public KeyStroke getAcceleratorKey() {
        return null;
    }

    public String getDisplayName() {
        return this.resources.getString("action.page-setup.name");
    }

    public Icon getLargeIcon() {
        return this.resources.getIcon("action.page-setup.icon");
    }

    public Integer getMnemonicKey() {
        return this.resources.getMnemonic("action.page-setup.mnemonic");
    }

    protected ReportPane getReportPane() {
        return this.reportPane;
    }

    protected ResourceBundleSupport getResources() {
        return this.resources;
    }

    public String getShortDescription() {
        return this.resources.getString("action.page-setup.description");
    }

    public Icon getSmallIcon() {
        return this.resources.getIcon("action.page-setup.small-icon");
    }

    public void init(PreviewProxy proxy) {
        super.init(proxy);
        this.reportPane = proxy.getBase().getReportPane();
        this.reportPane.addPropertyChangeListener(this.repaginationListener);
    }

    public boolean isAddToToolbar() {
        return JFreeReportBoot.getInstance().getGlobalConfig().getConfigProperty("org.jfree.report.modules.gui.print.pagesetup.AddToToolbar", "false").equals("true");
    }

    public boolean isControlPlugin() {
        return true;
    }

    public boolean isSeparated() {
        return JFreeReportBoot.getInstance().getGlobalConfig().getConfigProperty("org.jfree.report.modules.gui.print.pagesetup.Separated", "false").equals("true");
    }

    public boolean performExport(JFreeReport report) {
        PageFormat original;
        PrinterJob pj = PrinterJob.getPrinterJob();
        PageFormat pf = pj.validatePage(pj.pageDialog(original = report.getPageDefinition().getPageFormat(0)));
        if (PageFormatFactory.isEqual(pf, original)) {
            return false;
        }
        try {
            this.getBase().updatePageFormat(pf);
        }
        catch (ReportProcessingException reportProcessingException) {
            Log.warn((Object)"Invalid pageformat update");
            return false;
        }
        return true;
    }

    protected void updateReportPane() {
        this.reportPane.removePropertyChangeListener(this.repaginationListener);
        this.reportPane = this.getBase().getReportPane();
        this.reportPane.addPropertyChangeListener(this.repaginationListener);
        this.setEnabled(!this.reportPane.isPrinting() && !this.reportPane.isPaginating());
    }

    private class RepaginationListener
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent evt) {
            if ("printing".equals(evt.getPropertyName()) || "paginating".equals(evt.getPropertyName())) {
                ReportPane reportPane = PageSetupPlugin.this.getReportPane();
                PageSetupPlugin.this.setEnabled(!reportPane.isPrinting() && !reportPane.isPaginating());
            } else if ("reportPane".equals(evt.getPropertyName())) {
                PageSetupPlugin.this.updateReportPane();
            }
        }
    }
}

