/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.gui.print;

import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import org.jfree.report.JFreeReport;
import org.jfree.report.ReportProcessingException;
import org.jfree.report.modules.gui.base.ReportPane;

public class PrintUtil {
    public static final String PRINTER_JOB_NAME_KEY = "org.jfree.report.modules.output.pageable.graphics.print.JobName";

    private PrintUtil() {
    }

    public static boolean print(JFreeReport report) throws PrinterException, ReportProcessingException {
        String jobName = report.getReportConfiguration().getConfigProperty(PRINTER_JOB_NAME_KEY, report.getName());
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        printerJob.setJobName(jobName);
        printerJob.setPageable(new ReportPane(report));
        if (printerJob.printDialog()) {
            printerJob.print();
            return true;
        }
        return false;
    }

    public static void printDirectly(JFreeReport report) throws PrinterException, ReportProcessingException {
        String jobName = report.getReportConfiguration().getConfigProperty(PRINTER_JOB_NAME_KEY, report.getName());
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        printerJob.setJobName(jobName);
        printerJob.setPageable(new ReportPane(report));
        printerJob.print();
    }
}

