/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.misc.bsf;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import org.apache.bsf.BSFException;
import org.apache.bsf.BSFManager;
import org.jfree.report.function.AbstractExpression;
import org.jfree.report.modules.misc.bsf.DataRowWrapper;
import org.jfree.util.Log;

public class BSFExpression
extends AbstractExpression
implements Serializable {
    private transient BSFManager interpreter;
    private transient boolean invalid;
    private transient DataRowWrapper dataRowWrapper;
    private String language;
    private String script;
    private String expression;
    static /* synthetic */ Class class$org$jfree$report$DataRow;

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public Object clone() throws CloneNotSupportedException {
        BSFExpression expression = (BSFExpression)super.clone();
        expression.interpreter = null;
        return expression;
    }

    protected BSFManager createInterpreter() {
        try {
            BSFManager interpreter = new BSFManager();
            this.initializeInterpreter(interpreter);
            return interpreter;
        }
        catch (Exception e) {
            Log.error((Object)"Unable to initialize the expression", (Exception)e);
            return null;
        }
    }

    public String getExpression() {
        return this.expression;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getScript() {
        return this.script;
    }

    public Object getValue() {
        if (this.invalid || this.script == null) {
            return null;
        }
        if (this.interpreter == null) {
            this.interpreter = this.createInterpreter();
            if (this.interpreter == null) {
                this.invalid = true;
                return null;
            }
        }
        try {
            this.dataRowWrapper.setParent(this.getDataRow());
            return this.interpreter.eval(this.getLanguage(), "expression", 1, 1, (Object)this.getExpression());
        }
        catch (Exception e) {
            Log.warn((Object)new Log.SimpleMessage("Evaluation error: ", e.getClass(), (Object)" - ", (Object)e.getMessage()), (Exception)e);
            return null;
        }
    }

    protected void initializeInterpreter(BSFManager interpreter) throws BSFException {
        this.dataRowWrapper = new DataRowWrapper();
        interpreter.declareBean("dataRow", (Object)this.dataRowWrapper, class$org$jfree$report$DataRow != null ? class$org$jfree$report$DataRow : (class$org$jfree$report$DataRow = BSFExpression.class$("org.jfree.report.DataRow")));
        if (this.expression != null) {
            interpreter.exec(this.getLanguage(), "script", 1, 1, (Object)this.getExpression());
        }
    }

    protected void invalidate() {
        this.interpreter = null;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    public void setExpression(String expression) {
        this.expression = expression;
        this.interpreter = null;
    }

    public void setLanguage(String language) {
        this.language = language;
        this.interpreter = null;
    }

    public void setScript(String script) {
        this.script = script;
        this.interpreter = null;
    }
}

