/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.misc.referencedoc;

import java.net.URL;
import javax.swing.table.TableModel;
import org.jfree.report.JFreeReport;
import org.jfree.report.modules.misc.referencedoc.DataSourceReferenceTableModel;
import org.jfree.report.modules.output.pageable.pdf.PDFReportUtil;
import org.jfree.report.modules.output.table.html.HtmlReportUtil;
import org.jfree.report.modules.parser.base.ReportGenerator;
import org.jfree.report.modules.parser.ext.factory.datasource.DataSourceCollector;
import org.jfree.report.modules.parser.ext.factory.datasource.DefaultDataSourceFactory;
import org.jfree.util.ObjectUtilities;

public final class DataSourceReferenceGenerator {
    private static final String REFERENCE_REPORT = "DataSourceReferenceReport.xml";
    static /* synthetic */ Class class$org$jfree$report$modules$misc$referencedoc$DataSourceReferenceGenerator;

    private DataSourceReferenceGenerator() {
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public static TableModel createData() {
        DataSourceCollector cc = new DataSourceCollector();
        cc.addFactory(new DefaultDataSourceFactory());
        DataSourceReferenceTableModel model = new DataSourceReferenceTableModel(cc);
        return model;
    }

    public static void main(String[] args) {
        JFreeReport report;
        ReportGenerator gen = ReportGenerator.getInstance();
        URL reportURL = ObjectUtilities.getResourceRelative((String)REFERENCE_REPORT, (Class)(class$org$jfree$report$modules$misc$referencedoc$DataSourceReferenceGenerator != null ? class$org$jfree$report$modules$misc$referencedoc$DataSourceReferenceGenerator : (class$org$jfree$report$modules$misc$referencedoc$DataSourceReferenceGenerator = DataSourceReferenceGenerator.class$("org.jfree.report.modules.misc.referencedoc.DataSourceReferenceGenerator"))));
        if (reportURL == null) {
            System.err.println("The report was not found in the classpath");
            System.err.println("File: DataSourceReferenceReport.xml");
            System.exit(1);
            return;
        }
        try {
            report = gen.parseReport(reportURL);
        }
        catch (Exception e) {
            System.err.println("The report could not be parsed.");
            System.err.println("File: DataSourceReferenceReport.xml");
            e.printStackTrace(System.err);
            System.exit(1);
            return;
        }
        report.setData(DataSourceReferenceGenerator.createData());
        try {
            HtmlReportUtil.createStreamHTML(report, String.valueOf(System.getProperty("user.home")) + "/datasource-reference.html");
            PDFReportUtil.createPDF(report, String.valueOf(System.getProperty("user.home")) + "/datasource-reference.pdf");
        }
        catch (Exception e) {
            System.err.println("The report processing failed.");
            System.err.println("File: DataSourceReferenceReport.xml");
            e.printStackTrace(System.err);
            System.exit(1);
        }
    }
}

