/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.output.meta;

import java.util.Arrays;
import org.jfree.report.content.Content;
import org.jfree.report.modules.output.meta.MetaElement;
import org.jfree.report.style.ElementStyleSheet;

public class MetaBand
extends MetaElement {
    private MetaElement[] elements;
    private boolean spooled;

    public MetaBand(Content elementContent, ElementStyleSheet style, MetaElement[] elements, boolean spool) {
        super(elementContent, style);
        this.elements = elements;
        this.spooled = spool;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MetaBand)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MetaBand metaBand = (MetaBand)o;
        if (this.spooled != metaBand.spooled) {
            return false;
        }
        return Arrays.equals(this.elements, metaBand.elements);
    }

    public MetaElement getElementAt(int i) {
        return this.elements[i];
    }

    public int getElementCount() {
        return this.elements.length;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 29 * result + (this.spooled ? 1 : 0);
        return result;
    }

    public boolean isSpooled() {
        return this.spooled;
    }

    public MetaElement[] toArray() {
        MetaElement[] newElements = new MetaElement[this.elements.length];
        System.arraycopy(this.elements, 0, newElements, 0, this.elements.length);
        return newElements;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("MetaBand={size=");
        s.append(this.elements.length);
        s.append(", spooled=");
        s.append(this.spooled);
        s.append(", bounds=");
        s.append(this.getBounds());
        int i = 0;
        while (i < this.elements.length) {
            s.append(",\n");
            s.append("{");
            s.append(this.elements[i]);
            s.append("}");
            ++i;
        }
        s.append("}");
        return s.toString();
    }
}

