/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.output.pageable.base.pagelayout;

import org.jfree.report.Band;
import org.jfree.report.Group;
import org.jfree.report.PageFooter;
import org.jfree.report.ReportDefinition;
import org.jfree.report.ReportProcessingException;
import org.jfree.report.content.ContentCreationException;
import org.jfree.report.event.PrepareEventListener;
import org.jfree.report.event.ReportEvent;
import org.jfree.report.function.Expression;
import org.jfree.report.function.FunctionProcessingException;
import org.jfree.report.layout.AbstractBandLayoutManager;
import org.jfree.report.layout.BandLayoutManagerUtil;
import org.jfree.report.modules.output.meta.MetaBand;
import org.jfree.report.modules.output.pageable.base.LogicalPage;
import org.jfree.report.modules.output.pageable.base.operations.AligningMetaBandProducer;
import org.jfree.report.modules.output.pageable.base.pagelayout.PageLayouter;
import org.jfree.report.modules.output.pageable.base.pagelayout.SimplePageLayoutCursor;
import org.jfree.report.modules.output.support.pagelayout.SimplePageLayoutDelegate;
import org.jfree.report.modules.output.support.pagelayout.SimplePageLayoutWorker;
import org.jfree.report.states.ReportState;
import org.jfree.report.style.BandStyleKeys;
import org.jfree.report.util.geom.StrictBounds;
import org.jfree.report.util.geom.StrictGeomUtility;

public class SimplePageLayouter
extends PageLayouter
implements PrepareEventListener,
SimplePageLayoutWorker {
    public static final String WATERMARK_PRINTED_KEY = "org.jfree.report.modules.pageable.base.WatermarkPrinted";
    private static final long POSITION_UNDEFINED = -1L;
    private static final boolean ENDPAGE_FORCED = true;
    private static final boolean ENDPAGE_REQUESTED = false;
    private boolean isLastPageBreak;
    private boolean startNewPage;
    private SimplePageLayoutCursor cursor;
    private SimpleLayoutManagerState state;
    private SimplePageLayoutDelegate delegate;

    public SimplePageLayouter() {
        this.setName("Layout");
        this.delegate = new SimplePageLayoutDelegate(this);
    }

    protected void clearSaveState() {
        super.clearSaveState();
        this.state = null;
    }

    public Object clone() throws CloneNotSupportedException {
        SimplePageLayouter sl = (SimplePageLayouter)super.clone();
        sl.delegate = (SimplePageLayoutDelegate)this.delegate.clone();
        sl.delegate.setWorker(sl);
        return sl;
    }

    protected void createSaveState(Band b) {
        this.state = b == null ? new SimpleLayoutManagerState(null) : new SimpleLayoutManagerState(b.getTreeLock());
    }

    protected StrictBounds doLayout(Band band, boolean fireEvent) {
        long width = StrictGeomUtility.toInternalValue(this.getLogicalPage().getWidth());
        long height = this.getCursor().getPageBottomReserved() - this.getCursor().getPageTop();
        StrictBounds bounds = BandLayoutManagerUtil.doLayout(band, this.getLogicalPage().getLayoutSupport(), width, height);
        if (fireEvent) {
            ReportEvent event = this.getCurrentEvent();
            this.clearCurrentEvent();
            event.getState().fireLayoutCompleteEvent(band, event.getType());
            this.setCurrentEvent(event);
        }
        return bounds;
    }

    protected boolean doPrint(StrictBounds bounds, Band band, boolean spool, boolean watermark, long position) throws ReportProcessingException {
        try {
            long height = bounds.getHeight();
            if (this.isFinishingPage()) {
                ReportEvent event = this.getCurrentEvent();
                this.clearCurrentEvent();
                event.getState().fireOutputCompleteEvent(band, event.getType());
                this.setCurrentEvent(event);
                AligningMetaBandProducer producer = new AligningMetaBandProducer(this.getLogicalPage().getLayoutSupport());
                MetaBand rootBand = producer.createBand(band, spool);
                if (rootBand != null) {
                    this.addRootMetaBand(rootBand);
                }
                this.cursor.advance(height);
                return true;
            }
            if (!(watermark || this.isPageEnded() || this.isSpaceFor(height))) {
                this.setAutomaticPagebreak(true);
                return false;
            }
            if (this.isPageEnded()) {
                this.createSaveState(band);
                return false;
            }
            ReportEvent event = this.getCurrentEvent();
            this.clearCurrentEvent();
            event.getState().fireOutputCompleteEvent(band, event.getType());
            this.setCurrentEvent(event);
            AligningMetaBandProducer producer = new AligningMetaBandProducer(this.getLogicalPage().getLayoutSupport());
            MetaBand metaBand = producer.createBand(band, spool);
            if (metaBand != null) {
                this.addRootMetaBand(metaBand);
            }
            this.cursor.advance(height);
            if (band.getStyle().getBooleanStyleProperty(BandStyleKeys.PAGEBREAK_AFTER)) {
                this.createSaveState(null);
                this.endPage(false);
            }
            return true;
        }
        catch (ReportProcessingException rpe) {
            throw rpe;
        }
        catch (ContentCreationException ote) {
            throw new FunctionProcessingException("Failed to print", (Exception)((Object)ote));
        }
    }

    protected boolean endPage(boolean force) throws ReportProcessingException {
        if (!this.isGeneratedPageEmpty() || force) {
            super.endPage();
            return true;
        }
        return false;
    }

    public void finishPageAfterRestore(ReportState state) throws ReportProcessingException {
        this.createSaveState(null);
        super.finishPageAfterRestore(state);
    }

    private Band getBandForID(ReportDefinition def, Object id) {
        if (def.getReportHeader().getTreeLock() == id) {
            return def.getReportHeader();
        }
        if (def.getReportFooter().getTreeLock() == id) {
            return def.getReportFooter();
        }
        if (def.getPageHeader().getTreeLock() == id) {
            return def.getPageHeader();
        }
        if (def.getPageFooter().getTreeLock() == id) {
            return def.getPageFooter();
        }
        if (def.getItemBand().getTreeLock() == id) {
            return def.getItemBand();
        }
        int i = 0;
        while (i < def.getGroupCount()) {
            Group g = def.getGroup(i);
            if (g.getHeader().getTreeLock() == id) {
                return g.getHeader();
            }
            if (g.getFooter().getTreeLock() == id) {
                return g.getFooter();
            }
            ++i;
        }
        return null;
    }

    protected SimplePageLayoutCursor getCursor() {
        if (this.cursor == null) {
            throw new IllegalStateException("No cursor, no OutputTarget: " + this.hashCode());
        }
        return this.cursor;
    }

    public long getCursorPosition() {
        if (this.getCursor() == null) {
            throw new IllegalStateException("Cursor is not initialized.");
        }
        return this.getCursor().getY();
    }

    public Expression getInstance() {
        SimplePageLayouter sl = (SimplePageLayouter)super.getInstance();
        sl.delegate = new SimplePageLayoutDelegate(sl);
        sl.cursor = null;
        sl.isLastPageBreak = false;
        sl.state = null;
        return sl;
    }

    public long getReservedSpace() {
        if (this.getCursor() == null) {
            throw new IllegalStateException("Cursor is not initialized.");
        }
        return this.getCursor().getReservedSpace();
    }

    public long getTopContentPosition() {
        if (this.getCursor() == null) {
            throw new IllegalStateException("Cursor is not initialized.");
        }
        return this.getCursor().getPageTop();
    }

    public void groupFinished(ReportEvent event) {
        if (this.isPageEnded()) {
            throw new IllegalStateException("AssertationFailed: Page is closed.");
        }
        this.setCurrentEvent(event);
        try {
            try {
                this.delegate.groupFinished(event);
            }
            catch (FunctionProcessingException fe) {
                throw fe;
            }
            catch (Exception e) {
                throw new FunctionProcessingException("GroupFinished failed", e);
            }
            Object var3_4 = null;
            this.clearCurrentEvent();
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.clearCurrentEvent();
            throw throwable;
        }
    }

    public void groupStarted(ReportEvent event) {
        if (this.isPageEnded()) {
            throw new IllegalStateException();
        }
        this.setCurrentEvent(event);
        try {
            try {
                this.delegate.groupStarted(event);
            }
            catch (FunctionProcessingException fe) {
                throw fe;
            }
            catch (Exception e) {
                throw new FunctionProcessingException("GroupStarted failed", e);
            }
            Object var3_4 = null;
            this.clearCurrentEvent();
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.clearCurrentEvent();
            throw throwable;
        }
    }

    public boolean isNewPageStarted() {
        return this.startNewPage;
    }

    public boolean isPageEmpty() {
        return this.isGeneratedPageEmpty();
    }

    public boolean isSpaceFor(long height) {
        if (this.isLastPageBreak && !this.getReport().getPageFooter().isDisplayOnLastPage()) {
            this.getCursor().setReservedSpace(0L);
        } else {
            PageFooter b = this.getReport().getPageFooter();
            StrictBounds rect = this.doLayout(b, false);
            this.getCursor().setReservedSpace(rect.getHeight());
        }
        return this.getCursor().isSpaceFor(height);
    }

    public boolean isWatermarkSupported() {
        return this.getReport().getReportConfiguration().getConfigProperty(WATERMARK_PRINTED_KEY, "true").equals("true");
    }

    public void itemsAdvanced(ReportEvent event) {
        if (this.isPageEnded()) {
            throw new IllegalStateException();
        }
        this.setCurrentEvent(event);
        try {
            try {
                this.delegate.itemsAdvanced(event);
            }
            catch (FunctionProcessingException fe) {
                throw fe;
            }
            catch (Exception e) {
                throw new FunctionProcessingException("ItemsAdvanced failed", e);
            }
            Object var3_4 = null;
            this.clearCurrentEvent();
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.clearCurrentEvent();
            throw throwable;
        }
    }

    public void itemsFinished(ReportEvent event) {
        this.setCurrentEvent(event);
        this.delegate.itemsFinished(event);
        this.clearCurrentEvent();
    }

    public void itemsStarted(ReportEvent event) {
        this.setCurrentEvent(event);
        this.delegate.itemsStarted(event);
        this.clearCurrentEvent();
    }

    public void pageFinished(ReportEvent event) {
        this.setCurrentEvent(event);
        try {
            try {
                this.delegate.pageFinished(event);
            }
            catch (FunctionProcessingException fe) {
                throw fe;
            }
            catch (Exception e) {
                throw new FunctionProcessingException("PageFinished failed", e);
            }
            Object var3_4 = null;
            this.clearCurrentEvent();
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.clearCurrentEvent();
            throw throwable;
        }
    }

    public void pageRolledBack(ReportEvent event) {
    }

    public void pageStarted(ReportEvent event) {
        if (this.isPageEnded()) {
            throw new IllegalStateException();
        }
        this.setCurrentEvent(event);
        try {
            try {
                this.delegate.pageStarted(event);
            }
            catch (FunctionProcessingException fe) {
                throw fe;
            }
            catch (Exception e) {
                throw new FunctionProcessingException("PageStarted failed", e);
            }
            Object var3_4 = null;
            this.clearCurrentEvent();
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.clearCurrentEvent();
            throw throwable;
        }
    }

    public void prepareEvent(ReportEvent event) {
        this.getLogicalPage().getLayoutSupport().getCache().flushDynamicCache();
    }

    public boolean print(Band b, boolean spool, boolean handlePagebreak) throws ReportProcessingException {
        long position;
        if (this.isPageEnded()) {
            this.createSaveState(b);
            this.setNewPageStarted(true);
            return false;
        }
        Float f = (Float)b.getStyle().getStyleProperty(BandStyleKeys.FIXED_POSITION);
        if (f == null) {
            position = -1L;
        } else {
            position = StrictGeomUtility.toInternalValue(f.floatValue());
            if (position >= this.getCursor().getPageBottom() || position < 0L) {
                throw new IndexOutOfBoundsException("Given fixed position is invalid");
            }
        }
        if (handlePagebreak && b.getStyle().getBooleanStyleProperty(BandStyleKeys.PAGEBREAK_BEFORE) || position != -1L && position < this.getCursorPosition()) {
            this.createSaveState(b);
            if (this.endPage(false)) {
                this.setNewPageStarted(true);
                return false;
            }
        }
        long y = position == -1L ? this.getCursor().getY() : position;
        StrictBounds bounds = this.doLayout(b, true);
        bounds.setRect(0L, y, bounds.getWidth(), bounds.getHeight());
        return this.doPrint(bounds, b, spool, false, position);
    }

    public boolean printBottom(Band b) throws ReportProcessingException {
        StrictBounds bounds = this.doLayout(b, true);
        bounds.setRect(0L, this.getCursor().getPageBottomReserved() - bounds.getHeight(), bounds.getWidth(), bounds.getHeight());
        return this.doPrint(bounds, b, true, false, -1L);
    }

    public boolean printWatermark(Band watermark) throws ReportProcessingException {
        LogicalPage logPage = this.getLogicalPage();
        long width = StrictGeomUtility.toInternalValue(logPage.getWidth());
        long height = StrictGeomUtility.toInternalValue(logPage.getHeight());
        StrictBounds bounds = BandLayoutManagerUtil.doFixedLayout(watermark, logPage.getLayoutSupport(), width, height);
        return this.doPrint(bounds, watermark, true, true, -1L);
    }

    public void reportDone(ReportEvent event) {
        if (this.isPageEnded()) {
            throw new IllegalStateException("AssertationFailed: Page ended.");
        }
        try {
            try {
                this.setCurrentEvent(event);
                this.restartPage(event.getState());
                this.createSaveState(null);
                this.saveCurrentState();
                this.endPage(true);
            }
            catch (Exception e) {
                throw new FunctionProcessingException("ReportDone", e);
            }
            Object var3_3 = null;
            this.clearCurrentEvent();
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.clearCurrentEvent();
            throw throwable;
        }
    }

    public void reportFinished(ReportEvent event) {
        if (this.isPageEnded()) {
            throw new IllegalStateException();
        }
        this.setCurrentEvent(event);
        try {
            try {
                this.delegate.reportFinished(event);
            }
            catch (FunctionProcessingException fe) {
                throw fe;
            }
            catch (Exception e) {
                throw new FunctionProcessingException("ReportFinished failed", e);
            }
            Object var3_4 = null;
            this.clearCurrentEvent();
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.clearCurrentEvent();
            throw throwable;
        }
    }

    public void reportStarted(ReportEvent event) {
        if (this.isPageEnded()) {
            throw new IllegalStateException();
        }
        this.setCurrentEvent(event);
        try {
            try {
                this.delegate.reportStarted(event);
            }
            catch (FunctionProcessingException fe) {
                throw fe;
            }
            catch (Exception e) {
                throw new FunctionProcessingException("ReportStarted failed", e);
            }
            Object var3_4 = null;
            this.clearCurrentEvent();
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.clearCurrentEvent();
            throw throwable;
        }
    }

    public void resetCursor() {
        LogicalPage lp = this.getLogicalPage();
        long internalVerticalAlignmentBorder = lp.getLayoutSupport().getInternalVerticalAlignmentBorder();
        this.setCursor(new SimplePageLayoutCursor(AbstractBandLayoutManager.alignDown(StrictGeomUtility.toInternalValue(lp.getHeight()), internalVerticalAlignmentBorder)));
    }

    public void restartPage(ReportState reportState) throws ReportProcessingException {
        if (this.isPageRestartDone() || this.isRestartingPage() || this.isFinishingPage()) {
            return;
        }
        this.startPage(reportState);
        if (this.state == null) {
            return;
        }
        this.setRestartingPage(true);
        boolean pagebreakAfter = false;
        if (this.state.getBandID() != null) {
            ReportDefinition impl = reportState.getReport();
            Band band = this.getBandForID(impl, this.state.getBandID());
            pagebreakAfter = band.getStyle().getBooleanStyleProperty(BandStyleKeys.PAGEBREAK_AFTER);
            band.getStyle().setBooleanStyleProperty(BandStyleKeys.PAGEBREAK_AFTER, false);
            this.setCurrentEvent(new ReportEvent(reportState, reportState.getEventCode()));
            this.print(band, pagebreakAfter, false);
            band.getStyle().setBooleanStyleProperty(BandStyleKeys.PAGEBREAK_AFTER, pagebreakAfter);
            this.clearCurrentEvent();
        }
        this.clearSaveState();
        this.setRestartingPage(false);
        if (pagebreakAfter) {
            this.createSaveState(null);
            this.endPage(false);
        }
    }

    public void restoreSaveState(ReportState anchestor) throws ReportProcessingException {
        super.restoreSaveState(anchestor);
        this.isLastPageBreak = false;
    }

    protected PageLayouter.LayoutManagerState saveCurrentState() {
        if (this.state == null) {
            throw new NullPointerException();
        }
        return this.state;
    }

    protected void setCursor(SimplePageLayoutCursor cursor) {
        if (cursor == null) {
            throw new NullPointerException("SimplePageLayouter.setCursor(...): cursor is null.");
        }
        this.cursor = cursor;
    }

    public void setLogicalPage(LogicalPage logicalPage) {
        super.setLogicalPage(logicalPage);
        long internalVerticalAlignmentBorder = logicalPage.getLayoutSupport().getInternalVerticalAlignmentBorder();
        this.setCursor(new SimplePageLayoutCursor(AbstractBandLayoutManager.alignDown(StrictGeomUtility.toInternalValue(logicalPage.getHeight()), internalVerticalAlignmentBorder)));
    }

    protected void setNewPageStarted(boolean startNewPage) {
        this.startNewPage = startNewPage;
    }

    public void setReservedSpace(long reserved) {
        if (this.getCursor() == null) {
            throw new IllegalStateException("Cursor is not initialized.");
        }
        this.getCursor().setReservedSpace(reserved);
    }

    public void setTopPageContentPosition(long topContentPosition) {
        if (this.getCursor() == null) {
            throw new IllegalStateException("Cursor is not initialized.");
        }
        this.getCursor().setPageTop(topContentPosition);
    }

    protected static class SimpleLayoutManagerState
    extends PageLayouter.LayoutManagerState {
        private final Object bandID;

        public SimpleLayoutManagerState(Object bandID) {
            this.bandID = bandID;
        }

        public Object getBandID() {
            return this.bandID;
        }

        public String toString() {
            return "State={" + this.bandID + "}";
        }
    }
}

