/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.output.pageable.pdf;

import com.lowagie.text.Anchor;
import com.lowagie.text.BadElementException;
import com.lowagie.text.DocWriter;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Image;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.FontMapper;
import com.lowagie.text.pdf.PdfAction;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import org.jfree.report.ImageContainer;
import org.jfree.report.JFreeReport;
import org.jfree.report.PageDefinition;
import org.jfree.report.ShapeElement;
import org.jfree.report.content.AnchorContent;
import org.jfree.report.content.Content;
import org.jfree.report.content.DrawableContent;
import org.jfree.report.content.ImageContent;
import org.jfree.report.layout.SizeCalculator;
import org.jfree.report.modules.output.meta.MetaElement;
import org.jfree.report.modules.output.pageable.base.OutputTargetException;
import org.jfree.report.modules.output.pageable.base.output.AbstractOutputTarget;
import org.jfree.report.modules.output.pageable.pdf.VolatilePdfState;
import org.jfree.report.modules.output.support.itext.BaseFontCreateException;
import org.jfree.report.modules.output.support.itext.BaseFontFactory;
import org.jfree.report.modules.output.support.itext.BaseFontRecord;
import org.jfree.report.modules.output.support.itext.BaseFontSupport;
import org.jfree.report.modules.output.support.itext.ITextImageCache;
import org.jfree.report.style.ElementDefaultStyleSheet;
import org.jfree.report.style.FontDefinition;
import org.jfree.report.util.geom.StrictBounds;
import org.jfree.report.util.geom.StrictGeomUtility;
import org.jfree.ui.Drawable;
import org.jfree.util.Configuration;
import org.jfree.util.Log;

public strictfp class PDFOutputTarget
extends AbstractOutputTarget {
    public static final String CONFIGURATION_PREFIX = "org.jfree.report.modules.output.pageable.pdf.";
    public static final String EMBED_FONTS = "EmbedFonts";
    public static final String SECURITY_ALLOW_PRINTING = "AllowPrinting";
    public static final String SECURITY_ALLOW_MODIFY_CONTENTS = "AllowModifyContents";
    public static final String SECURITY_ALLOW_COPY = "AllowCopy";
    public static final String SECURITY_ALLOW_MODIFY_ANNOTATIONS = "AllowModifyAnnotations";
    public static final String SECURITY_ALLOW_FILLIN = "AllowFillIn";
    public static final String SECURITY_ALLOW_SCREENREADERS = "AllowScreenReaders";
    public static final String SECURITY_ALLOW_ASSEMBLY = "AllowAssembly";
    public static final String SECURITY_ALLOW_DEGRADED_PRINTING = "AllowDegradedPrinting";
    public static final String SECURITY_ENCRYPTION = "Encryption";
    public static final String SECURITY_ENCRYPTION_NONE = "none";
    public static final String SECURITY_ENCRYPTION_40BIT = "40bit";
    public static final String SECURITY_ENCRYPTION_128BIT = "128bit";
    public static final String SECURITY_USERPASSWORD = "UserPassword";
    public static final String SECURITY_OWNERPASSWORD = "OwnerPassword";
    private static final String CREATOR = String.valueOf(JFreeReport.getInfo().getName()) + " version " + JFreeReport.getInfo().getVersion();
    public static final String ENCODING = "Encoding";
    public static final String PDFTARGET_EMBED_FONTS = "org.jfree.report.modules.output.pageable.pdf.EmbedFonts";
    public static final String PDFTARGET_EMBED_FONTS_DEFAULT = "true";
    public static final String PDFTARGET_ENCODING = "org.jfree.report.modules.output.pageable.pdf.Encoding";
    public static final String PDFTARGET_ENCODING_DEFAULT = "Cp1252";
    public static final String PDF_VERSION = "Version";
    public static final String PDFTARGET_PDF_VERSION = "org.jfree.report.modules.output.pageable.pdf.Version";
    public static final String PDF_VERSION_DEFAULT = "1.4";
    private final OutputStream out;
    private Document pdfDocument;
    private PdfWriter writer;
    private BaseFont baseFont;
    private FontDefinition fontDefinition;
    private Stroke awtStroke;
    private Paint awtPaint;
    private final BaseFontSupport fontSupport;
    private PageFormat currentPageFormat;
    private StrictBounds internalPDFOperationBounds;
    private ITextImageCache cachedImages;
    private boolean awaitOpenDocument;
    private static final byte[] PDF_PASSWORD_PAD;
    private VolatilePdfState pdfGraphics;

    static {
        byte[] byArray = new byte[32];
        byArray[0] = 40;
        byArray[1] = -65;
        byArray[2] = 78;
        byArray[3] = 94;
        byArray[4] = 78;
        byArray[5] = 117;
        byArray[6] = -118;
        byArray[7] = 65;
        byArray[8] = 100;
        byArray[10] = 78;
        byArray[11] = 86;
        byArray[12] = -1;
        byArray[13] = -6;
        byArray[14] = 1;
        byArray[15] = 8;
        byArray[16] = 46;
        byArray[17] = 46;
        byArray[19] = -74;
        byArray[20] = -48;
        byArray[21] = 104;
        byArray[22] = 62;
        byArray[23] = -128;
        byArray[24] = 47;
        byArray[25] = 12;
        byArray[26] = -87;
        byArray[27] = -2;
        byArray[28] = 100;
        byArray[29] = 83;
        byArray[30] = 105;
        byArray[31] = 122;
        PDF_PASSWORD_PAD = byArray;
    }

    public PDFOutputTarget(OutputStream out) {
        if (out == null) {
            throw new NullPointerException("OutputStream must not be null");
        }
        this.out = out;
        this.fontSupport = new BaseFontSupport();
        this.internalPDFOperationBounds = new StrictBounds();
        this.cachedImages = new ITextImageCache();
    }

    public void beginPage(PageDefinition format, int i) {
        if (!this.isOpen()) {
            throw new IllegalStateException("Target " + this.hashCode() + " is not open");
        }
        PageFormat pageFormat = format.getPageFormat(i);
        float urx = (float)pageFormat.getWidth();
        float ury = (float)pageFormat.getHeight();
        float marginLeft = (float)pageFormat.getImageableX();
        float marginRight = (float)(pageFormat.getWidth() - pageFormat.getImageableWidth() - pageFormat.getImageableX());
        float marginTop = (float)pageFormat.getImageableY();
        float marginBottom = (float)(pageFormat.getHeight() - pageFormat.getImageableHeight() - pageFormat.getImageableY());
        Rectangle pageSize = new Rectangle(urx, ury);
        this.getDocument().setPageSize(pageSize);
        this.getDocument().setMargins(marginLeft, marginRight, marginTop, marginBottom);
        if (this.awaitOpenDocument) {
            this.getDocument().open();
            this.awaitOpenDocument = false;
        }
        this.pdfGraphics = new VolatilePdfState(this.writer.getDirectContent(), ury);
        try {
            this.setPaint(ElementDefaultStyleSheet.DEFAULT_PAINT);
            this.setStroke(ShapeElement.DEFAULT_STROKE);
            this.setFont(ElementDefaultStyleSheet.DEFAULT_FONT_DEFINITION);
        }
        catch (OutputTargetException oe) {
            Log.error((Object)"Exception while defining defaults.", (Exception)((Object)oe));
            throw new IllegalStateException("Exception while defining defaults.");
        }
        this.currentPageFormat = pageFormat;
    }

    public void close() {
        this.getDocument().close();
        this.fontSupport.close();
        this.pdfDocument = null;
        this.writer = null;
    }

    public void configure(Configuration config) {
        this.updateProperty(SECURITY_OWNERPASSWORD, config);
        this.updateProperty(SECURITY_USERPASSWORD, config);
        this.updateProperty("Author", config);
        this.updateProperty(ENCODING, config);
        this.updateProperty(PDF_VERSION, config);
        this.updateBooleanProperty(EMBED_FONTS, config);
        this.updateBooleanProperty(SECURITY_ALLOW_ASSEMBLY, config);
        this.updateBooleanProperty(SECURITY_ALLOW_COPY, config);
        this.updateBooleanProperty(SECURITY_ALLOW_DEGRADED_PRINTING, config);
        this.updateBooleanProperty(SECURITY_ALLOW_FILLIN, config);
        this.updateBooleanProperty(SECURITY_ALLOW_MODIFY_ANNOTATIONS, config);
        this.updateBooleanProperty(SECURITY_ALLOW_MODIFY_CONTENTS, config);
        this.updateBooleanProperty(SECURITY_ALLOW_PRINTING, config);
        this.updateBooleanProperty(SECURITY_ALLOW_SCREENREADERS, config);
        this.updateBooleanProperty(SECURITY_OWNERPASSWORD, config);
        this.updateBooleanProperty(SECURITY_USERPASSWORD, config);
        this.updateProperty(SECURITY_ENCRYPTION, config);
    }

    public SizeCalculator createTextSizeCalculator(FontDefinition font) throws OutputTargetException {
        try {
            BaseFontRecord record = this.fontSupport.createBaseFont(font, font.getFontEncoding(this.getFontEncoding()), this.isEmbedFonts() || font.isEmbeddedFont());
            class Org_jfree_report_modules_output_pageable_pdf_PDFOutputTarget$1 {
                /* synthetic */ Org_jfree_report_modules_output_pageable_pdf_PDFOutputTarget$1() {
                }
            }
            return new PDFSizeCalculator(null, record.getBaseFont(), font.getFontSize());
        }
        catch (BaseFontCreateException bfce) {
            throw new OutputTargetException("The font definition was not successfull.", (Exception)((Object)bfce));
        }
    }

    protected void drawDrawable(DrawableContent content) {
        StrictBounds bounds = this.getInternalPDFOperationBounds();
        float x = (float)StrictGeomUtility.toExternalValue(bounds.getX());
        float y = (float)StrictGeomUtility.toExternalValue(bounds.getY());
        float urx = (float)this.currentPageFormat.getWidth();
        float ury = (float)this.currentPageFormat.getHeight();
        Graphics2D g2 = this.writer.getDirectContent().createGraphics(urx, ury, (FontMapper)this.fontSupport);
        g2.setPaint(this.getPaint());
        g2.setStroke(this.getStroke());
        g2.translate(x, y);
        Drawable drawable = content.getContent();
        StrictBounds imageArea = content.getImageArea();
        double imageWidth = StrictGeomUtility.toExternalValue(bounds.getWidth());
        double imageHeight = StrictGeomUtility.toExternalValue(bounds.getHeight());
        Rectangle2D.Double newClipArea = new Rectangle2D.Double(0.0, 0.0, imageWidth, imageHeight);
        g2.clip(newClipArea);
        int imageX = (int)StrictGeomUtility.toExternalValue(imageArea.getX());
        int imageY = (int)StrictGeomUtility.toExternalValue(imageArea.getY());
        g2.translate(-imageX, -imageY);
        StrictBounds drawableBounds = content.getBounds();
        double drawableWidth = StrictGeomUtility.toExternalValue(drawableBounds.getWidth());
        double drawableHeight = StrictGeomUtility.toExternalValue(drawableBounds.getHeight());
        drawable.draw(g2, (Rectangle2D)new Rectangle2D.Double(0.0, 0.0, drawableWidth, drawableHeight));
        g2.dispose();
    }

    protected void drawImage(ImageContent content) throws OutputTargetException {
        try {
            StrictBounds bounds = this.getInternalPDFOperationBounds();
            float imageX = (float)StrictGeomUtility.toExternalValue(bounds.getX());
            float imageY = (float)((double)this.getPageHeight() - StrictGeomUtility.toExternalValue(bounds.getY() + bounds.getHeight()));
            ImageContainer imageContent = content.getContent();
            Image image = this.cachedImages.getImage(imageContent);
            image.setAbsolutePosition(imageX, imageY);
            StrictBounds imageArea = content.getImageArea();
            float scaleX = (float)bounds.getWidth() / (float)imageArea.getWidth();
            float scaleY = (float)bounds.getHeight() / (float)imageArea.getHeight();
            image.scalePercent(100.0f * scaleX, 100.0f * scaleY);
            PdfContentByte cb = this.writer.getDirectContent();
            cb.saveState();
            float clipX = (float)StrictGeomUtility.toExternalValue(imageArea.getX() + bounds.getX());
            float clipY = (float)((double)this.getPageHeight() - StrictGeomUtility.toExternalValue(bounds.getY() + imageArea.getHeight()));
            cb.rectangle(clipX, clipY, (float)StrictGeomUtility.toExternalValue(imageArea.getWidth()), (float)StrictGeomUtility.toExternalValue(imageArea.getHeight()));
            cb.clip();
            cb.newPath();
            cb.addImage(image);
            cb.restoreState();
        }
        catch (BadElementException be) {
            throw new OutputTargetException("BadElementException", (Exception)((Object)be));
        }
        catch (DocumentException de) {
            throw new OutputTargetException("DocumentException", (Exception)((Object)de));
        }
        catch (MalformedURLException mf) {
            throw new OutputTargetException("Invalid URL in ImageReference", mf);
        }
        catch (IOException mf) {
            throw new OutputTargetException("URL Content could not be read", mf);
        }
    }

    protected void drawShape(Shape shape) {
        StrictBounds internalBounds = this.getInternalPDFOperationBounds();
        float ycorr = (float)StrictGeomUtility.toExternalValue(internalBounds.getY());
        float xcorr = (float)StrictGeomUtility.toExternalValue(internalBounds.getX());
        float urx = (float)this.currentPageFormat.getWidth();
        float ury = (float)this.currentPageFormat.getHeight();
        Graphics2D g2 = this.writer.getDirectContent().createGraphics(urx, ury, (FontMapper)this.fontSupport);
        g2.setPaint(this.getPaint());
        g2.setStroke(this.getStroke());
        g2.translate(xcorr, ycorr);
        g2.draw(shape);
        g2.dispose();
    }

    public void endPage() throws OutputTargetException {
        try {
            this.getDocument().newPage();
        }
        catch (Exception e) {
            throw new OutputTargetException("Failed to end page", e);
        }
    }

    protected void fillShape(Shape shape) {
        StrictBounds internalBounds = this.getInternalPDFOperationBounds();
        float ycorr = (float)StrictGeomUtility.toExternalValue(internalBounds.getY());
        float xcorr = (float)StrictGeomUtility.toExternalValue(internalBounds.getX());
        float urx = (float)this.currentPageFormat.getWidth();
        float ury = (float)this.currentPageFormat.getHeight();
        Graphics2D g2 = this.writer.getDirectContent().createGraphics(urx, ury, (FontMapper)this.fontSupport);
        g2.setPaint(this.getPaint());
        g2.setStroke(this.getStroke());
        g2.translate(xcorr, ycorr);
        g2.fill(shape);
        g2.dispose();
    }

    protected BaseFont getBaseFont() {
        return this.baseFont;
    }

    private boolean getBooleanProperty(String key, boolean value) {
        String val = this.getProperty(key);
        if (val == null) {
            return value;
        }
        return val.equals(PDFTARGET_EMBED_FONTS_DEFAULT);
    }

    private Document getDocument() {
        return this.pdfDocument;
    }

    protected FontDefinition getFont() {
        return this.fontDefinition;
    }

    private String getFontEncoding() {
        return this.getProperty(ENCODING, BaseFontFactory.getDefaultFontEncoding());
    }

    private StrictBounds getInternalPDFOperationBounds() {
        return this.internalPDFOperationBounds;
    }

    private float getPageHeight() {
        return this.getDocument().getPageSize().height();
    }

    protected Paint getPaint() {
        return this.awtPaint;
    }

    private int getPermissions() {
        boolean allowPrinting = this.getBooleanProperty(SECURITY_ALLOW_PRINTING, false);
        boolean allowModifyContents = this.getBooleanProperty(SECURITY_ALLOW_MODIFY_CONTENTS, false);
        boolean allowModifyAnnotations = this.getBooleanProperty(SECURITY_ALLOW_MODIFY_ANNOTATIONS, false);
        boolean allowCopy = this.getBooleanProperty(SECURITY_ALLOW_COPY, false);
        boolean allowFillIn = this.getBooleanProperty(SECURITY_ALLOW_FILLIN, false);
        boolean allowScreenReaders = this.getBooleanProperty(SECURITY_ALLOW_SCREENREADERS, false);
        boolean allowAssembly = this.getBooleanProperty(SECURITY_ALLOW_ASSEMBLY, false);
        boolean allowDegradedPrinting = this.getBooleanProperty(SECURITY_ALLOW_DEGRADED_PRINTING, false);
        int permissions = 0;
        if (allowPrinting) {
            permissions |= 0x804;
        }
        if (allowModifyContents) {
            permissions |= 8;
        }
        if (allowModifyAnnotations) {
            permissions |= 0x20;
        }
        if (allowCopy) {
            permissions |= 0x10;
        }
        if (allowFillIn) {
            permissions |= 0x100;
        }
        if (allowScreenReaders) {
            permissions |= 0x200;
        }
        if (allowAssembly) {
            permissions |= 0x400;
        }
        if (allowDegradedPrinting) {
            permissions |= 4;
        }
        return permissions;
    }

    protected Stroke getStroke() {
        return this.awtStroke;
    }

    private char getVersion(String version) {
        if (version == null) {
            return '4';
        }
        if (version.length() < 3) {
            Log.warn((Object)"PDF version specification is invalid, using default version '1.4'.");
            return '4';
        }
        char retval = version.charAt(2);
        if (retval < '2' || retval > '5') {
            Log.warn((Object)"PDF version specification is invalid, using default version '1.4'.");
            return '4';
        }
        return retval;
    }

    public boolean isEmbedFonts() {
        return this.getProperty(EMBED_FONTS, "false").equals(PDFTARGET_EMBED_FONTS_DEFAULT);
    }

    public boolean isOpen() {
        if (this.getDocument() == null) {
            return false;
        }
        return this.awaitOpenDocument || this.getDocument().isOpen();
    }

    protected boolean isPaintSupported(Paint p) {
        return p instanceof Color || p instanceof GradientPaint || p instanceof TexturePaint;
    }

    public void open() throws OutputTargetException {
        try {
            this.setDocument(new Document());
            this.writer = PdfWriter.getInstance((Document)this.getDocument(), (OutputStream)this.out);
            this.writer.setLinearPageMode();
            char version = this.getVersion(this.getProperty(PDF_VERSION, PDF_VERSION_DEFAULT));
            this.writer.setPdfVersion(version);
            String encrypt = this.getProperty(SECURITY_ENCRYPTION);
            if (encrypt != null && (encrypt.equals(SECURITY_ENCRYPTION_128BIT) || encrypt.equals(SECURITY_ENCRYPTION_40BIT))) {
                String userpassword = this.getProperty(SECURITY_USERPASSWORD);
                String ownerpassword = this.getProperty(SECURITY_OWNERPASSWORD);
                byte[] userpasswordbytes = DocWriter.getISOBytes((String)userpassword);
                byte[] ownerpasswordbytes = DocWriter.getISOBytes((String)ownerpassword);
                if (ownerpasswordbytes == null) {
                    ownerpasswordbytes = PDF_PASSWORD_PAD;
                }
                this.writer.setEncryption(userpasswordbytes, ownerpasswordbytes, this.getPermissions(), encrypt.equals(SECURITY_ENCRYPTION_128BIT));
            }
            String title = this.getProperty("Title");
            String author = this.getProperty("Author");
            if (title != null) {
                this.getDocument().addTitle(title);
            }
            if (author != null) {
                this.getDocument().addAuthor(author);
            }
            this.getDocument().addCreator(CREATOR);
            this.getDocument().addCreationDate();
            this.awaitOpenDocument = true;
        }
        catch (Exception e) {
            throw new OutputTargetException("Opening Document failed.", e);
        }
    }

    protected void printAnchorContent(MetaElement element, Content content) throws OutputTargetException {
        try {
            AnchorContent ac = (AnchorContent)content;
            Anchor anchor = new Anchor();
            anchor.setName(ac.getAnchor().getName());
            this.writer.add((Element)anchor);
        }
        catch (DocumentException e) {
            throw new OutputTargetException("Failed to add anchor", (Exception)((Object)e));
        }
    }

    protected void printHRefForCurrentContent(String href) {
        PdfAction action = new PdfAction(href);
        StrictBounds elementBounds = this.getInternalPDFOperationBounds();
        float leftX = (float)StrictGeomUtility.toExternalValue(elementBounds.getX());
        float rightX = (float)StrictGeomUtility.toExternalValue(elementBounds.getX() + elementBounds.getWidth());
        float lowerY = this.getPageHeight() - (float)StrictGeomUtility.toExternalValue(elementBounds.getY() + elementBounds.getHeight());
        float upperY = this.getPageHeight() - (float)StrictGeomUtility.toExternalValue(elementBounds.getY());
        PdfContentByte cb = this.writer.getDirectContent();
        cb.setAction(action, leftX, lowerY, rightX, upperY);
    }

    protected void printText(String text) {
        StrictBounds bounds = this.getInternalPDFOperationBounds();
        float fontSize = this.getFont().getFontSize();
        PdfContentByte cb = this.writer.getDirectContent();
        this.pdfGraphics.setPaint(this.getPaint(), true);
        this.pdfGraphics.setPaint(this.getPaint(), false);
        this.pdfGraphics.setStroke(this.getStroke());
        cb.beginText();
        cb.setFontAndSize(this.baseFont, fontSize);
        float ascent = this.baseFont.getFontDescriptor(1, fontSize);
        float y2 = (float)(StrictGeomUtility.toExternalValue(bounds.getY()) + (double)ascent);
        float x1 = (float)StrictGeomUtility.toExternalValue(bounds.getX());
        float x2 = (float)StrictGeomUtility.toExternalValue(bounds.getX() + bounds.getWidth());
        cb.showTextAligned(0, text, x1, this.getPageHeight() - y2, 0.0f);
        cb.endText();
        if (this.getFont().isUnderline()) {
            cb.newPath();
            float underlinePosition = (fontSize - ascent) * 0.8f;
            cb.moveTo(x1, this.getPageHeight() - y2 - underlinePosition);
            cb.lineTo(x2, this.getPageHeight() - y2 - underlinePosition);
            cb.stroke();
        }
        if (this.getFont().isStrikeThrough()) {
            cb.newPath();
            float strikethroughPosition = fontSize * 0.5f;
            cb.moveTo(x1, this.getPageHeight() - y2 + strikethroughPosition);
            cb.lineTo(x2, this.getPageHeight() - y2 + strikethroughPosition);
            cb.stroke();
        }
    }

    private void setDocument(Document document) {
        if (document == null) {
            throw new NullPointerException();
        }
        this.pdfDocument = document;
    }

    public void setEmbedFonts(boolean embedFonts) {
        this.setProperty(EMBED_FONTS, String.valueOf(embedFonts));
    }

    protected void setFont(FontDefinition font) throws OutputTargetException {
        if (font == null) {
            throw new NullPointerException();
        }
        if (this.baseFont != null && this.fontDefinition != null && this.fontDefinition.equals(font)) {
            return;
        }
        this.fontDefinition = font;
        try {
            this.baseFont = this.fontSupport.createBaseFont(font, font.getFontEncoding(this.getFontEncoding()), this.isEmbedFonts() || font.isEmbeddedFont()).getBaseFont();
            if (this.baseFont == null) {
                throw new OutputTargetException("The font definition was not successfull.");
            }
        }
        catch (BaseFontCreateException bfce) {
            throw new OutputTargetException("The font definition was not successfull.", (Exception)((Object)bfce));
        }
    }

    public void setFontEncoding(String encoding) {
        if (encoding == null) {
            throw new NullPointerException();
        }
        this.setProperty(ENCODING, encoding);
    }

    protected void setInternalOperationBounds(StrictBounds bounds) {
        super.setInternalOperationBounds(bounds);
        StrictBounds pageBounds = this.getInternalPageBounds();
        long x = -pageBounds.getX() + bounds.getX() + StrictGeomUtility.toInternalValue(this.currentPageFormat.getImageableX());
        long y = -pageBounds.getY() + bounds.getY() + StrictGeomUtility.toInternalValue(this.currentPageFormat.getImageableY());
        this.internalPDFOperationBounds.setRect(x, y, bounds.getWidth(), bounds.getHeight());
    }

    protected void setPaint(Paint paint) {
        if (paint == null) {
            throw new NullPointerException();
        }
        if (!(paint instanceof Color)) {
            Log.warn((Object)("Unable to handle paint type: " + paint.getClass() + " will be ignored."));
            return;
        }
        if (this.awtPaint != null && this.awtPaint.equals(paint)) {
            return;
        }
        this.awtPaint = paint;
    }

    protected void setStroke(Stroke stroke) {
        if (stroke == null) {
            throw new NullPointerException();
        }
        if (!(stroke instanceof BasicStroke)) {
            Log.warn((Object)("Unable to handle stroke type: " + stroke.getClass() + " will be ignored."));
            return;
        }
        if (this.awtStroke != null && this.awtStroke.equals(stroke)) {
            return;
        }
        this.awtStroke = stroke;
    }

    private void updateBooleanProperty(String key, Configuration config) {
        String configValue = config.getConfigProperty(CONFIGURATION_PREFIX + key);
        String propertyValue = this.getProperty(key, configValue);
        if (propertyValue == null) {
            return;
        }
        if (propertyValue.equalsIgnoreCase(PDFTARGET_EMBED_FONTS_DEFAULT)) {
            this.setProperty(key, this.getProperty(key, PDFTARGET_EMBED_FONTS_DEFAULT));
        } else {
            this.setProperty(key, this.getProperty(key, "false"));
        }
    }

    private void updateProperty(String key, Configuration config) {
        String configValue = config.getConfigProperty(CONFIGURATION_PREFIX + key);
        String propertyValue = this.getProperty(key, configValue);
        if (propertyValue != null) {
            this.setProperty(key, propertyValue);
        }
    }

    private strictfp static final class PDFSizeCalculator
    implements SizeCalculator {
        private final BaseFont baseFont;
        private final float fontSize;

        private PDFSizeCalculator(BaseFont font, float fontSize) {
            if (font == null) {
                throw new NullPointerException("BaseFont must not be null");
            }
            if (fontSize <= 0.0f) {
                throw new IllegalArgumentException("FontSize must be greater than 0");
            }
            this.baseFont = font;
            this.fontSize = fontSize;
        }

        /* synthetic */ PDFSizeCalculator(1 $0, BaseFont $1, float $2) {
            this($1, $2);
        }

        public float getLineHeight() {
            return this.fontSize;
        }

        public float getStringWidth(String text, int lineStartPos, int endPos) {
            return this.baseFont.getWidthPoint(text.substring(lineStartPos, endPos), this.fontSize);
        }
    }
}

