/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.output.pageable.plaintext;

import org.jfree.report.style.FontDefinition;

public class PlaintextDataChunk {
    private final String text;
    private final FontDefinition font;
    private final int x;
    private final int y;
    private final int width;
    private final String encoding;

    protected PlaintextDataChunk(String text, FontDefinition font, String encoding, int x, int y, int w) {
        if (font == null) {
            throw new NullPointerException("Font must not be null");
        }
        if (text == null) {
            throw new NullPointerException("Text must not be null");
        }
        if (x < 0) {
            throw new IllegalArgumentException();
        }
        if (y < 0) {
            throw new IllegalArgumentException();
        }
        if (w < 1) {
            throw new IllegalArgumentException();
        }
        if (w > text.length()) {
            throw new IllegalArgumentException("Size limit: " + w + " vs. " + text.length());
        }
        this.x = x;
        this.y = y;
        this.width = w;
        this.encoding = font.getFontEncoding(encoding);
        this.text = text;
        this.font = font;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public FontDefinition getFont() {
        return this.font;
    }

    public String getText() {
        return this.text;
    }

    public int getWidth() {
        return this.width;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }
}

