/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.output.pageable.plaintext;

public final class PrinterEncoding {
    private String displayName;
    private String encoding;
    private byte[] code;
    private String internalName;

    public PrinterEncoding(String internalName, String displayName, String encoding, byte[] code) {
        if (internalName == null) {
            throw new NullPointerException();
        }
        this.internalName = internalName;
        this.displayName = displayName;
        this.encoding = encoding;
        this.code = new byte[code.length];
        System.arraycopy(code, 0, this.code, 0, code.length);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PrinterEncoding)) {
            return false;
        }
        PrinterEncoding printerEncoding = (PrinterEncoding)o;
        return this.internalName.equals(printerEncoding.internalName);
    }

    public byte[] getCode() {
        byte[] retval = new byte[this.code.length];
        System.arraycopy(this.code, 0, retval, 0, this.code.length);
        return retval;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getInternalName() {
        return this.internalName;
    }

    public int hashCode() {
        return this.internalName.hashCode();
    }

    public String toString() {
        return "org.jfree.report.modules.output.pageable.plaintext.PrinterEncoding{internalName='" + this.internalName + "'" + ", displayName='" + this.displayName + "'" + ", encoding='" + this.encoding + "'" + "}";
    }
}

