/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.output.support.itext;

import com.lowagie.text.BadElementException;
import com.lowagie.text.DocumentException;
import java.awt.Image;
import java.io.IOException;
import java.net.URL;
import org.jfree.report.ImageContainer;
import org.jfree.report.LocalImageContainer;
import org.jfree.report.URLImageContainer;
import org.jfree.report.util.KeyedQueue;
import org.jfree.util.Log;
import org.jfree.util.WaitingImageObserver;

public class ITextImageCache {
    private KeyedQueue cachedImages = new KeyedQueue(0);

    public com.lowagie.text.Image getImage(ImageContainer imageRef) throws DocumentException, IOException {
        LocalImageContainer localImageContainer;
        URLImageContainer urlImageContainer;
        if (imageRef instanceof URLImageContainer && (urlImageContainer = (URLImageContainer)imageRef).isLoadable()) {
            try {
                URL sourceURL = urlImageContainer.getSourceURL();
                if (sourceURL != null) {
                    com.lowagie.text.Image image = (com.lowagie.text.Image)this.cachedImages.get(sourceURL);
                    if (image == null) {
                        image = com.lowagie.text.Image.getInstance((URL)sourceURL);
                        this.cachedImages.put(sourceURL, image);
                    }
                    return image;
                }
            }
            catch (BadElementException be) {
                Log.info((Object)"Caught illegal Image, will recode to PNG instead", (Exception)((Object)be));
            }
            catch (IOException ioe) {
                Log.info((Object)"Unable to read the raw-data, will try to recode image-data.", (Exception)ioe);
            }
        }
        if (imageRef instanceof LocalImageContainer && (localImageContainer = (LocalImageContainer)imageRef).getImage() != null) {
            com.lowagie.text.Image image;
            Object identity = localImageContainer.getIdentity();
            if (identity != null) {
                image = (com.lowagie.text.Image)this.cachedImages.get(identity);
                if (image == null) {
                    image = com.lowagie.text.Image.getInstance((Image)localImageContainer.getImage(), null, (boolean)false);
                    this.cachedImages.put(identity, image);
                }
            } else {
                image = com.lowagie.text.Image.getInstance((Image)localImageContainer.getImage(), null, (boolean)false);
            }
            WaitingImageObserver obs = new WaitingImageObserver(localImageContainer.getImage());
            obs.waitImageLoaded();
            return image;
        }
        throw new DocumentException("Neither an URL nor an Image was given to paint the graphics");
    }
}

