/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.output.table.rtf.metaelements;

import com.lowagie.text.Chunk;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Paragraph;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.rtf.table.RtfCell;
import java.awt.Color;
import org.jfree.report.ElementAlignment;
import org.jfree.report.modules.output.table.base.RawContent;
import org.jfree.report.modules.output.table.rtf.metaelements.RTFMetaElement;
import org.jfree.report.style.ElementStyleSheet;
import org.jfree.report.style.FontDefinition;

public class RTFTextMetaElement
extends RTFMetaElement {
    private BaseFont baseFont;

    public RTFTextMetaElement(RawContent elementContent, ElementStyleSheet style, BaseFont baseFont) {
        super(elementContent, style);
        this.baseFont = baseFont;
    }

    public void applyTextStyle(Chunk p) {
        FontDefinition font = this.getFontDefinitionProperty();
        Color paint = (Color)this.getProperty(ElementStyleSheet.PAINT, Color.black);
        int style = 0;
        if (font.isBold()) {
            ++style;
        }
        if (font.isItalic()) {
            style += 2;
        }
        if (font.isStrikeThrough()) {
            style += 8;
        }
        if (font.isUnderline()) {
            style += 4;
        }
        p.setFont(new Font(this.baseFont, (float)font.getFontSize(), style, paint));
    }

    public RtfCell getCell() throws DocumentException {
        RtfCell cell = new RtfCell();
        cell.setBorderWidth(0.0f);
        RawContent rc = (RawContent)this.getContent();
        Chunk chunk = new Chunk(String.valueOf(rc.getContent()));
        this.applyTextStyle(chunk);
        Paragraph paragraph = new Paragraph();
        paragraph.add((Object)chunk);
        paragraph.setAlignment(this.getHorizontalAlignment());
        cell.setVerticalAlignment(this.getVerticalAlignment());
        cell.addElement((Element)paragraph);
        return cell;
    }

    private int getHorizontalAlignment() {
        ElementAlignment alignment = (ElementAlignment)this.getProperty(ElementStyleSheet.ALIGNMENT, ElementAlignment.LEFT);
        if (alignment.equals(ElementAlignment.CENTER)) {
            return 1;
        }
        if (alignment.equals(ElementAlignment.RIGHT)) {
            return 2;
        }
        return 0;
    }

    private int getVerticalAlignment() {
        ElementAlignment alignment = (ElementAlignment)this.getProperty(ElementStyleSheet.VALIGNMENT, ElementAlignment.TOP);
        if (alignment.equals(ElementAlignment.MIDDLE)) {
            return 5;
        }
        if (alignment.equals(ElementAlignment.BOTTOM)) {
            return 6;
        }
        return 4;
    }
}

