/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.output.table.xls.util;

import java.awt.print.PageFormat;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.apache.poi.hssf.usermodel.HSSFPrintSetup;
import org.jfree.report.PageDefinition;
import org.jfree.report.modules.output.table.xls.util.ExcelPageDefinition;
import org.jfree.report.util.PageFormatFactory;

public final class ExcelPrintSetupFactory {
    public static final ExcelPageDefinition LETTER = new ExcelPageDefinition(1, PageFormatFactory.LETTER[0], PageFormatFactory.LETTER[1]);
    public static final ExcelPageDefinition LETTER_SMALL = new ExcelPageDefinition(2, PageFormatFactory.LETTER_SMALL[0], PageFormatFactory.LETTER_SMALL[1]);
    public static final ExcelPageDefinition TABLOID = new ExcelPageDefinition(3, PageFormatFactory.TABLOID[0], PageFormatFactory.TABLOID[1]);
    public static final ExcelPageDefinition LEDGER = new ExcelPageDefinition(4, PageFormatFactory.LEDGER[0], PageFormatFactory.LEDGER[1]);
    public static final ExcelPageDefinition LEGAL = new ExcelPageDefinition(5, PageFormatFactory.LEGAL[0], PageFormatFactory.LEGAL[1]);
    public static final ExcelPageDefinition STATEMENT = new ExcelPageDefinition(6, PageFormatFactory.STATEMENT[0], PageFormatFactory.STATEMENT[1]);
    public static final ExcelPageDefinition EXECUTIVE = new ExcelPageDefinition(7, PageFormatFactory.EXECUTIVE[0], PageFormatFactory.EXECUTIVE[1]);
    public static final ExcelPageDefinition A3 = new ExcelPageDefinition(8, PageFormatFactory.A3[0], PageFormatFactory.A3[1]);
    public static final ExcelPageDefinition A4 = new ExcelPageDefinition(9, PageFormatFactory.A4[0], PageFormatFactory.A4[1]);
    public static final ExcelPageDefinition A4_SMALL = new ExcelPageDefinition(10, PageFormatFactory.A4_SMALL[0], PageFormatFactory.A4_SMALL[1]);
    public static final ExcelPageDefinition A5 = new ExcelPageDefinition(11, PageFormatFactory.A5[0], PageFormatFactory.A5[1]);
    public static final ExcelPageDefinition B4 = new ExcelPageDefinition(12, PageFormatFactory.B4[0], PageFormatFactory.B4[1]);
    public static final ExcelPageDefinition B5 = new ExcelPageDefinition(13, PageFormatFactory.B5[0], PageFormatFactory.B5[1]);
    public static final ExcelPageDefinition FOLIO = new ExcelPageDefinition(14, PageFormatFactory.FOLIO[0], PageFormatFactory.FOLIO[1]);
    public static final ExcelPageDefinition QUARTO = new ExcelPageDefinition(15, PageFormatFactory.QUARTO[0], PageFormatFactory.QUARTO[1]);
    public static final ExcelPageDefinition PAPER10X14 = new ExcelPageDefinition(16, PageFormatFactory.PAPER10X14[0], PageFormatFactory.PAPER10X14[1]);
    public static final ExcelPageDefinition PAPER11X17 = new ExcelPageDefinition(17, PageFormatFactory.PAPER11X17[0], PageFormatFactory.PAPER11X17[1]);
    public static final ExcelPageDefinition NOTE = new ExcelPageDefinition(18, PageFormatFactory.NOTE[0], PageFormatFactory.NOTE[1]);
    public static final ExcelPageDefinition ENV9 = new ExcelPageDefinition(19, PageFormatFactory.ENV9[0], PageFormatFactory.ENV9[1]);
    public static final ExcelPageDefinition ENV10 = new ExcelPageDefinition(20, PageFormatFactory.ENV10[0], PageFormatFactory.ENV10[1]);
    public static final ExcelPageDefinition ENV11 = new ExcelPageDefinition(21, PageFormatFactory.ENV11[0], PageFormatFactory.ENV11[1]);
    public static final ExcelPageDefinition ENV12 = new ExcelPageDefinition(22, PageFormatFactory.ENV12[0], PageFormatFactory.ENV12[1]);
    public static final ExcelPageDefinition ENV14 = new ExcelPageDefinition(23, PageFormatFactory.ENV14[0], PageFormatFactory.ENV14[1]);
    public static final ExcelPageDefinition ENVDL = new ExcelPageDefinition(27, PageFormatFactory.ENVDL[0], PageFormatFactory.ENVDL[1]);
    public static final ExcelPageDefinition ENVC5 = new ExcelPageDefinition(28, PageFormatFactory.ENVC5[0], PageFormatFactory.ENVC5[1]);
    public static final ExcelPageDefinition ENVC3 = new ExcelPageDefinition(29, PageFormatFactory.ENVC3[0], PageFormatFactory.ENVC3[1]);
    public static final ExcelPageDefinition ENVC4 = new ExcelPageDefinition(30, PageFormatFactory.ENVC4[0], PageFormatFactory.ENVC4[1]);
    public static final ExcelPageDefinition ENVC6 = new ExcelPageDefinition(31, PageFormatFactory.ENVC6[0], PageFormatFactory.ENVC6[1]);
    public static final ExcelPageDefinition ENVC65 = new ExcelPageDefinition(32, PageFormatFactory.ENVC65[0], PageFormatFactory.ENVC65[1]);
    public static final ExcelPageDefinition ENVISOB4 = new ExcelPageDefinition(33, PageFormatFactory.ENVISOB4[0], PageFormatFactory.ENVISOB4[1]);
    public static final ExcelPageDefinition ENVB5 = new ExcelPageDefinition(34, PageFormatFactory.ENVISOB5[0], PageFormatFactory.ENVISOB5[1]);
    public static final ExcelPageDefinition ENVB6 = new ExcelPageDefinition(35, PageFormatFactory.ENVISOB6[0], PageFormatFactory.ENVISOB6[1]);
    public static final ExcelPageDefinition ENVELOPE = new ExcelPageDefinition(36, PageFormatFactory.ENVELOPE[0], PageFormatFactory.ENVELOPE[1]);
    public static final ExcelPageDefinition ENVMONARCH = new ExcelPageDefinition(37, PageFormatFactory.ENVMONARCH[0], PageFormatFactory.ENVMONARCH[1]);
    public static final ExcelPageDefinition ENVPERSONAL = new ExcelPageDefinition(38, PageFormatFactory.ENVPERSONAL[0], PageFormatFactory.ENVPERSONAL[1]);
    public static final ExcelPageDefinition FANFOLDUS = new ExcelPageDefinition(39, PageFormatFactory.FANFOLDUS[0], PageFormatFactory.FANFOLDUS[1]);
    public static final ExcelPageDefinition FANFOLDGERMAN = new ExcelPageDefinition(40, PageFormatFactory.FANFOLDGERMAN[0], PageFormatFactory.FANFOLDGERMAN[1]);
    public static final ExcelPageDefinition FANFOLDGERMANLEGAL = new ExcelPageDefinition(41, PageFormatFactory.FANFOLDGERMANLEGAL[0], PageFormatFactory.FANFOLDGERMANLEGAL[1]);
    static /* synthetic */ Class class$org$jfree$report$modules$output$table$xls$util$ExcelPrintSetupFactory;
    static /* synthetic */ Class class$org$jfree$report$modules$output$table$xls$util$ExcelPageDefinition;

    private ExcelPrintSetupFactory() {
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    private static short computePaperSize(PageFormat format) {
        ExcelPageDefinition pageDef = null;
        int width = (int)format.getPaper().getWidth();
        int height = (int)format.getPaper().getHeight();
        int delta = -1;
        Field[] fields = (class$org$jfree$report$modules$output$table$xls$util$ExcelPrintSetupFactory != null ? class$org$jfree$report$modules$output$table$xls$util$ExcelPrintSetupFactory : (class$org$jfree$report$modules$output$table$xls$util$ExcelPrintSetupFactory = ExcelPrintSetupFactory.class$("org.jfree.report.modules.output.table.xls.util.ExcelPrintSetupFactory"))).getDeclaredFields();
        int i = 0;
        while (i < fields.length) {
            Field field;
            if ((class$org$jfree$report$modules$output$table$xls$util$ExcelPageDefinition != null ? class$org$jfree$report$modules$output$table$xls$util$ExcelPageDefinition : ExcelPrintSetupFactory.class$("org.jfree.report.modules.output.table.xls.util.ExcelPageDefinition")).isAssignableFrom((field = fields[i]).getType()) && Modifier.isStatic(field.getModifiers())) {
                try {
                    ExcelPageDefinition pageformat = (ExcelPageDefinition)field.get(null);
                    if (pageformat.getWidth() >= width && pageformat.getHeight() >= height) {
                        int newDelta = pageformat.getWidth() - width + (pageformat.getHeight() - height);
                        if (delta == -1 || newDelta < delta) {
                            pageDef = pageformat;
                            delta = newDelta;
                        }
                    }
                }
                catch (IllegalAccessException illegalAccessException) {}
            }
            ++i;
        }
        if (pageDef == null) {
            return -1;
        }
        return pageDef.getPageFormatCode();
    }

    private static short parsePaperSizeProperty(String paper) {
        if (paper == null) {
            return -1;
        }
        try {
            Field field = (class$org$jfree$report$modules$output$table$xls$util$ExcelPrintSetupFactory != null ? class$org$jfree$report$modules$output$table$xls$util$ExcelPrintSetupFactory : (class$org$jfree$report$modules$output$table$xls$util$ExcelPrintSetupFactory = ExcelPrintSetupFactory.class$("org.jfree.report.modules.output.table.xls.util.ExcelPrintSetupFactory"))).getDeclaredField(paper);
            if (!(class$org$jfree$report$modules$output$table$xls$util$ExcelPageDefinition != null ? class$org$jfree$report$modules$output$table$xls$util$ExcelPageDefinition : (class$org$jfree$report$modules$output$table$xls$util$ExcelPageDefinition = ExcelPrintSetupFactory.class$("org.jfree.report.modules.output.table.xls.util.ExcelPageDefinition"))).isAssignableFrom(field.getType())) {
                return -1;
            }
            Object o = field.get(null);
            ExcelPageDefinition pageformat = (ExcelPageDefinition)o;
            return pageformat.getPageFormatCode();
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return -1;
        }
        catch (IllegalAccessException illegalAccessException) {
            return -1;
        }
    }

    public static void performPageSetup(HSSFPrintSetup printSetup, PageDefinition pageformat, String paperdef, String paperOrientation) {
        short pageCode = ExcelPrintSetupFactory.parsePaperSizeProperty(paperdef);
        if (pageCode == -1) {
            pageCode = ExcelPrintSetupFactory.computePaperSize(pageformat.getPageFormat(0));
        }
        if (pageCode != -1) {
            printSetup.setPaperSize(pageCode);
        }
        if (paperOrientation != null) {
            printSetup.setLandscape(paperOrientation.equalsIgnoreCase("Landscape"));
        } else {
            printSetup.setLandscape(pageformat.getPageFormat(0).getOrientation() != 1);
        }
    }
}

