/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.parser.simple.readhandlers;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import org.jfree.report.Element;
import org.jfree.report.JFreeReport;
import org.jfree.report.elementfactory.ElementFactory;
import org.jfree.report.modules.parser.base.AbstractPropertyXmlReadHandler;
import org.jfree.report.modules.parser.base.CommentHintPath;
import org.jfree.report.modules.parser.base.PropertyAttributes;
import org.jfree.report.style.ElementStyleSheet;
import org.jfree.ui.FloatDimension;
import org.jfree.xml.ParserUtil;
import org.jfree.xml.parser.XmlReaderException;
import org.xml.sax.SAXException;

public abstract class AbstractElementReadHandler
extends AbstractPropertyXmlReadHandler {
    public static final String FONT_NAME_ATT = "fontname";
    public static final String FONT_STYLE_ATT = "fontstyle";
    public static final String FONT_SIZE_ATT = "fontsize";
    public static final String FS_BOLD = "fsbold";
    public static final String FS_ITALIC = "fsitalic";
    public static final String FS_UNDERLINE = "fsunderline";
    public static final String FS_STRIKETHR = "fsstrikethr";
    public static final String FS_EMBEDDED = "font-embedded";
    public static final String FS_ENCODING = "font-encoding";
    public static final String LINEHEIGHT = "line-height";
    public static final String NAME_ATT = "name";
    public static final String ALIGNMENT_ATT = "alignment";
    public static final String VALIGNMENT_ATT = "vertical-alignment";
    public static final String COLOR_ATT = "color";
    public static final String FIELDNAME_ATT = "fieldname";
    public static final String FUNCTIONNAME_ATT = "function";
    public static final String NULLSTRING_ATT = "nullstring";
    private static final String DYNAMIC_ATT = "dynamic";
    private static final String LAYOUT_CACHABLE_ATT = "layout-cachable";
    private static final String VISIBLE_ATT = "visible";
    private static final String HREF_ATT = "href";
    public static final String STYLE_CLASS_ATT = "styleClass";
    private Element element;
    private String styleClass;

    protected void doneParsing() throws SAXException, XmlReaderException {
        this.element = this.getElementFactory().createElement();
        if (this.styleClass != null) {
            JFreeReport report = (JFreeReport)this.getRootHandler().getHelperObject("::report");
            ElementStyleSheet styleSheet = report.getStyleSheetCollection().getStyleSheet(this.styleClass);
            this.element.getStyle().addParent(styleSheet);
        }
        super.doneParsing();
    }

    private Dimension2D getElementDimension(PropertyAttributes atts) throws SAXException {
        float w = ParserUtil.parseRelativeFloat((String)atts.getValue("width"), (String)"Element width not specified");
        float h = ParserUtil.parseRelativeFloat((String)atts.getValue("height"), (String)"Element height not specified");
        return new FloatDimension(w, h);
    }

    protected abstract ElementFactory getElementFactory();

    protected final Point2D getElementPosition(PropertyAttributes atts) throws SAXException {
        String xValue = atts.getValue("x");
        String yValue = atts.getValue("y");
        if (xValue == null && yValue == null) {
            return null;
        }
        float x = xValue != null ? ParserUtil.parseRelativeFloat((String)xValue, (String)"Element x not specified") : 0.0f;
        float y = yValue != null ? ParserUtil.parseRelativeFloat((String)yValue, (String)"Element y not specified") : 0.0f;
        return new Point2D.Float(x, y);
    }

    public Object getObject() throws XmlReaderException {
        return this.element;
    }

    protected void startParsing(PropertyAttributes atts) throws SAXException, XmlReaderException {
        String href;
        String visibleValue;
        String layoutCachableValue;
        ElementFactory factory = this.getElementFactory();
        factory.setName(atts.getValue(NAME_ATT));
        this.styleClass = atts.getValue(STYLE_CLASS_ATT);
        Point2D elementPosition = this.getElementPosition(atts);
        if (elementPosition != null) {
            factory.setAbsolutePosition(elementPosition);
        }
        factory.setMinimumSize(this.getElementDimension(atts));
        String dynamicValue = atts.getValue(DYNAMIC_ATT);
        if (dynamicValue != null) {
            boolean dynamic = ParserUtil.parseBoolean((String)dynamicValue, (boolean)false);
            factory.setDynamicHeight(dynamic ? Boolean.TRUE : Boolean.FALSE);
        }
        if ((layoutCachableValue = atts.getValue(LAYOUT_CACHABLE_ATT)) != null) {
            boolean value = ParserUtil.parseBoolean((String)layoutCachableValue, (boolean)true);
            factory.setLayoutCachable(value ? Boolean.TRUE : Boolean.FALSE);
        }
        if ((visibleValue = atts.getValue(VISIBLE_ATT)) != null) {
            boolean value = ParserUtil.parseBoolean((String)visibleValue, (boolean)true);
            factory.setVisible(value ? Boolean.TRUE : Boolean.FALSE);
        }
        if ((href = atts.getValue(HREF_ATT)) != null) {
            factory.setHRefTarget(href);
        }
    }

    protected void storeComments() throws SAXException {
        CommentHintPath commentHintPath = new CommentHintPath(this.element);
        this.defaultStoreComments(commentHintPath);
    }
}

