/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.util;

import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import org.jfree.report.util.SerializeMethod;
import org.jfree.report.util.serializers.BandLayoutManagerSerializer;
import org.jfree.report.util.serializers.BasicStrokeSerializer;
import org.jfree.report.util.serializers.ColorSerializer;
import org.jfree.report.util.serializers.Dimension2DSerializer;
import org.jfree.report.util.serializers.Ellipse2DSerializer;
import org.jfree.report.util.serializers.GeneralPathSerializer;
import org.jfree.report.util.serializers.Line2DSerializer;
import org.jfree.report.util.serializers.PageFormatSerializer;
import org.jfree.report.util.serializers.Point2DSerializer;
import org.jfree.report.util.serializers.Rectangle2DSerializer;
import org.jfree.util.ClassComparator;

public class SerializerHelper {
    private static SerializerHelper singleton;
    private final HashMap methods;
    private final ClassComparator comparator = new ClassComparator();

    protected SerializerHelper() {
        this.methods = new HashMap();
    }

    protected ClassComparator getComparator() {
        return this.comparator;
    }

    public static synchronized SerializerHelper getInstance() {
        if (singleton == null) {
            singleton = new SerializerHelper();
            singleton.registerMethod(new BasicStrokeSerializer());
            singleton.registerMethod(new ColorSerializer());
            singleton.registerMethod(new Dimension2DSerializer());
            singleton.registerMethod(new Ellipse2DSerializer());
            singleton.registerMethod(new Line2DSerializer());
            singleton.registerMethod(new Point2DSerializer());
            singleton.registerMethod(new Rectangle2DSerializer());
            singleton.registerMethod(new BandLayoutManagerSerializer());
            singleton.registerMethod(new PageFormatSerializer());
            singleton.registerMethod(new GeneralPathSerializer());
        }
        return singleton;
    }

    protected HashMap getMethods() {
        return this.methods;
    }

    protected SerializeMethod getSerializer(Class c) {
        SerializeMethod sm = (SerializeMethod)this.methods.get(c);
        if (sm != null) {
            return sm;
        }
        return this.getSuperClassObjectDescription(c, null);
    }

    protected SerializeMethod getSuperClassObjectDescription(Class d, SerializeMethod knownSuperClass) {
        Iterator keys = this.methods.keySet().iterator();
        while (keys.hasNext()) {
            Class keyClass = (Class)keys.next();
            if (!keyClass.isAssignableFrom(d)) continue;
            SerializeMethod od = (SerializeMethod)this.methods.get(keyClass);
            if (knownSuperClass == null) {
                knownSuperClass = od;
                continue;
            }
            if (!this.comparator.isComparable(knownSuperClass.getObjectClass(), od.getObjectClass()) || this.comparator.compare((Object)knownSuperClass.getObjectClass(), (Object)od.getObjectClass()) >= 0) continue;
            knownSuperClass = od;
        }
        return knownSuperClass;
    }

    public Object readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        byte type = in.readByte();
        if (type == 0) {
            return null;
        }
        if (type == 1) {
            return in.readObject();
        }
        Class c = (Class)in.readObject();
        SerializeMethod m = this.getSerializer(c);
        if (m == null) {
            throw new NotSerializableException(c.getName());
        }
        return m.readObject(in);
    }

    public void registerMethod(SerializeMethod method) {
        this.methods.put(method.getObjectClass(), method);
    }

    protected static void setInstance(SerializerHelper helper) {
        singleton = helper;
    }

    public void unregisterMethod(SerializeMethod method) {
        this.methods.remove(method.getObjectClass());
    }

    public void writeObject(Object o, ObjectOutputStream out) throws IOException {
        if (o == null) {
            out.writeByte(0);
            return;
        }
        if (o instanceof Serializable) {
            out.writeByte(1);
            out.writeObject(o);
            return;
        }
        SerializeMethod m = this.getSerializer(o.getClass());
        if (m == null) {
            throw new NotSerializableException(o.getClass().getName());
        }
        out.writeByte(2);
        out.writeObject(m.getObjectClass());
        m.writeObject(o, out);
    }
}

