/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.util;

public final class StringUtil {
    private StringUtil() {
    }

    public static boolean endsWithIgnoreCase(String base, String end) {
        if (base.length() < end.length()) {
            return false;
        }
        return base.regionMatches(true, base.length() - end.length(), end, 0, end.length());
    }

    public static boolean parseBoolean(String attribute, boolean defaultValue) {
        if (attribute == null) {
            return defaultValue;
        }
        return attribute.equals("true");
    }

    public static float parseFloat(String value, float defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        try {
            return Float.parseFloat(value);
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public static int parseInt(String value, int defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public static boolean startsWithIgnoreCase(String base, String start) {
        if (base.length() < start.length()) {
            return false;
        }
        return base.regionMatches(true, 0, start, 0, start.length());
    }
}

