/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.util.geom;

import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import org.jfree.report.util.geom.StrictBounds;
import org.jfree.report.util.geom.StrictDimension;
import org.jfree.report.util.geom.StrictPoint;
import org.jfree.ui.FloatDimension;

public class StrictGeomUtility {
    private static final float CORRECTION_FACTOR = 1000.0f;

    private StrictGeomUtility() {
    }

    public static Dimension2D createAWTDimension(long width, long height) {
        return new FloatDimension((float)width / 1000.0f, (float)height / 1000.0f);
    }

    public static Rectangle2D createAWTRectangle(long x, long y, long width, long height) {
        return new Rectangle2D.Double((float)x / 1000.0f, (float)y / 1000.0f, (float)width / 1000.0f, (float)height / 1000.0f);
    }

    public static StrictBounds createBounds(double x, double y, double width, double height) {
        return new StrictBounds((long)(x * 1000.0), (long)(y * 1000.0), (long)(width * 1000.0), (long)(height * 1000.0));
    }

    public static StrictDimension createDimension(double w, double h) {
        return new StrictDimension((long)(w * 1000.0), (long)(h * 1000.0));
    }

    public static StrictPoint createPoint(double x, double y) {
        return new StrictPoint((long)(x * 1000.0), (long)(y * 1000.0));
    }

    public static double toExternalValue(long value) {
        return (float)value / 1000.0f;
    }

    public static long toInternalValue(double value) {
        return (long)(value * 1000.0);
    }
}

