/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.animation.components;

import com.jgoodies.animation.renderer.BasicTextRenderer;
import com.jgoodies.animation.renderer.HeightMode;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JComponent;

public final class BasicTextLabel
extends JComponent {
    private final BasicTextRenderer renderer;

    public BasicTextLabel(String text) {
        this.renderer = new BasicTextRenderer(text);
    }

    public Color getColor() {
        return this.renderer.getColor();
    }

    public HeightMode getHeightMode() {
        return this.renderer.getHeightMode();
    }

    public float getScaleX() {
        return this.renderer.getScaleX();
    }

    public float getScaleY() {
        return this.renderer.getScaleY();
    }

    public float getSpace() {
        return this.renderer.getSpace();
    }

    public float getOffsetX() {
        return this.renderer.getOffsetX();
    }

    public float getOffsetY() {
        return this.renderer.getOffsetY();
    }

    public String getText() {
        return this.renderer.getText();
    }

    public void setColor(Color color) {
        this.renderer.setColor(color);
        this.repaint();
    }

    public void setHeightMode(HeightMode heightMode) {
        this.renderer.setHeightMode(heightMode);
    }

    public void setScale(float scale) {
        this.renderer.setScaleX(scale);
        this.renderer.setScaleY(scale);
        this.repaint();
    }

    public void setScaleX(float scaleX) {
        this.renderer.setScaleX(scaleX);
        this.repaint();
    }

    public void setScaleY(float scaleY) {
        this.renderer.setScaleY(scaleY);
        this.repaint();
    }

    public void setSpace(float space) {
        this.renderer.setSpace(space);
        this.repaint();
    }

    public void setOffsetX(float offsetX) {
        this.renderer.setOffsetX(offsetX);
        this.repaint();
    }

    public void setOffsetY(float offsetY) {
        this.renderer.setOffsetY(offsetY);
        this.repaint();
    }

    public void setText(String newText) {
        this.renderer.setText(newText);
        this.repaint();
    }

    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        this.renderer.setFont(this.getFont());
        this.renderer.render(g2, this.getWidth(), this.getHeight());
    }
}

