/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.binding.adapter;

import com.jgoodies.binding.value.AbstractValueModel;
import java.util.prefs.Preferences;

public final class PreferencesAdapter
extends AbstractValueModel {
    private static final String ERROR_MSG = "Value must be a Boolean, Double, Float, Integer, Long, or String.";
    private final Preferences prefs;
    private final String key;
    private final Class type;
    private final Object defaultValue;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;

    public PreferencesAdapter(Preferences prefs, String key, Object defaultValue) {
        this.prefs = prefs;
        this.key = key;
        this.type = defaultValue.getClass();
        this.defaultValue = defaultValue;
    }

    public Object getValue() {
        if (this.type == (class$java$lang$String == null ? (class$java$lang$String = PreferencesAdapter.class$("java.lang.String")) : class$java$lang$String)) {
            return this.prefs.get(this.key, null);
        }
        if (this.type == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = PreferencesAdapter.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            return this.getBoolean();
        }
        if (this.type == (class$java$lang$Double == null ? (class$java$lang$Double = PreferencesAdapter.class$("java.lang.Double")) : class$java$lang$Double)) {
            return new Double(this.getDouble());
        }
        if (this.type == (class$java$lang$Float == null ? (class$java$lang$Float = PreferencesAdapter.class$("java.lang.Float")) : class$java$lang$Float)) {
            return new Float(this.getFloat());
        }
        if (this.type == (class$java$lang$Integer == null ? (class$java$lang$Integer = PreferencesAdapter.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            return new Integer(this.getInt());
        }
        if (this.type == (class$java$lang$Long == null ? (class$java$lang$Long = PreferencesAdapter.class$("java.lang.Long")) : class$java$lang$Long)) {
            return new Long(this.getLong());
        }
        if (this.type == (class$java$lang$String == null ? (class$java$lang$String = PreferencesAdapter.class$("java.lang.String")) : class$java$lang$String)) {
            return this.getString();
        }
        throw new ClassCastException(ERROR_MSG);
    }

    public void setValue(Object newValue) {
        Object value = this.getValue();
        if (value == null && newValue == null || value != null && value.equals(newValue)) {
            return;
        }
        if (newValue instanceof Boolean) {
            this.setBoolean((Boolean)newValue);
        } else if (newValue instanceof Float) {
            this.setFloat(((Float)newValue).floatValue());
        } else if (newValue instanceof Integer) {
            this.setInt((Integer)newValue);
        } else if (newValue instanceof Long) {
            this.setLong((Long)newValue);
        } else if (newValue instanceof String) {
            this.setString((String)newValue);
        } else {
            throw new IllegalArgumentException(ERROR_MSG);
        }
    }

    public boolean getBoolean() {
        return this.prefs.getBoolean(this.key, (Boolean)this.defaultValue);
    }

    public double getDouble() {
        return this.prefs.getDouble(this.key, (Double)this.defaultValue);
    }

    public float getFloat() {
        return this.prefs.getFloat(this.key, ((Float)this.defaultValue).floatValue());
    }

    public int getInt() {
        return this.prefs.getInt(this.key, (Integer)this.defaultValue);
    }

    public long getLong() {
        return this.prefs.getLong(this.key, (Long)this.defaultValue);
    }

    public String getString() {
        return this.prefs.get(this.key, (String)this.defaultValue);
    }

    public void setBoolean(boolean newValue) {
        boolean oldValue = this.getBoolean();
        this.prefs.putBoolean(this.key, newValue);
        this.fireValueChange(oldValue, newValue);
    }

    public void setDouble(double newValue) {
        double oldValue = this.getDouble();
        this.prefs.putDouble(this.key, newValue);
        this.fireValueChange(oldValue, newValue);
    }

    public void setFloat(float newValue) {
        float oldValue = this.getFloat();
        this.prefs.putFloat(this.key, newValue);
        this.fireValueChange(oldValue, newValue);
    }

    public void setInt(int newValue) {
        int oldValue = this.getInt();
        this.prefs.putInt(this.key, newValue);
        this.fireValueChange(oldValue, newValue);
    }

    public void setLong(long newValue) {
        long oldValue = this.getLong();
        this.prefs.putLong(this.key, newValue);
        this.fireValueChange(oldValue, newValue);
    }

    public void setString(String newValue) {
        String oldValue = this.getString();
        this.prefs.put(this.key, newValue);
        this.fireValueChange(oldValue, newValue);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

