/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.cellview;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.UIManager;
import org.jgraph.JGraph;
import org.jgraph.cellview.JGraphMultilineView;
import org.jgraph.graph.CellMapper;
import org.jgraph.graph.CellView;
import org.jgraph.graph.CellViewRenderer;
import org.jgraph.graph.GraphCellEditor;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.VertexView;

public class JGraphIconView
extends VertexView {
    private MyMultiLinedEditor editor = new MyMultiLinedEditor();
    protected static IconRenderer viewRenderer = new IconRenderer();
    private boolean isMouseOver;

    public JGraphIconView(Object object, JGraph jGraph, CellMapper cellMapper) {
        super(object, jGraph, cellMapper);
    }

    public GraphCellEditor getEditor() {
        return this.editor;
    }

    public boolean isMouseOver() {
        return this.isMouseOver;
    }

    public void setMouseOver(boolean bl) {
        this.isMouseOver = bl;
    }

    public Point2D getCenterPoint() {
        Dimension dimension = ((IconRenderer)this.getRendererComponent(this.getGraph(), false, false, false)).getIconDisplay().getPreferredSize();
        return this.getAttributes().createPoint(this.getBounds().getX() + dimension.getWidth() / 2.0, this.getBounds().getY() + dimension.getHeight() / 2.0);
    }

    public Point2D getPerimeterPoint(Point2D point2D, Point2D point2D2) {
        Rectangle2D rectangle2D = this.getBounds();
        Icon icon = GraphConstants.getIcon((Map)this.getAllAttributes());
        double d = icon.getIconWidth();
        double d2 = icon.getIconHeight();
        double d3 = rectangle2D.getX();
        double d4 = rectangle2D.getY();
        double d5 = d / 2.0;
        double d6 = d2 / 2.0;
        double d7 = Math.sqrt(1.0 - d6 / d5 * (d6 / d5));
        double d8 = rectangle2D.getWidth();
        double d9 = viewRenderer.getIconDisplay().getPreferredSize().getHeight();
        double d10 = d3 + d8 / 2.0;
        double d11 = d4 + d9 / 2.0;
        double d12 = point2D2.getX() - d10;
        double d13 = point2D2.getY() - d11;
        double d14 = Math.atan2(d13, d12);
        double d15 = d7 * d7;
        double d16 = d5 * Math.sqrt((1.0 - d15) / (1.0 - d15 * (Math.cos(d14) * Math.cos(d14))));
        double d17 = d16 * Math.cos(d14);
        double d18 = d16 * Math.sin(d14);
        return new Point2D.Double(d17 + d10, d18 + d11);
    }

    public CellViewRenderer getRenderer() {
        return viewRenderer;
    }

    public static class DescriptionTextArea
    extends JEditorPane {
        private String description;

        public DescriptionTextArea(String string, String string2) {
            super(string, string2);
        }

        public void setDescription(String string) {
            this.description = string;
            this.setText(this.description);
        }

        public void setText(String string) {
            if (string != null && !string.equals("")) {
                string = string.replaceAll("\n", "<br>");
                super.setText("<center><font color=\"#337733\" face=Arial size=-1>" + string + "</font></center>");
            } else {
                super.setText("");
            }
        }
    }

    public static class IconDisplay
    extends JLabel {
        public IconDisplay() {
            this.setVerticalAlignment(0);
            this.setHorizontalAlignment(0);
            this.setHorizontalTextPosition(0);
            this.setVerticalTextPosition(3);
            this.setFont(UIManager.getFont("Tree.font"));
            this.setForeground(UIManager.getColor("Tree.textForeground"));
            this.setBackground(UIManager.getColor("Tree.textBackground"));
        }

        public Dimension getMinimumSize() {
            Dimension dimension = super.getMinimumSize();
            dimension.setSize(dimension.getWidth(), dimension.getHeight() + 2.0);
            return dimension;
        }

        public Dimension getPreferredSize() {
            return this.getMinimumSize();
        }

        public void paint(Graphics graphics) {
            this.setBackground(Color.white);
            this.setBorder(null);
            if (!((IconRenderer)this.getParent()).isPreview()) {
                super.paint(graphics);
            } else {
                graphics.setColor(Color.BLACK);
                Dimension dimension = this.getSize();
                graphics.drawOval(dimension.width / 2 - 20, dimension.height / 2 - 20, 40, 40);
            }
        }
    }

    public static class IconRenderer
    extends JComponent
    implements CellViewRenderer {
        private IconDisplay iconDisplay = new IconDisplay();
        private DescriptionTextArea textRenderer = new DescriptionTextArea("text/html", "");
        private JGraphIconView view;
        private boolean isSelected;
        private boolean isFocused;
        private boolean isPreview;

        public IconRenderer() {
            this.textRenderer.setOpaque(true);
            this.iconDisplay.setOpaque(false);
            GridBagLayout gridBagLayout = new GridBagLayout();
            this.setLayout(gridBagLayout);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 2;
            gridBagLayout.setConstraints(this.iconDisplay, gridBagConstraints);
            this.add(this.iconDisplay);
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 1;
            gridBagConstraints2.gridwidth = 1;
            gridBagConstraints2.gridheight = 0;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.weighty = 1.0;
            gridBagConstraints2.fill = 1;
            gridBagConstraints2.insets = new Insets(3, 3, 3, 3);
            gridBagLayout.setConstraints(this.textRenderer, gridBagConstraints2);
            this.add(this.textRenderer);
        }

        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            dimension.setSize(dimension.getWidth() + 40.0, dimension.getHeight());
            return dimension;
        }

        public Component getRendererComponent(JGraph jGraph, CellView cellView, boolean bl, boolean bl2, boolean bl3) {
            if (cellView instanceof JGraphIconView) {
                if (jGraph.getEditingCell() != cellView.getCell()) {
                    this.setBackground(Color.white);
                }
                this.view = (JGraphIconView)cellView;
                this.isSelected = bl;
                this.isFocused = bl2;
                this.isPreview = bl3;
                this.iconDisplay.setIcon(GraphConstants.getIcon((Map)cellView.getAllAttributes()));
                this.textRenderer.setDescription(jGraph.convertValueToString((Object)cellView));
                return this;
            }
            return null;
        }

        public JGraphIconView getView() {
            return this.view;
        }

        public boolean isSelected() {
            return this.isSelected;
        }

        public boolean isFocused() {
            return this.isFocused;
        }

        public boolean isPreview() {
            return this.isPreview;
        }

        public IconDisplay getIconDisplay() {
            return this.iconDisplay;
        }
    }

    class MyMultiLinedEditor
    extends JGraphMultilineView.MultiLinedEditor {
        MyMultiLinedEditor() {
        }

        public Component getGraphCellEditorComponent(JGraph jGraph, Object object, boolean bl) {
            Component component = super.getGraphCellEditorComponent(jGraph, object, bl);
            Dimension dimension = ((IconRenderer)JGraphIconView.this.getRendererComponent(jGraph, false, false, false)).getIconDisplay().getPreferredSize();
            this.offsetY = (int)dimension.getHeight();
            return component;
        }
    }
}

