/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.cellview;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.geom.Rectangle2D;
import java.util.EventObject;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.jgraph.JGraph;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.CellMapper;
import org.jgraph.graph.CellView;
import org.jgraph.graph.CellViewRenderer;
import org.jgraph.graph.DefaultGraphCellEditor;
import org.jgraph.graph.GraphCellEditor;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.VertexView;

public class JGraphMultilineView
extends VertexView {
    static final MultiLinedRenderer renderer = new MultiLinedRenderer();
    static final MultiLinedEditor editor = new MultiLinedEditor();

    public JGraphMultilineView(Object object, JGraph jGraph, CellMapper cellMapper) {
        super(object, jGraph, cellMapper);
    }

    public CellViewRenderer getRenderer() {
        return renderer;
    }

    public GraphCellEditor getEditor() {
        return editor;
    }

    public static class MultiLinedRenderer
    extends JTextArea
    implements CellViewRenderer {
        protected transient JGraph graph = null;
        protected transient Color gradientColor = null;
        protected transient boolean hasFocus;
        protected transient boolean selected;
        protected transient boolean preview;

        public MultiLinedRenderer() {
            this.setLineWrap(true);
            this.setWrapStyleWord(true);
        }

        public Component getRendererComponent(JGraph jGraph, CellView cellView, boolean bl, boolean bl2, boolean bl3) {
            this.setText(cellView.getCell().toString());
            this.graph = jGraph;
            this.selected = bl;
            this.preview = bl3;
            this.hasFocus = bl2;
            AttributeMap attributeMap = cellView.getAllAttributes();
            this.installAttributes(jGraph, (Map)attributeMap);
            return this;
        }

        public void paint(Graphics graphics) {
            try {
                if (this.gradientColor != null && !this.preview) {
                    this.setOpaque(false);
                    Graphics2D graphics2D = (Graphics2D)graphics;
                    graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, this.getBackground(), this.getWidth(), this.getHeight(), this.gradientColor, true));
                    graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
                }
                super.paint(graphics);
                this.paintSelectionBorder(graphics);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }

        protected void paintSelectionBorder(Graphics graphics) {
            ((Graphics2D)graphics).setStroke(GraphConstants.SELECTION_STROKE);
            if (this.hasFocus && this.selected) {
                graphics.setColor(this.graph.getLockedHandleColor());
            } else if (this.selected) {
                graphics.setColor(this.graph.getHighlightColor());
            }
            if (this.selected) {
                Dimension dimension = this.getSize();
                graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
            }
        }

        protected void installAttributes(JGraph jGraph, Map map) {
            this.setOpaque(GraphConstants.isOpaque((Map)map));
            Color color = GraphConstants.getForeground((Map)map);
            this.setForeground(color != null ? color : jGraph.getForeground());
            Color color2 = GraphConstants.getBackground((Map)map);
            this.setBackground(color2 != null ? color2 : jGraph.getBackground());
            Font font = GraphConstants.getFont((Map)map);
            this.setFont(font != null ? font : jGraph.getFont());
            Border border = GraphConstants.getBorder((Map)map);
            Color color3 = GraphConstants.getBorderColor((Map)map);
            if (border != null) {
                this.setBorder(border);
            } else if (color3 != null) {
                int n = Math.max(1, Math.round(GraphConstants.getLineWidth((Map)map)));
                this.setBorder(BorderFactory.createLineBorder(color3, n));
            }
            this.gradientColor = GraphConstants.getGradientColor((Map)map);
        }
    }

    public static class MultiLinedEditor
    extends DefaultGraphCellEditor {
        public Component getGraphCellEditorComponent(JGraph jGraph, Object object, boolean bl) {
            Component component = super.getGraphCellEditorComponent(jGraph, object, bl);
            CellView cellView = jGraph.getGraphLayoutCache().getMapping(object, false);
            Rectangle2D rectangle2D = cellView.getBounds();
            this.editingComponent.setBounds((int)rectangle2D.getX(), (int)rectangle2D.getY(), (int)rectangle2D.getWidth(), (int)rectangle2D.getHeight());
            Font font = GraphConstants.getFont((Map)cellView.getAllAttributes());
            this.editingComponent.setFont(font != null ? font : jGraph.getFont());
            return component;
        }

        protected GraphCellEditor createGraphCellEditor() {
            return new RealCellEditor();
        }

        protected Container createContainer() {
            return new ModifiedEditorContainer();
        }

        class ModifiedEditorContainer
        extends DefaultGraphCellEditor.EditorContainer {
            ModifiedEditorContainer() {
                super((DefaultGraphCellEditor)MultiLinedEditor.this);
            }

            public void doLayout() {
                super.doLayout();
                Dimension dimension = this.getSize();
                Dimension dimension2 = MultiLinedEditor.this.editingComponent.getSize();
                MultiLinedEditor.this.editingComponent.setSize(dimension2.width - 2, dimension2.height);
                this.setSize(dimension.width, this.getPreferredSize().height);
            }
        }

        public class RealCellEditor
        extends AbstractCellEditor
        implements GraphCellEditor {
            JTextArea editorComponent = new JTextArea();

            public RealCellEditor() {
                this.editorComponent.setBorder(UIManager.getBorder("Tree.editorBorder"));
                this.editorComponent.setLineWrap(true);
                this.editorComponent.setWrapStyleWord(true);
                this.editorComponent.getInputMap(0).put(KeyStroke.getKeyStroke(10, 0), "enter");
                this.editorComponent.getInputMap(0).put(KeyStroke.getKeyStroke(10, 64), "shiftEnter");
                this.editorComponent.getInputMap(0).put(KeyStroke.getKeyStroke(10, 128), "metaEnter");
                this.editorComponent.getInputMap(0).put(KeyStroke.getKeyStroke(10, 0), "enter");
                this.editorComponent.getActionMap().put("enter", new AbstractAction(this){
                    private final /* synthetic */ RealCellEditor this$1;
                    {
                        this.this$1 = realCellEditor;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        this.this$1.stopCellEditing();
                    }
                });
                AbstractAction abstractAction = new AbstractAction(this){
                    private final /* synthetic */ RealCellEditor this$1;
                    {
                        this.this$1 = realCellEditor;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        Document document = this.this$1.editorComponent.getDocument();
                        try {
                            document.insertString(this.this$1.editorComponent.getCaretPosition(), "\n", null);
                        }
                        catch (BadLocationException badLocationException) {
                            badLocationException.printStackTrace();
                        }
                    }
                };
                this.editorComponent.getActionMap().put("shiftEnter", abstractAction);
                this.editorComponent.getActionMap().put("metaEnter", abstractAction);
            }

            public Component getGraphCellEditorComponent(JGraph jGraph, Object object, boolean bl) {
                this.editorComponent.setText(object.toString());
                this.editorComponent.selectAll();
                return this.editorComponent;
            }

            public Object getCellEditorValue() {
                return this.editorComponent.getText();
            }

            public boolean stopCellEditing() {
                CellView cellView = MultiLinedEditor.this.graph.getGraphLayoutCache().getMapping(MultiLinedEditor.this.graph.getEditingCell(), false);
                AttributeMap attributeMap = cellView.getAllAttributes();
                Rectangle2D rectangle2D = GraphConstants.getBounds((Map)attributeMap);
                Rectangle rectangle = this.editorComponent.getBounds();
                GraphConstants.setBounds((Map)attributeMap, (Rectangle2D)new Rectangle((int)rectangle2D.getX(), (int)rectangle2D.getY(), rectangle.width, rectangle.height));
                return super.stopCellEditing();
            }

            public boolean shouldSelectCell(EventObject eventObject) {
                this.editorComponent.requestFocus();
                return super.shouldSelectCell(eventObject);
            }
        }
    }
}

