/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.layout;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import org.jgraph.layout.AnnealingLayoutAlgorithm;
import org.jgraph.layout.JGraphLayoutSettings;

public class AnnealingLayoutSettings
extends JPanel
implements JGraphLayoutSettings {
    public static final String KEY_TITLE = "Simulated Annealing";
    public static final String KEY_CONFIG_NAME = "CONFIG_NAME";
    public static final String KEY_INIT_TEMPERATURE = "Start Temperature";
    public static final String KEY_MIN_TEMPERATURE = "min. Temperature";
    public static final String KEY_MIN_DISTANCE = "min. Distance";
    public static final String KEY_TEMP_SCALE_FACTOR = "Temperature Scalefactor";
    public static final String KEY_COMPUTE_PERMUTATION = "should compute per Permutation";
    public static final String KEY_IS_UPHILL_MOVE_ALLOWED = "are Uphill-Moves allowed";
    public static final String KEY_MAX_ROUNDS = "max. Rounds";
    public static final String KEY_TRIES_PER_CELL = "tries per cell";
    public static final String KEY_COST_FUNCTION_CONFIG = "Costfunction Config";
    public static final String KEY_LAMBDA = "Lambda";
    public static final String KEY_BOUNDS = "Bounds of resulting graph";
    public static final String KEY_LAYOUT_UPDATE_INIT_TEMPERATURE = "Layout Update Start Temperature";
    public static final String KEY_LAYOUT_UPDATE_MIN_TEMPERATURE = "Layout Update min. Temperature";
    public static final String KEY_LAYOUT_UPDATE_MIN_DISTANCE = "Layout Update min. Distance";
    public static final String KEY_LAYOUT_UPDATE_TEMP_SCALE_FACTOR = "Layout Update Temperature Scalefactor";
    public static final String KEY_LAYOUT_UPDATE_COMPUTE_PERMUTATION = "Layout Update should compute per Permutation";
    public static final String KEY_LAYOUT_UPDATE_IS_UPHILL_MOVE_ALLOWED = "Layout Update are Uphill-Moves allowed";
    public static final String KEY_LAYOUT_UPDATE_MAX_ROUNDS = "Layout Update max. Rounds";
    public static final String KEY_LAYOUT_UPDATE_TRIES_PER_CELL = "Layout Update tries per cell";
    public static final String KEY_LAYOUT_UPDATE_COST_FUNCTION_CONFIG = "Layout Update Costfunction Config";
    public static final String KEY_LAYOUT_UPDATE_LAMBDA = "Layout Update Lambda";
    public static final String KEY_LAYOUT_UPDATE_BOUNDS = "Layout Update Bounds of resulting graph";
    public static final String KEY_LAYOUT_UPDATE_METHOD = "Layout Update Method";
    public static final String KEY_LAYOUT_UPDATE_METHOD_NEIGHBORS_ONLY = "Layout Update Method Neighbors only";
    public static final String KEY_LAYOUT_UPDATE_METHOD_PERIMETER = "Layout Update Method Perimeter";
    public static final String KEY_LAYOUT_UPDATE_METHOD_NEIGHBORS_DEPTH = "Layout Update Method Neighbors depth";
    public static final String KEY_LAYOUT_UPDATE_METHOD_PERIMETER_RADIUS = "Layout Update Method Perimeter radius";
    public static final String KEY_LAYOUT_UPDATE_METHOD_PERIMETER_RADIUS_INCREASE = "Layout Update Method Perimeter radius increase";
    public static final String KEY_LAYOUT_UPDATE_ENABLED = "Layout Update enabled";
    public static final String KEY_LAYOUT_UPDATE_CLUSTERING_ENABLED = "Layout Update clustering enabled";
    public static final String KEY_LAYOUT_UPDATE_CLUSTERING_FACTOR = "Layout Update clustering factor";
    public static final String KEY_LAYOUT_UPDATE_CLUSTERING_MOVE_SCALE = "Layout Update clustering move scaling factor";
    protected AnnealingLayoutAlgorithm layout;
    private JTextField tf_initTemperature;
    private JTextField tf_minTemperature;
    private JTextField tf_minDistance;
    private JTextField tf_tempScaleFactor;
    private JTextField tf_maxRounds;
    private JTextField tf_triesPerCell;
    private JTextField tf_lambdaNodeDistribution;
    private JTextField tf_lambdaBorderline;
    private JTextField tf_lambdaEdgeLength;
    private JTextField tf_lambdaEdgeCrossing;
    private JTextField tf_lambdaEdgeDistribution;
    private JTextField tf_lambdaNodeDistance;
    private JTextField tf_boundsWidth;
    private JTextField tf_boundsHeight;
    private JCheckBox cb_computePermutation;
    private JCheckBox cb_uphillMovesAllowed;
    private JCheckBox cb_useNodeDistribution;
    private JCheckBox cb_useBorderline;
    private JCheckBox cb_useEdgeLength;
    private JCheckBox cb_useEdgeCrossing;
    private JCheckBox cb_useEdgeDistribution;
    private JCheckBox cb_useNodeDistance;
    private JButton button_takeViewportSize;
    private JCheckBox cb_enableLayoutUpdate;
    private JTextField tf_lu_initTemperature;
    private JTextField tf_lu_minTemperature;
    private JTextField tf_lu_minDistance;
    private JTextField tf_lu_tempScaleFactor;
    private JTextField tf_lu_maxRounds;
    private JTextField tf_lu_triesPerCell;
    private JTextField tf_lu_lambdaNodeDistribution;
    private JTextField tf_lu_lambdaBorderline;
    private JTextField tf_lu_lambdaEdgeLength;
    private JTextField tf_lu_lambdaEdgeCrossing;
    private JTextField tf_lu_lambdaEdgeDistribution;
    private JTextField tf_lu_lambdaNodeDistance;
    private JTextField tf_lu_boundsWidth;
    private JTextField tf_lu_boundsHeight;
    private JTextField tf_lu_method_neighborsDepth;
    private JTextField tf_lu_method_perimeterRadius;
    private JTextField tf_lu_method_perimeterRadiusInc;
    private JTextField tf_lu_clustering_factor;
    private JTextField tf_lu_clustering_moveScale;
    private JCheckBox cb_lu_computePermutation;
    private JCheckBox cb_lu_uphillMovesAllowed;
    private JCheckBox cb_lu_useNodeDistribution;
    private JCheckBox cb_lu_useBorderline;
    private JCheckBox cb_lu_useEdgeLength;
    private JCheckBox cb_lu_useEdgeCrossing;
    private JCheckBox cb_lu_useEdgeDistribution;
    private JCheckBox cb_lu_useNodeDistance;
    private JCheckBox cb_lu_clustering_enable;
    private JButton button_lu_takeViewportSize;
    private JComboBox comb_loadPreSets;
    private JComboBox comb_lu_Method;
    protected Properties[] preSetConfigs;
    private JPanel panelSurface;
    private JPanel panelLUSurface;
    private JTabbedPane tp_main;
    JScrollPane panelSurfaceWrapper;
    JScrollPane panelLUSurfaceWrapper;
    private static final String CAPTION = "Simulated Annealing Layout Configuration";
    private boolean canceled = false;
    private boolean isOptimizer;

    public AnnealingLayoutSettings(AnnealingLayoutAlgorithm annealingLayoutAlgorithm, boolean bl) {
        this.layout = annealingLayoutAlgorithm;
        Properties[] propertiesArray = new Properties[2];
        propertiesArray[0] = new Properties();
        propertiesArray[0].put(KEY_CONFIG_NAME, "Default Values");
        propertiesArray[0].put(KEY_INIT_TEMPERATURE, "300.0");
        propertiesArray[0].put(KEY_MIN_TEMPERATURE, "2.0");
        propertiesArray[0].put(KEY_MIN_DISTANCE, "50.0");
        propertiesArray[0].put(KEY_TEMP_SCALE_FACTOR, "0.95");
        propertiesArray[0].put(KEY_COMPUTE_PERMUTATION, "true");
        propertiesArray[0].put(KEY_IS_UPHILL_MOVE_ALLOWED, "true");
        propertiesArray[0].put(KEY_MAX_ROUNDS, "10000");
        propertiesArray[0].put(KEY_TRIES_PER_CELL, "8");
        propertiesArray[0].put(KEY_COST_FUNCTION_CONFIG, "111110");
        ArrayList<Double> arrayList = new ArrayList<Double>();
        arrayList.add(new Double(1000.0));
        arrayList.add(new Double(100000.0));
        arrayList.add(new Double(0.02));
        arrayList.add(new Double(2000.0));
        arrayList.add(new Double(150.0));
        arrayList.add(new Double(1000000.0));
        propertiesArray[0].put(KEY_LAMBDA, arrayList);
        Rectangle rectangle = new Rectangle(0, 0, 1000, 700);
        propertiesArray[0].put(KEY_BOUNDS, rectangle);
        propertiesArray[0].put(KEY_LAYOUT_UPDATE_ENABLED, "false");
        propertiesArray[0].put(KEY_LAYOUT_UPDATE_INIT_TEMPERATURE, "40.0");
        propertiesArray[0].put(KEY_LAYOUT_UPDATE_MIN_TEMPERATURE, "2.0");
        propertiesArray[0].put(KEY_LAYOUT_UPDATE_MIN_DISTANCE, "50.0");
        propertiesArray[0].put(KEY_LAYOUT_UPDATE_TEMP_SCALE_FACTOR, "0.95");
        propertiesArray[0].put(KEY_LAYOUT_UPDATE_COMPUTE_PERMUTATION, "true");
        propertiesArray[0].put(KEY_LAYOUT_UPDATE_IS_UPHILL_MOVE_ALLOWED, "true");
        propertiesArray[0].put(KEY_LAYOUT_UPDATE_MAX_ROUNDS, "10000");
        propertiesArray[0].put(KEY_LAYOUT_UPDATE_TRIES_PER_CELL, "8");
        propertiesArray[0].put(KEY_LAYOUT_UPDATE_COST_FUNCTION_CONFIG, "111110");
        propertiesArray[0].put(KEY_LAYOUT_UPDATE_METHOD, KEY_LAYOUT_UPDATE_METHOD_PERIMETER);
        propertiesArray[0].put(KEY_LAYOUT_UPDATE_METHOD_NEIGHBORS_DEPTH, "1");
        propertiesArray[0].put(KEY_LAYOUT_UPDATE_METHOD_PERIMETER_RADIUS, "100.0");
        propertiesArray[0].put(KEY_LAYOUT_UPDATE_METHOD_PERIMETER_RADIUS_INCREASE, "20.0");
        ArrayList<Double> arrayList2 = new ArrayList<Double>();
        arrayList2.add(new Double(1000.0));
        arrayList2.add(new Double(100000.0));
        arrayList2.add(new Double(0.02));
        arrayList2.add(new Double(2000.0));
        arrayList2.add(new Double(150.0));
        arrayList2.add(new Double(1000000.0));
        propertiesArray[0].put(KEY_LAYOUT_UPDATE_LAMBDA, arrayList2);
        Rectangle rectangle2 = new Rectangle(0, 0, 1000, 700);
        propertiesArray[0].put(KEY_LAYOUT_UPDATE_BOUNDS, rectangle2);
        propertiesArray[0].put(KEY_LAYOUT_UPDATE_CLUSTERING_ENABLED, "true");
        propertiesArray[0].put(KEY_LAYOUT_UPDATE_CLUSTERING_FACTOR, "8.0");
        propertiesArray[0].put(KEY_LAYOUT_UPDATE_CLUSTERING_MOVE_SCALE, "0.1");
        propertiesArray[1] = new Properties();
        propertiesArray[1].put(KEY_CONFIG_NAME, "Heavy Values");
        propertiesArray[1].put(KEY_INIT_TEMPERATURE, "500.0");
        propertiesArray[1].put(KEY_MIN_TEMPERATURE, "0.5");
        propertiesArray[1].put(KEY_MIN_DISTANCE, "50.0");
        propertiesArray[1].put(KEY_TEMP_SCALE_FACTOR, "0.97");
        propertiesArray[1].put(KEY_COMPUTE_PERMUTATION, "true");
        propertiesArray[1].put(KEY_IS_UPHILL_MOVE_ALLOWED, "true");
        propertiesArray[1].put(KEY_MAX_ROUNDS, "10000");
        propertiesArray[1].put(KEY_TRIES_PER_CELL, "8");
        propertiesArray[1].put(KEY_COST_FUNCTION_CONFIG, "111111");
        propertiesArray[1].put(KEY_BOUNDS, "0.0");
        ArrayList<Double> arrayList3 = new ArrayList<Double>();
        arrayList3.add(new Double(1000.0));
        arrayList3.add(new Double(100000.0));
        arrayList3.add(new Double(0.02));
        arrayList3.add(new Double(2000.0));
        arrayList3.add(new Double(150.0));
        arrayList3.add(new Double(1000000.0));
        propertiesArray[1].put(KEY_LAMBDA, arrayList3);
        Rectangle rectangle3 = new Rectangle(0, 0, 1000, 700);
        propertiesArray[1].put(KEY_BOUNDS, rectangle3);
        propertiesArray[1].put(KEY_LAYOUT_UPDATE_ENABLED, "true");
        propertiesArray[1].put(KEY_LAYOUT_UPDATE_INIT_TEMPERATURE, "40.0");
        propertiesArray[1].put(KEY_LAYOUT_UPDATE_MIN_TEMPERATURE, "2.0");
        propertiesArray[1].put(KEY_LAYOUT_UPDATE_MIN_DISTANCE, "50.0");
        propertiesArray[1].put(KEY_LAYOUT_UPDATE_TEMP_SCALE_FACTOR, "0.97");
        propertiesArray[1].put(KEY_LAYOUT_UPDATE_COMPUTE_PERMUTATION, "true");
        propertiesArray[1].put(KEY_LAYOUT_UPDATE_IS_UPHILL_MOVE_ALLOWED, "true");
        propertiesArray[1].put(KEY_LAYOUT_UPDATE_MAX_ROUNDS, "10000");
        propertiesArray[1].put(KEY_LAYOUT_UPDATE_TRIES_PER_CELL, "8");
        propertiesArray[1].put(KEY_LAYOUT_UPDATE_COST_FUNCTION_CONFIG, "111111");
        propertiesArray[1].put(KEY_LAYOUT_UPDATE_METHOD, KEY_LAYOUT_UPDATE_METHOD_PERIMETER);
        propertiesArray[1].put(KEY_LAYOUT_UPDATE_METHOD_NEIGHBORS_DEPTH, "2");
        propertiesArray[1].put(KEY_LAYOUT_UPDATE_METHOD_PERIMETER_RADIUS, "200.0");
        propertiesArray[1].put(KEY_LAYOUT_UPDATE_METHOD_PERIMETER_RADIUS_INCREASE, "40.0");
        ArrayList<Double> arrayList4 = new ArrayList<Double>();
        arrayList4.add(new Double(1000.0));
        arrayList4.add(new Double(100000.0));
        arrayList4.add(new Double(0.02));
        arrayList4.add(new Double(2000.0));
        arrayList4.add(new Double(150.0));
        arrayList4.add(new Double(1000000.0));
        propertiesArray[1].put(KEY_LAYOUT_UPDATE_LAMBDA, arrayList4);
        Rectangle rectangle4 = new Rectangle(0, 0, 1000, 700);
        propertiesArray[1].put(KEY_LAYOUT_UPDATE_BOUNDS, rectangle4);
        propertiesArray[1].put(KEY_LAYOUT_UPDATE_CLUSTERING_ENABLED, "true");
        propertiesArray[1].put(KEY_LAYOUT_UPDATE_CLUSTERING_FACTOR, "12.0");
        propertiesArray[1].put(KEY_LAYOUT_UPDATE_CLUSTERING_MOVE_SCALE, "0.2");
        this.isOptimizer = bl;
        this.preSetConfigs = propertiesArray;
        this.initComponents();
        this.action_LoadPreSets(0);
    }

    public void revert() {
    }

    public void apply() {
        this.layout.setPresetConfig(this.getConfiguration());
    }

    public void setConfiguration(Properties properties) {
        this.setInitTemperature(Double.parseDouble((String)properties.get(KEY_INIT_TEMPERATURE)));
        this.setMinTemperature(Double.parseDouble((String)properties.get(KEY_MIN_TEMPERATURE)));
        this.setMinDistance(Double.parseDouble((String)properties.get(KEY_MIN_DISTANCE)));
        this.setTemperatureScaleFactor(Double.parseDouble((String)properties.get(KEY_TEMP_SCALE_FACTOR)));
        this.setComputePermutation(this.isTrue((String)properties.get(KEY_COMPUTE_PERMUTATION)));
        this.setUphillMovesAllowed(this.isTrue((String)properties.get(KEY_IS_UPHILL_MOVE_ALLOWED)));
        this.setMaxRounds(Integer.parseInt((String)properties.get(KEY_MAX_ROUNDS)));
        this.setTriesPerCell(Integer.parseInt((String)properties.get(KEY_TRIES_PER_CELL)));
        this.setCostFunctionConfiguration(Integer.parseInt((String)properties.get(KEY_COST_FUNCTION_CONFIG), 2));
        this.setLambda((ArrayList)properties.get(KEY_LAMBDA));
        this.setResultBounds((Rectangle)properties.get(KEY_BOUNDS));
        this.setLayoutUpdateEnabled(this.isTrue((String)properties.get(KEY_LAYOUT_UPDATE_ENABLED)));
        this.setLayoutUpdateInitTemperature(Double.parseDouble((String)properties.get(KEY_LAYOUT_UPDATE_INIT_TEMPERATURE)));
        this.setLayoutUpdateMinTemperature(Double.parseDouble((String)properties.get(KEY_LAYOUT_UPDATE_MIN_TEMPERATURE)));
        this.setLayoutUpdateMinDistance(Double.parseDouble((String)properties.get(KEY_LAYOUT_UPDATE_MIN_DISTANCE)));
        this.setLayoutUpdateTemperatureScaleFactor(Double.parseDouble((String)properties.get(KEY_LAYOUT_UPDATE_TEMP_SCALE_FACTOR)));
        this.setLayoutUpdateComputePermutation(this.isTrue((String)properties.get(KEY_LAYOUT_UPDATE_COMPUTE_PERMUTATION)));
        this.setLayoutUpdateUphillMovesAllowed(this.isTrue((String)properties.get(KEY_LAYOUT_UPDATE_IS_UPHILL_MOVE_ALLOWED)));
        this.setLayoutUpdateMaxRounds(Integer.parseInt((String)properties.get(KEY_LAYOUT_UPDATE_MAX_ROUNDS)));
        this.setLayoutUpdateTriesPerCell(Integer.parseInt((String)properties.get(KEY_LAYOUT_UPDATE_TRIES_PER_CELL)));
        this.setLayoutUpdateCostFunctionConfiguration(Integer.parseInt((String)properties.get(KEY_LAYOUT_UPDATE_COST_FUNCTION_CONFIG), 2));
        this.setLayoutUpdateLambda((ArrayList)properties.get(KEY_LAYOUT_UPDATE_LAMBDA));
        this.setLayoutUpdateResultBounds((Rectangle)properties.get(KEY_LAYOUT_UPDATE_BOUNDS));
        this.setLayoutUpdateMethod((String)properties.get(KEY_LAYOUT_UPDATE_METHOD));
        this.setLayoutUpdateMethodNeighborsDepth(Integer.parseInt((String)properties.get(KEY_LAYOUT_UPDATE_METHOD_NEIGHBORS_DEPTH)));
        this.setLayoutUpdateMethodPerimeterRadius(Double.parseDouble((String)properties.get(KEY_LAYOUT_UPDATE_METHOD_PERIMETER_RADIUS)));
        this.setLayoutUpdateMethodPerimeterRadiusIncrease(Double.parseDouble((String)properties.get(KEY_LAYOUT_UPDATE_METHOD_PERIMETER_RADIUS_INCREASE)));
        this.setLayoutUpdateClusteringEnabled(this.isTrue((String)properties.get(KEY_LAYOUT_UPDATE_CLUSTERING_ENABLED)));
        this.setLayoutUpdateClusteringFactor(Double.parseDouble((String)properties.get(KEY_LAYOUT_UPDATE_CLUSTERING_FACTOR)));
        this.setLayoutUpdateClusteringMoveScaleFactor(Double.parseDouble((String)properties.get(KEY_LAYOUT_UPDATE_CLUSTERING_MOVE_SCALE)));
    }

    public Properties getConfiguration() {
        Properties properties = new Properties();
        properties.put("CAPTION", KEY_TITLE);
        properties.put(KEY_INIT_TEMPERATURE, String.valueOf(this.getInitTemperature()));
        properties.put(KEY_MIN_TEMPERATURE, String.valueOf(this.getMinTemperature()));
        properties.put(KEY_MIN_DISTANCE, String.valueOf(this.getMinDistance()));
        properties.put(KEY_TEMP_SCALE_FACTOR, String.valueOf(this.getTemperatureScaleFactor()));
        properties.put(KEY_COMPUTE_PERMUTATION, String.valueOf(this.getComputePermutation()));
        properties.put(KEY_IS_UPHILL_MOVE_ALLOWED, String.valueOf(this.getUphillMovesAllowed()));
        properties.put(KEY_MAX_ROUNDS, String.valueOf(this.getMaxRounds()));
        properties.put(KEY_TRIES_PER_CELL, String.valueOf(this.getTriesPerCell()));
        properties.put(KEY_COST_FUNCTION_CONFIG, String.valueOf(Integer.toBinaryString(this.getCostFunctionConfiguration())));
        properties.put(KEY_LAMBDA, this.getLambda());
        properties.put(KEY_BOUNDS, this.getResultBounds());
        properties.put(KEY_LAYOUT_UPDATE_ENABLED, String.valueOf(this.getLayoutUpdateEnabled()));
        properties.put(KEY_LAYOUT_UPDATE_INIT_TEMPERATURE, String.valueOf(this.getLayoutUpdateInitTemperature()));
        properties.put(KEY_LAYOUT_UPDATE_MIN_TEMPERATURE, String.valueOf(this.getLayoutUpdateMinTemperature()));
        properties.put(KEY_LAYOUT_UPDATE_MIN_DISTANCE, String.valueOf(this.getLayoutUpdateMinDistance()));
        properties.put(KEY_LAYOUT_UPDATE_TEMP_SCALE_FACTOR, String.valueOf(this.getLayoutUpdateTemperatureScaleFactor()));
        properties.put(KEY_LAYOUT_UPDATE_COMPUTE_PERMUTATION, String.valueOf(this.getLayoutUpdateComputePermutation()));
        properties.put(KEY_LAYOUT_UPDATE_IS_UPHILL_MOVE_ALLOWED, String.valueOf(this.getLayoutUpdateUphillMovesAllowed()));
        properties.put(KEY_LAYOUT_UPDATE_MAX_ROUNDS, String.valueOf(this.getLayoutUpdateMaxRounds()));
        properties.put(KEY_LAYOUT_UPDATE_TRIES_PER_CELL, String.valueOf(this.getLayoutUpdateTriesPerCell()));
        properties.put(KEY_LAYOUT_UPDATE_COST_FUNCTION_CONFIG, String.valueOf(Integer.toBinaryString(this.getLayoutUpdateCostFunctionConfiguration())));
        properties.put(KEY_LAYOUT_UPDATE_LAMBDA, this.getLayoutUpdateLambda());
        properties.put(KEY_LAYOUT_UPDATE_BOUNDS, this.getLayoutUpdateResultBounds());
        properties.put(KEY_LAYOUT_UPDATE_METHOD, this.getLayoutUpdateMethod());
        properties.put(KEY_LAYOUT_UPDATE_METHOD_NEIGHBORS_DEPTH, String.valueOf(this.getLayoutUpdateMethodNeighborsDepth()));
        properties.put(KEY_LAYOUT_UPDATE_METHOD_PERIMETER_RADIUS, String.valueOf(this.getLayoutUpdateMethodPerimeterRadius()));
        properties.put(KEY_LAYOUT_UPDATE_METHOD_PERIMETER_RADIUS_INCREASE, String.valueOf(this.getLayoutUpdateMethodPerimeterRadiusIncrease()));
        properties.put(KEY_LAYOUT_UPDATE_CLUSTERING_ENABLED, String.valueOf(this.getLayoutUpdateClusteringEnabled()));
        properties.put(KEY_LAYOUT_UPDATE_CLUSTERING_FACTOR, String.valueOf(this.getLayoutUpdateClusteringFactor()));
        properties.put(KEY_LAYOUT_UPDATE_CLUSTERING_MOVE_SCALE, String.valueOf(this.getLayoutUpdateClusteringMoveScaleFactor()));
        return properties;
    }

    protected void action_LoadPreSets(int n) {
        Properties properties = this.preSetConfigs[n];
        this.tf_initTemperature.setText((String)properties.get(KEY_INIT_TEMPERATURE));
        this.tf_minTemperature.setText((String)properties.get(KEY_MIN_TEMPERATURE));
        this.tf_minDistance.setText((String)properties.get(KEY_MIN_DISTANCE));
        this.tf_tempScaleFactor.setText((String)properties.get(KEY_TEMP_SCALE_FACTOR));
        this.tf_maxRounds.setText((String)properties.get(KEY_MAX_ROUNDS));
        this.tf_triesPerCell.setText((String)properties.get(KEY_TRIES_PER_CELL));
        ArrayList arrayList = (ArrayList)properties.get(KEY_LAMBDA);
        this.tf_lambdaNodeDistribution.setText(String.valueOf((Double)arrayList.get(0)));
        this.tf_lambdaBorderline.setText(String.valueOf((Double)arrayList.get(1)));
        this.tf_lambdaEdgeLength.setText(String.valueOf((Double)arrayList.get(2)));
        this.tf_lambdaEdgeCrossing.setText(String.valueOf((Double)arrayList.get(3)));
        this.tf_lambdaEdgeDistribution.setText(String.valueOf((Double)arrayList.get(4)));
        this.tf_lambdaNodeDistance.setText(String.valueOf((Double)arrayList.get(5)));
        Rectangle rectangle = (Rectangle)properties.get(KEY_BOUNDS);
        this.tf_boundsWidth.setText(String.valueOf((int)rectangle.getWidth()));
        this.tf_boundsHeight.setText(String.valueOf((int)rectangle.getHeight()));
        this.cb_computePermutation.setSelected(this.isTrue((String)properties.get(KEY_COMPUTE_PERMUTATION)));
        this.cb_uphillMovesAllowed.setSelected(this.isTrue((String)properties.get(KEY_IS_UPHILL_MOVE_ALLOWED)));
        int n2 = Integer.parseInt((String)properties.get(KEY_COST_FUNCTION_CONFIG), 2);
        this.setCostFunctionConfiguration(n2);
        this.cb_enableLayoutUpdate.setSelected(this.isTrue((String)properties.get(KEY_LAYOUT_UPDATE_ENABLED)));
        this.tf_lu_initTemperature.setText((String)properties.get(KEY_LAYOUT_UPDATE_INIT_TEMPERATURE));
        this.tf_lu_minTemperature.setText((String)properties.get(KEY_LAYOUT_UPDATE_MIN_TEMPERATURE));
        this.tf_lu_minDistance.setText((String)properties.get(KEY_LAYOUT_UPDATE_MIN_DISTANCE));
        this.tf_lu_tempScaleFactor.setText((String)properties.get(KEY_LAYOUT_UPDATE_TEMP_SCALE_FACTOR));
        this.tf_lu_maxRounds.setText((String)properties.get(KEY_LAYOUT_UPDATE_MAX_ROUNDS));
        this.tf_lu_triesPerCell.setText((String)properties.get(KEY_LAYOUT_UPDATE_TRIES_PER_CELL));
        ArrayList arrayList2 = (ArrayList)properties.get(KEY_LAYOUT_UPDATE_LAMBDA);
        this.tf_lu_lambdaNodeDistribution.setText(String.valueOf((Double)arrayList2.get(0)));
        this.tf_lu_lambdaBorderline.setText(String.valueOf((Double)arrayList2.get(1)));
        this.tf_lu_lambdaEdgeLength.setText(String.valueOf((Double)arrayList2.get(2)));
        this.tf_lu_lambdaEdgeCrossing.setText(String.valueOf((Double)arrayList2.get(3)));
        this.tf_lu_lambdaEdgeDistribution.setText(String.valueOf((Double)arrayList2.get(4)));
        this.tf_lu_lambdaNodeDistance.setText(String.valueOf((Double)arrayList2.get(5)));
        Rectangle rectangle2 = (Rectangle)properties.get(KEY_LAYOUT_UPDATE_BOUNDS);
        this.tf_lu_boundsWidth.setText(String.valueOf((int)rectangle2.getWidth()));
        this.tf_lu_boundsHeight.setText(String.valueOf((int)rectangle2.getHeight()));
        this.cb_lu_computePermutation.setSelected(this.isTrue((String)properties.get(KEY_LAYOUT_UPDATE_COMPUTE_PERMUTATION)));
        this.cb_lu_uphillMovesAllowed.setSelected(this.isTrue((String)properties.get(KEY_LAYOUT_UPDATE_IS_UPHILL_MOVE_ALLOWED)));
        int n3 = Integer.parseInt((String)properties.get(KEY_LAYOUT_UPDATE_COST_FUNCTION_CONFIG), 2);
        this.setLayoutUpdateCostFunctionConfiguration(n3);
        this.tf_lu_method_neighborsDepth.setText((String)properties.get(KEY_LAYOUT_UPDATE_METHOD_NEIGHBORS_DEPTH));
        this.tf_lu_method_perimeterRadius.setText((String)properties.get(KEY_LAYOUT_UPDATE_METHOD_PERIMETER_RADIUS));
        this.tf_lu_method_perimeterRadiusInc.setText((String)properties.get(KEY_LAYOUT_UPDATE_METHOD_PERIMETER_RADIUS_INCREASE));
        this.tf_lu_clustering_factor.setText((String)properties.get(KEY_LAYOUT_UPDATE_CLUSTERING_FACTOR));
        this.tf_lu_clustering_moveScale.setText((String)properties.get(KEY_LAYOUT_UPDATE_CLUSTERING_MOVE_SCALE));
        this.cb_lu_clustering_enable.setSelected(this.isTrue((String)properties.get(KEY_LAYOUT_UPDATE_CLUSTERING_ENABLED)));
        this.comb_lu_Method.setSelectedItem(properties.get(KEY_LAYOUT_UPDATE_METHOD));
        this.switchLayoutUpdatePanel();
        this.action_CheckBoxSwitch();
    }

    protected boolean isTrue(String string) {
        if (string != null) {
            if ("TRUE".equals(string.toUpperCase())) {
                return true;
            }
            if ("FALSE".equals(string.toUpperCase())) {
                return false;
            }
        }
        return false;
    }

    protected void check() {
        boolean bl = true;
        ArrayList arrayList = new ArrayList();
        bl &= this.assertDouble(this.tf_initTemperature.getText(), KEY_INIT_TEMPERATURE, arrayList);
        bl &= this.assertDouble(this.tf_minTemperature.getText(), KEY_MIN_TEMPERATURE, arrayList);
        bl &= this.assertDouble(this.tf_minDistance.getText(), KEY_MIN_DISTANCE, arrayList);
        bl &= this.assertDouble(this.tf_tempScaleFactor.getText(), KEY_TEMP_SCALE_FACTOR, arrayList);
        bl &= this.assertInteger(this.tf_maxRounds.getText(), KEY_MAX_ROUNDS, arrayList);
        bl &= this.assertInteger(this.tf_triesPerCell.getText(), KEY_TRIES_PER_CELL, arrayList);
        bl &= this.assertDouble(this.tf_lambdaNodeDistribution.getText(), "Node Distribution", arrayList);
        bl &= this.assertDouble(this.tf_lambdaBorderline.getText(), "Borderline", arrayList);
        bl &= this.assertDouble(this.tf_lambdaEdgeLength.getText(), "Edgelength", arrayList);
        bl &= this.assertDouble(this.tf_lambdaEdgeCrossing.getText(), "Edgecrossing", arrayList);
        bl &= this.assertDouble(this.tf_lambdaEdgeDistribution.getText(), "Node-Edge Distribution", arrayList);
        bl &= this.assertDouble(this.tf_lambdaNodeDistance.getText(), "Node Overlapping", arrayList);
        bl &= this.assertInteger(this.tf_boundsWidth.getText(), "max. width", arrayList);
        bl &= this.assertInteger(this.tf_boundsHeight.getText(), "max. height", arrayList);
        bl &= this.assertDouble(this.tf_lu_initTemperature.getText(), KEY_LAYOUT_UPDATE_INIT_TEMPERATURE, arrayList);
        bl &= this.assertDouble(this.tf_lu_minTemperature.getText(), KEY_LAYOUT_UPDATE_MIN_TEMPERATURE, arrayList);
        bl &= this.assertDouble(this.tf_lu_minDistance.getText(), KEY_LAYOUT_UPDATE_MIN_DISTANCE, arrayList);
        bl &= this.assertDouble(this.tf_lu_tempScaleFactor.getText(), KEY_LAYOUT_UPDATE_TEMP_SCALE_FACTOR, arrayList);
        bl &= this.assertInteger(this.tf_lu_maxRounds.getText(), KEY_LAYOUT_UPDATE_MAX_ROUNDS, arrayList);
        bl &= this.assertInteger(this.tf_lu_triesPerCell.getText(), KEY_LAYOUT_UPDATE_TRIES_PER_CELL, arrayList);
        bl &= this.assertDouble(this.tf_lu_lambdaNodeDistribution.getText(), "Layout Update Node Distribution", arrayList);
        bl &= this.assertDouble(this.tf_lu_lambdaBorderline.getText(), "Layout Update Borderline", arrayList);
        bl &= this.assertDouble(this.tf_lu_lambdaEdgeLength.getText(), "Layout Update Edgelength", arrayList);
        bl &= this.assertDouble(this.tf_lu_lambdaEdgeCrossing.getText(), "Layout Update Edgecrossing", arrayList);
        bl &= this.assertDouble(this.tf_lu_lambdaEdgeDistribution.getText(), "Layout Update Node-Edge Distribution", arrayList);
        bl &= this.assertDouble(this.tf_lu_lambdaNodeDistance.getText(), "Layout Update Node Overlapping", arrayList);
        bl &= this.assertInteger(this.tf_lu_boundsWidth.getText(), "Layout Update max. width", arrayList);
        bl &= this.assertInteger(this.tf_lu_boundsHeight.getText(), "Layout Update max. height", arrayList);
        bl &= this.assertDouble(this.tf_lu_clustering_factor.getText(), KEY_LAYOUT_UPDATE_CLUSTERING_FACTOR, arrayList);
        if (bl &= this.assertDouble(this.tf_lu_clustering_moveScale.getText(), KEY_LAYOUT_UPDATE_CLUSTERING_MOVE_SCALE, arrayList)) {
            bl &= this.assertDoublePositiveSign(this.tf_initTemperature.getText(), false, KEY_INIT_TEMPERATURE, arrayList);
            bl &= this.assertDoublePositiveSign(this.tf_initTemperature.getText(), false, KEY_INIT_TEMPERATURE, arrayList);
            bl &= this.assertDoublePositiveSign(this.tf_minTemperature.getText(), false, KEY_MIN_TEMPERATURE, arrayList);
            bl &= this.assertDoublePositiveSign(this.tf_minDistance.getText(), false, KEY_MIN_DISTANCE, arrayList);
            bl &= this.assertRange(this.tf_tempScaleFactor.getText(), 0.0, 1.0, false, false, KEY_TEMP_SCALE_FACTOR, arrayList);
            bl &= this.assertIntegerPositiveSign(this.tf_maxRounds.getText(), false, KEY_MAX_ROUNDS, arrayList);
            bl &= this.assertRange(this.tf_triesPerCell.getText(), 8, 99, true, true, KEY_TRIES_PER_CELL, arrayList);
            bl &= this.assertIntegerPositiveSign(this.tf_boundsWidth.getText(), false, "max. width", arrayList);
            bl &= this.assertIntegerPositiveSign(this.tf_boundsWidth.getText(), false, "max. height", arrayList);
            bl &= this.assertDoublePositiveSign(this.tf_lambdaNodeDistribution.getText(), false, "Node Distribution", arrayList);
            bl &= this.assertDoublePositiveSign(this.tf_lambdaBorderline.getText(), false, "Borderline", arrayList);
            bl &= this.assertDoublePositiveSign(this.tf_lambdaEdgeLength.getText(), false, "Edgelength", arrayList);
            bl &= this.assertDoublePositiveSign(this.tf_lambdaEdgeCrossing.getText(), false, "Edgecrossing", arrayList);
            bl &= this.assertDoublePositiveSign(this.tf_lambdaEdgeDistribution.getText(), false, "Node-Edge Distribution", arrayList);
            bl &= this.assertDoublePositiveSign(this.tf_lambdaNodeDistance.getText(), false, "Node Overlapping", arrayList);
            bl &= this.assertDoublePositiveSign(this.tf_lu_initTemperature.getText(), false, KEY_LAYOUT_UPDATE_INIT_TEMPERATURE, arrayList);
            bl &= this.assertDoublePositiveSign(this.tf_lu_initTemperature.getText(), false, KEY_LAYOUT_UPDATE_INIT_TEMPERATURE, arrayList);
            bl &= this.assertDoublePositiveSign(this.tf_lu_minTemperature.getText(), false, KEY_LAYOUT_UPDATE_MIN_TEMPERATURE, arrayList);
            bl &= this.assertDoublePositiveSign(this.tf_lu_minDistance.getText(), false, KEY_LAYOUT_UPDATE_MIN_DISTANCE, arrayList);
            bl &= this.assertRange(this.tf_lu_tempScaleFactor.getText(), 0.0, 1.0, false, false, KEY_LAYOUT_UPDATE_TEMP_SCALE_FACTOR, arrayList);
            bl &= this.assertIntegerPositiveSign(this.tf_lu_maxRounds.getText(), false, KEY_LAYOUT_UPDATE_MAX_ROUNDS, arrayList);
            bl &= this.assertRange(this.tf_lu_triesPerCell.getText(), 8, 99, true, true, KEY_LAYOUT_UPDATE_TRIES_PER_CELL, arrayList);
            bl &= this.assertIntegerPositiveSign(this.tf_lu_boundsWidth.getText(), false, "Layout Update max. width", arrayList);
            bl &= this.assertIntegerPositiveSign(this.tf_lu_boundsWidth.getText(), false, "Layout Update max. height", arrayList);
            bl &= this.assertDoublePositiveSign(this.tf_lu_lambdaNodeDistribution.getText(), false, "Layout Update Node Distribution", arrayList);
            bl &= this.assertDoublePositiveSign(this.tf_lu_lambdaBorderline.getText(), false, "Layout Update Borderline", arrayList);
            bl &= this.assertDoublePositiveSign(this.tf_lu_lambdaEdgeLength.getText(), false, "Layout Update Edgelength", arrayList);
            bl &= this.assertDoublePositiveSign(this.tf_lu_lambdaEdgeCrossing.getText(), false, "Layout Update Edgecrossing", arrayList);
            bl &= this.assertDoublePositiveSign(this.tf_lu_lambdaEdgeDistribution.getText(), false, "Layout Update Node-Edge Distribution", arrayList);
            bl &= this.assertDoublePositiveSign(this.tf_lu_lambdaNodeDistance.getText(), false, "Layout Update Node Overlapping", arrayList);
            bl &= this.assertDoublePositiveSign(this.tf_lu_clustering_factor.getText(), false, KEY_LAYOUT_UPDATE_CLUSTERING_FACTOR, arrayList);
            bl &= this.assertRange(this.tf_lu_clustering_moveScale.getText(), 0.0, 1.0, false, true, KEY_LAYOUT_UPDATE_CLUSTERING_MOVE_SCALE, arrayList);
        }
        if (!bl) {
            String string = new String();
            int n = 0;
            while (n < arrayList.size()) {
                string = string + (String)arrayList.get(n);
                if (n != arrayList.size() - 1) {
                    string = string + "\n";
                }
                ++n;
            }
            throw new IllegalArgumentException(string);
        }
    }

    private void initComponents() {
        this.panelSurface = new JPanel(new BorderLayout(5, 10));
        this.panelSurface.setBackground(new Color(205, 207, 215));
        this.setLayout(new BorderLayout(5, 10));
        this.tp_main = new JTabbedPane();
        this.add((Component)this.tp_main, "Center");
        JPanel jPanel = new JPanel(new GridLayout(8, 1, 0, 5));
        JPanel jPanel2 = new JPanel(new GridLayout(8, 1, 0, 5));
        JPanel jPanel3 = new JPanel(new BorderLayout(5, 10));
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        JPanel jPanel5 = new JPanel(new GridLayout(1, 3, 10, 0));
        JPanel jPanel6 = new JPanel(new GridBagLayout());
        JPanel jPanel7 = new JPanel(new BorderLayout(5, 10));
        jPanel.setOpaque(false);
        jPanel2.setOpaque(false);
        jPanel3.setOpaque(false);
        jPanel4.setOpaque(false);
        jPanel5.setOpaque(false);
        jPanel6.setOpaque(false);
        jPanel7.setOpaque(false);
        this.add((Component)jPanel5, "South");
        jPanel3.add((Component)jPanel, "West");
        jPanel3.add((Component)jPanel2, "Center");
        jPanel7.add((Component)jPanel4, "Center");
        jPanel7.add((Component)jPanel6, "South");
        this.panelSurface.add((Component)jPanel3, "North");
        this.panelSurface.add((Component)jPanel7, "West");
        this.panelSurface.add((Component)new JPanel(), "South");
        jPanel.add(new JLabel("start temperature :"));
        jPanel.add(new JLabel("min. temperature :"));
        jPanel.add(new JLabel("min. distance :"));
        jPanel.add(new JLabel("temperature scaling factor :"));
        jPanel.add(new JLabel("max. rounds :"));
        jPanel.add(new JLabel("tries per cell :"));
        jPanel.add(new JLabel("are uphill-moves allowed :"));
        jPanel.add(new JLabel("compute permutations :"));
        this.tf_initTemperature = new JTextField();
        this.tf_minTemperature = new JTextField();
        this.tf_minDistance = new JTextField();
        this.tf_tempScaleFactor = new JTextField();
        this.tf_maxRounds = new JTextField();
        this.tf_triesPerCell = new JTextField();
        this.tf_lambdaNodeDistribution = new JTextField();
        this.tf_lambdaBorderline = new JTextField();
        this.tf_lambdaEdgeLength = new JTextField();
        this.tf_lambdaEdgeCrossing = new JTextField();
        this.tf_lambdaEdgeDistribution = new JTextField();
        this.tf_lambdaNodeDistance = new JTextField();
        this.cb_computePermutation = new JCheckBox();
        this.cb_uphillMovesAllowed = new JCheckBox();
        this.cb_useNodeDistribution = new JCheckBox();
        this.cb_useBorderline = new JCheckBox();
        this.cb_useEdgeLength = new JCheckBox();
        this.cb_useEdgeCrossing = new JCheckBox();
        this.cb_useEdgeDistribution = new JCheckBox();
        this.cb_useNodeDistance = new JCheckBox();
        this.cb_computePermutation.setOpaque(false);
        this.cb_uphillMovesAllowed.setOpaque(false);
        this.cb_useNodeDistribution.setOpaque(false);
        this.cb_useBorderline.setOpaque(false);
        this.cb_useEdgeLength.setOpaque(false);
        this.cb_useEdgeCrossing.setOpaque(false);
        this.cb_useEdgeDistribution.setOpaque(false);
        this.cb_useNodeDistance.setOpaque(false);
        this.registerCheckBoxAction(this.cb_useNodeDistribution);
        this.registerCheckBoxAction(this.cb_useBorderline);
        this.registerCheckBoxAction(this.cb_useEdgeLength);
        this.registerCheckBoxAction(this.cb_useEdgeCrossing);
        this.registerCheckBoxAction(this.cb_useEdgeDistribution);
        this.registerCheckBoxAction(this.cb_useNodeDistance);
        jPanel2.add(this.tf_initTemperature);
        jPanel2.add(this.tf_minTemperature);
        jPanel2.add(this.tf_minDistance);
        jPanel2.add(this.tf_tempScaleFactor);
        jPanel2.add(this.tf_maxRounds);
        jPanel2.add(this.tf_triesPerCell);
        jPanel2.add(this.cb_computePermutation);
        jPanel2.add(this.cb_uphillMovesAllowed);
        jPanel4.add((Component)new JLabel("Costfunction Nodedistribution :"), new GridBagConstraints(0, 0, 1, 1, 0.5, 0.5, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel4.add((Component)new JLabel("Costfunction Borderline :"), new GridBagConstraints(0, 1, 1, 1, 0.5, 0.5, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel4.add((Component)new JLabel("Costfunction Edgelength :"), new GridBagConstraints(0, 2, 1, 1, 0.5, 0.5, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel4.add((Component)new JLabel("Costfunction Edgecrossing :"), new GridBagConstraints(0, 3, 1, 1, 0.5, 0.5, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel4.add((Component)new JLabel("Costfunction Edge Distribution :"), new GridBagConstraints(0, 4, 1, 1, 0.5, 0.5, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel4.add((Component)new JLabel("Costfunction Node Overlapping :"), new GridBagConstraints(0, 5, 1, 1, 0.5, 0.5, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel4.add((Component)this.cb_useNodeDistribution, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 20, 0, 0), 0, 0));
        jPanel4.add((Component)this.cb_useBorderline, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 20, 0, 0), 0, 0));
        jPanel4.add((Component)this.cb_useEdgeLength, new GridBagConstraints(1, 2, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 20, 0, 0), 0, 0));
        jPanel4.add((Component)this.cb_useEdgeCrossing, new GridBagConstraints(1, 3, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 20, 0, 0), 0, 0));
        jPanel4.add((Component)this.cb_useEdgeDistribution, new GridBagConstraints(1, 4, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 20, 0, 0), 0, 0));
        jPanel4.add((Component)this.cb_useNodeDistance, new GridBagConstraints(1, 5, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 20, 0, 0), 0, 0));
        jPanel4.add((Component)this.tf_lambdaNodeDistribution, new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 13, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel4.add((Component)this.tf_lambdaBorderline, new GridBagConstraints(2, 1, 1, 1, 1.0, 1.0, 13, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel4.add((Component)this.tf_lambdaEdgeLength, new GridBagConstraints(2, 2, 1, 1, 1.0, 1.0, 13, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel4.add((Component)this.tf_lambdaEdgeCrossing, new GridBagConstraints(2, 3, 1, 1, 1.0, 1.0, 13, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel4.add((Component)this.tf_lambdaEdgeDistribution, new GridBagConstraints(2, 4, 1, 1, 1.0, 1.0, 13, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel4.add((Component)this.tf_lambdaNodeDistance, new GridBagConstraints(2, 5, 1, 1, 1.0, 1.0, 13, 2, new Insets(0, 0, 0, 0), 0, 0));
        JLabel[] jLabelArray = this.getAdditionalCostFunctionLabels();
        JTextField[] jTextFieldArray = this.getAdditionalCostFunctionTextFields();
        JCheckBox[] jCheckBoxArray = this.getAdditionalCostFunctionCheckBoxes();
        int n = 0;
        while (n < jLabelArray.length) {
            jPanel4.add((Component)jLabelArray[n], new GridBagConstraints(0, 6 + n, 1, 1, 0.5, 0.5, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            ++n;
        }
        int n2 = 0;
        while (n2 < jCheckBoxArray.length) {
            jPanel4.add((Component)jCheckBoxArray[n2], new GridBagConstraints(1, 6 + n2, 1, 1, 0.5, 0.5, 10, 0, new Insets(0, 20, 0, 0), 0, 0));
            ++n2;
        }
        int n3 = 0;
        while (n3 < jTextFieldArray.length) {
            jPanel4.add((Component)jTextFieldArray[n3], new GridBagConstraints(2, 6 + n3, 1, 1, 0.5, 0.5, 13, 2, new Insets(0, 0, 0, 0), 0, 0));
            ++n3;
        }
        this.button_takeViewportSize = new JButton("take viewport size");
        this.button_takeViewportSize.setOpaque(false);
        JLabel jLabel = new JLabel("max. width :");
        JLabel jLabel2 = new JLabel("max. height :");
        this.tf_boundsWidth = new JTextField();
        this.tf_boundsHeight = new JTextField();
        jPanel6.add((Component)this.button_takeViewportSize, new GridBagConstraints(0, 0, 1, 2, 0.5, 1.0, 14, 2, new Insets(25, 20, 15, 30), 0, 0));
        jPanel6.add((Component)jLabel, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 15, 2, new Insets(15, 0, 5, 0), 0, 0));
        jPanel6.add((Component)jLabel2, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel6.add((Component)this.tf_boundsWidth, new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 15, 2, new Insets(15, 0, 5, 0), 0, 0));
        jPanel6.add((Component)this.tf_boundsHeight, new GridBagConstraints(2, 1, 1, 1, 1.0, 1.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.panelLUSurface = new JPanel(new BorderLayout(5, 10));
        this.panelLUSurface.setBackground(new Color(220, 205, 205));
        JPanel jPanel8 = new JPanel(new GridLayout(8, 1, 0, 5));
        JPanel jPanel9 = new JPanel(new GridLayout(8, 1, 0, 5));
        JPanel jPanel10 = new JPanel(new BorderLayout(5, 10));
        JPanel jPanel11 = new JPanel(new GridBagLayout());
        JPanel jPanel12 = new JPanel(new GridBagLayout());
        JPanel jPanel13 = new JPanel(new BorderLayout(5, 10));
        JPanel jPanel14 = new JPanel(new BorderLayout(5, 10));
        jPanel8.setOpaque(false);
        jPanel9.setOpaque(false);
        jPanel10.setOpaque(false);
        jPanel11.setOpaque(false);
        jPanel12.setOpaque(false);
        jPanel13.setOpaque(false);
        jPanel14.setOpaque(false);
        jPanel10.add((Component)jPanel8, "West");
        jPanel10.add((Component)jPanel9, "Center");
        jPanel13.add((Component)jPanel11, "West");
        jPanel13.add((Component)jPanel12, "South");
        this.panelLUSurface.add((Component)jPanel10, "North");
        this.panelLUSurface.add((Component)jPanel13, "Center");
        this.panelLUSurface.add((Component)jPanel14, "South");
        jPanel8.add(new JLabel("start temperature :"));
        jPanel8.add(new JLabel("min. temperature :"));
        jPanel8.add(new JLabel("min. distance :"));
        jPanel8.add(new JLabel("temperature scaling factor :"));
        jPanel8.add(new JLabel("max. rounds :"));
        jPanel8.add(new JLabel("tries per cell :"));
        jPanel8.add(new JLabel("are uphill-moves allowed :"));
        jPanel8.add(new JLabel("compute permutations :"));
        this.tf_lu_initTemperature = new JTextField();
        this.tf_lu_minTemperature = new JTextField();
        this.tf_lu_minDistance = new JTextField();
        this.tf_lu_tempScaleFactor = new JTextField();
        this.tf_lu_maxRounds = new JTextField();
        this.tf_lu_triesPerCell = new JTextField();
        this.tf_lu_lambdaNodeDistribution = new JTextField();
        this.tf_lu_lambdaBorderline = new JTextField();
        this.tf_lu_lambdaEdgeLength = new JTextField();
        this.tf_lu_lambdaEdgeCrossing = new JTextField();
        this.tf_lu_lambdaEdgeDistribution = new JTextField();
        this.tf_lu_lambdaNodeDistance = new JTextField();
        this.cb_lu_computePermutation = new JCheckBox();
        this.cb_lu_uphillMovesAllowed = new JCheckBox();
        this.cb_lu_useNodeDistribution = new JCheckBox();
        this.cb_lu_useBorderline = new JCheckBox();
        this.cb_lu_useEdgeLength = new JCheckBox();
        this.cb_lu_useEdgeCrossing = new JCheckBox();
        this.cb_lu_useEdgeDistribution = new JCheckBox();
        this.cb_lu_useNodeDistance = new JCheckBox();
        this.cb_lu_computePermutation.setOpaque(false);
        this.cb_lu_uphillMovesAllowed.setOpaque(false);
        this.cb_lu_useNodeDistribution.setOpaque(false);
        this.cb_lu_useBorderline.setOpaque(false);
        this.cb_lu_useEdgeLength.setOpaque(false);
        this.cb_lu_useEdgeCrossing.setOpaque(false);
        this.cb_lu_useEdgeDistribution.setOpaque(false);
        this.cb_lu_useNodeDistance.setOpaque(false);
        this.registerCheckBoxAction(this.cb_lu_useNodeDistribution);
        this.registerCheckBoxAction(this.cb_lu_useBorderline);
        this.registerCheckBoxAction(this.cb_lu_useEdgeLength);
        this.registerCheckBoxAction(this.cb_lu_useEdgeCrossing);
        this.registerCheckBoxAction(this.cb_lu_useEdgeDistribution);
        this.registerCheckBoxAction(this.cb_lu_useNodeDistance);
        jPanel9.add(this.tf_lu_initTemperature);
        jPanel9.add(this.tf_lu_minTemperature);
        jPanel9.add(this.tf_lu_minDistance);
        jPanel9.add(this.tf_lu_tempScaleFactor);
        jPanel9.add(this.tf_lu_maxRounds);
        jPanel9.add(this.tf_lu_triesPerCell);
        jPanel9.add(this.cb_lu_computePermutation);
        jPanel9.add(this.cb_lu_uphillMovesAllowed);
        jPanel11.add((Component)new JLabel("Costfunction Nodedistribution :"), new GridBagConstraints(0, 0, 1, 1, 0.5, 0.5, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel11.add((Component)new JLabel("Costfunction Borderline :"), new GridBagConstraints(0, 1, 1, 1, 0.5, 0.5, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel11.add((Component)new JLabel("Costfunction Edgelength :"), new GridBagConstraints(0, 2, 1, 1, 0.5, 0.5, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel11.add((Component)new JLabel("Costfunction Edgecrossing :"), new GridBagConstraints(0, 3, 1, 1, 0.5, 0.5, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel11.add((Component)new JLabel("Costfunction Edge Distribution :"), new GridBagConstraints(0, 4, 1, 1, 0.5, 0.5, 17, 0, new Insets(0, 0, 0, -20), 0, 0));
        jPanel11.add((Component)new JLabel("Costfunction Node Overlapping :"), new GridBagConstraints(0, 5, 1, 1, 0.5, 0.5, 17, 0, new Insets(0, 0, 0, -20), 0, 0));
        jPanel11.add((Component)this.cb_lu_useNodeDistribution, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 20, 0, 0), 0, 0));
        jPanel11.add((Component)this.cb_lu_useBorderline, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 20, 0, 0), 0, 0));
        jPanel11.add((Component)this.cb_lu_useEdgeLength, new GridBagConstraints(1, 2, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 20, 0, 0), 0, 0));
        jPanel11.add((Component)this.cb_lu_useEdgeCrossing, new GridBagConstraints(1, 3, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 20, 0, 0), 0, 0));
        jPanel11.add((Component)this.cb_lu_useEdgeDistribution, new GridBagConstraints(1, 4, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 20, 0, 0), 0, 0));
        jPanel11.add((Component)this.cb_lu_useNodeDistance, new GridBagConstraints(1, 5, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 20, 0, 0), 0, 0));
        jPanel11.add((Component)this.tf_lu_lambdaNodeDistribution, new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 13, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel11.add((Component)this.tf_lu_lambdaBorderline, new GridBagConstraints(2, 1, 1, 1, 1.0, 1.0, 13, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel11.add((Component)this.tf_lu_lambdaEdgeLength, new GridBagConstraints(2, 2, 1, 1, 1.0, 1.0, 13, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel11.add((Component)this.tf_lu_lambdaEdgeCrossing, new GridBagConstraints(2, 3, 1, 1, 1.0, 1.0, 13, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel11.add((Component)this.tf_lu_lambdaEdgeDistribution, new GridBagConstraints(2, 4, 1, 1, 1.0, 1.0, 13, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel11.add((Component)this.tf_lu_lambdaNodeDistance, new GridBagConstraints(2, 5, 1, 1, 1.0, 1.0, 13, 2, new Insets(0, 0, 0, 0), 0, 0));
        JLabel[] jLabelArray2 = this.getAdditionalLUCostFunctionLabels();
        JTextField[] jTextFieldArray2 = this.getAdditionalLUCostFunctionTextFields();
        JCheckBox[] jCheckBoxArray2 = this.getAdditionalLUCostFunctionCheckBoxes();
        int n4 = 0;
        while (n4 < jLabelArray2.length) {
            jPanel11.add((Component)jLabelArray2[n4], new GridBagConstraints(0, 6 + n4, 1, 1, 0.5, 0.5, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            ++n4;
        }
        int n5 = 0;
        while (n5 < jCheckBoxArray2.length) {
            jPanel11.add((Component)jCheckBoxArray2[n5], new GridBagConstraints(1, 6 + n5, 1, 1, 0.5, 0.5, 10, 0, new Insets(0, 20, 0, 0), 0, 0));
            ++n5;
        }
        int n6 = 0;
        while (n6 < jTextFieldArray2.length) {
            jPanel11.add((Component)jTextFieldArray2[n6], new GridBagConstraints(2, 6 + n6, 1, 1, 0.5, 0.5, 13, 2, new Insets(0, 0, 0, 0), 0, 0));
            ++n6;
        }
        this.button_lu_takeViewportSize = new JButton("take viewport size");
        this.button_lu_takeViewportSize.setOpaque(false);
        JLabel jLabel3 = new JLabel("max. width :");
        JLabel jLabel4 = new JLabel("max. height :");
        this.tf_lu_boundsWidth = new JTextField();
        this.tf_lu_boundsHeight = new JTextField();
        jPanel12.add((Component)this.button_lu_takeViewportSize, new GridBagConstraints(0, 0, 1, 2, 0.5, 1.0, 14, 2, new Insets(25, 20, 15, 30), 0, 0));
        jPanel12.add((Component)jLabel3, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 15, 2, new Insets(15, 0, 5, 0), 0, 0));
        jPanel12.add((Component)jLabel4, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel12.add((Component)this.tf_lu_boundsWidth, new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 15, 2, new Insets(15, 0, 5, 0), 0, 0));
        jPanel12.add((Component)this.tf_lu_boundsHeight, new GridBagConstraints(2, 1, 1, 1, 1.0, 1.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.tf_lu_method_neighborsDepth = new JTextField();
        this.tf_lu_method_perimeterRadius = new JTextField();
        this.tf_lu_method_perimeterRadiusInc = new JTextField();
        this.comb_lu_Method = new JComboBox();
        this.comb_lu_Method.addItem(KEY_LAYOUT_UPDATE_METHOD_NEIGHBORS_ONLY);
        this.comb_lu_Method.addItem(KEY_LAYOUT_UPDATE_METHOD_PERIMETER);
        this.comb_lu_Method.setBackground(this.panelLUSurface.getBackground());
        this.comb_lu_Method.setOpaque(false);
        this.comb_lu_Method.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AnnealingLayoutSettings.this.action_CheckBoxSwitch();
            }
        });
        JPanel jPanel15 = new JPanel(new GridLayout(4, 1, 10, 5));
        JPanel jPanel16 = new JPanel(new GridLayout(4, 1, 10, 5));
        jPanel15.setOpaque(false);
        jPanel16.setOpaque(false);
        jPanel14.setBorder(BorderFactory.createTitledBorder(BorderFactory.createRaisedBevelBorder(), KEY_LAYOUT_UPDATE_METHOD));
        jPanel14.add((Component)jPanel15, "West");
        jPanel14.add((Component)jPanel16, "East");
        jPanel15.add(new JLabel("Method for Layout Updates :"));
        jPanel15.add(new JLabel("Edge Distance to Neighbors :"));
        jPanel15.add(new JLabel("Optical Distance to Neighbors :"));
        jPanel15.add(new JLabel("Increase of optical Distance :"));
        jPanel16.add(this.comb_lu_Method);
        jPanel16.add(this.tf_lu_method_neighborsDepth);
        jPanel16.add(this.tf_lu_method_perimeterRadius);
        jPanel16.add(this.tf_lu_method_perimeterRadiusInc);
        JPanel jPanel17 = new JPanel(new GridLayout(3, 2, 10, 5));
        JPanel jPanel18 = new JPanel(new GridLayout(1, 2, 10, 5));
        JPanel jPanel19 = new JPanel();
        jPanel17.setOpaque(false);
        jPanel18.setOpaque(false);
        jPanel19.setOpaque(false);
        this.tf_lu_clustering_factor = new JTextField();
        this.cb_lu_clustering_enable = new JCheckBox();
        this.tf_lu_clustering_moveScale = new JTextField();
        this.cb_lu_clustering_enable.setOpaque(false);
        this.registerCheckBoxAction(this.cb_lu_clustering_enable);
        jPanel18.add(new JLabel("on/off"));
        jPanel18.add(this.cb_lu_clustering_enable);
        jPanel17.setBorder(BorderFactory.createTitledBorder(BorderFactory.createRaisedBevelBorder(), "Clustering"));
        jPanel17.add(jPanel18);
        jPanel17.add(jPanel19);
        jPanel17.add(new JLabel("Clustering factor :"));
        jPanel17.add(this.tf_lu_clustering_factor);
        jPanel17.add(new JLabel("Cluster move scale factor :"));
        jPanel17.add(this.tf_lu_clustering_moveScale);
        jPanel14.add((Component)jPanel17, "South");
        this.cb_enableLayoutUpdate = new JCheckBox();
        if (!this.isOptimizer) {
            JPanel jPanel20 = new JPanel(new GridBagLayout());
            this.add((Component)jPanel20, "North");
            this.cb_enableLayoutUpdate.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    AnnealingLayoutSettings.this.switchLayoutUpdatePanel();
                }
            });
            jPanel20.add((Component)new JLabel("Run permanent:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 30), 0, 0));
            jPanel20.add((Component)this.cb_enableLayoutUpdate, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        }
        this.comb_loadPreSets = new JComboBox();
        int n7 = 0;
        while (n7 < this.preSetConfigs.length) {
            this.comb_loadPreSets.addItem(this.preSetConfigs[n7].get(KEY_CONFIG_NAME));
            ++n7;
        }
        jPanel5.add(this.comb_loadPreSets);
        this.comb_loadPreSets.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AnnealingLayoutSettings.this.action_LoadPreSets(((JComboBox)actionEvent.getSource()).getSelectedIndex());
            }
        });
        this.panelSurfaceWrapper = new JScrollPane(this.panelSurface);
        Dimension dimension = new Dimension(550, 350);
        this.panelSurfaceWrapper.setPreferredSize(dimension);
        this.panelLUSurfaceWrapper = new JScrollPane(this.panelLUSurface);
        this.panelLUSurfaceWrapper.setPreferredSize(dimension);
        this.tp_main.addTab("Values for main run", this.panelSurfaceWrapper);
        this.setToolTipTexts();
    }

    private void registerCheckBoxAction(JCheckBox jCheckBox) {
        jCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AnnealingLayoutSettings.this.action_CheckBoxSwitch();
            }
        });
    }

    protected JLabel[] getAdditionalCostFunctionLabels() {
        return new JLabel[0];
    }

    protected JCheckBox[] getAdditionalCostFunctionCheckBoxes() {
        return new JCheckBox[0];
    }

    protected JTextField[] getAdditionalCostFunctionTextFields() {
        return new JTextField[0];
    }

    protected JLabel[] getAdditionalLUCostFunctionLabels() {
        return new JLabel[0];
    }

    protected JCheckBox[] getAdditionalLUCostFunctionCheckBoxes() {
        return new JCheckBox[0];
    }

    protected JTextField[] getAdditionalLUCostFunctionTextFields() {
        return new JTextField[0];
    }

    private void switchLayoutUpdatePanel() {
        if (this.cb_enableLayoutUpdate.isSelected() && !this.isOptimizer) {
            this.tp_main.addTab("Values for Layout updates", this.panelLUSurfaceWrapper);
        } else {
            this.tp_main.remove(this.panelLUSurfaceWrapper);
        }
    }

    protected void setToolTipTexts() {
        this.tf_initTemperature.setToolTipText("starting value for temperature");
        this.tf_minTemperature.setToolTipText("if temperature reaches this value, the algorithm finishes");
        this.tf_minDistance.setToolTipText("minimal distance, vertices should have to each other before causing more costs");
        this.tf_tempScaleFactor.setToolTipText("factor the temperature is multiplied every round");
        this.tf_maxRounds.setToolTipText("maximum number of rounds, if not finished by temperature before");
        this.tf_triesPerCell.setToolTipText("number of segments around a vertex. The vertex will be placed on each to find a new position. Costs are calculated for every segment, so don't choose your value too high");
        this.tf_lambdaNodeDistribution.setToolTipText("Factor, the costs of the node distribution function are multiplied. Low distances between Vertices make heigher costs");
        this.tf_lambdaBorderline.setToolTipText("Factor, the costs of the borderline function are multiplied. Border can be configured with \"max. width\" and \"max. height\" below. Vertices near or beyond cause higher costs");
        this.tf_lambdaEdgeLength.setToolTipText("Factor, the costs of the edge length function are multiplied. Long edges cause higher costs");
        this.tf_lambdaEdgeCrossing.setToolTipText("Factor, the costs of the edge crossing function are multiplied. For every crossing Edge the costs increase");
        this.tf_lambdaEdgeDistribution.setToolTipText("Factor, the costs of the edge distribution function are multiplied. This function evaluates the distances between edges and vertices. A low distance increases the costs");
        this.tf_lambdaNodeDistance.setToolTipText("Factor, the costs of the node distance function are multiplied. Nodes to close to each other or overlapping increases the costs");
        this.tf_boundsWidth.setToolTipText("width of the field the graph should be layouted on");
        this.tf_boundsHeight.setToolTipText("height of the field the graph should be layouted on");
        this.cb_computePermutation.setToolTipText("define if the vertices are computed every round with the same order or a random order (permutation)");
        this.cb_uphillMovesAllowed.setToolTipText("defines if moves of vertices are allowed, which increases the costs slightly");
        this.cb_useNodeDistribution.setToolTipText("switches the costfunction for node distribution on/off");
        this.cb_useBorderline.setToolTipText("switches the costfunction for borderline on/off");
        this.cb_useEdgeLength.setToolTipText("switches the costfunction for edge length on/off");
        this.cb_useEdgeCrossing.setToolTipText("switches the costfunction for edge crossings on/off");
        this.cb_useEdgeDistribution.setToolTipText("switches the costfunction for edge distribution on/off");
        this.cb_useNodeDistance.setToolTipText("switches the costfunction for node distance on/off");
        this.button_takeViewportSize.setToolTipText("takes the size of the viewport for the graph (FEATURE NOT IMPLEMENTED YET!!!)");
        this.cb_enableLayoutUpdate.setToolTipText("enables the algorithm to run, when vertices are removed/added");
        this.tf_lu_initTemperature.setToolTipText(this.tf_initTemperature.getToolTipText());
        this.tf_lu_minTemperature.setToolTipText(this.tf_minTemperature.getToolTipText());
        this.tf_lu_minDistance.setToolTipText(this.tf_minDistance.getToolTipText());
        this.tf_lu_tempScaleFactor.setToolTipText(this.tf_tempScaleFactor.getToolTipText());
        this.tf_lu_maxRounds.setToolTipText(this.tf_maxRounds.getToolTipText());
        this.tf_lu_triesPerCell.setToolTipText(this.tf_triesPerCell.getToolTipText());
        this.tf_lu_lambdaNodeDistribution.setToolTipText(this.tf_lambdaNodeDistribution.getToolTipText());
        this.tf_lu_lambdaBorderline.setToolTipText(this.tf_lambdaBorderline.getToolTipText());
        this.tf_lu_lambdaEdgeLength.setToolTipText(this.tf_lambdaEdgeLength.getToolTipText());
        this.tf_lu_lambdaEdgeCrossing.setToolTipText(this.tf_lambdaEdgeCrossing.getToolTipText());
        this.tf_lu_lambdaEdgeDistribution.setToolTipText(this.tf_lambdaEdgeDistribution.getToolTipText());
        this.tf_lu_lambdaNodeDistance.setToolTipText(this.tf_lambdaNodeDistance.getToolTipText());
        this.tf_lu_boundsWidth.setToolTipText(this.tf_boundsWidth.getToolTipText());
        this.tf_lu_boundsHeight.setToolTipText(this.tf_boundsHeight.getToolTipText());
        this.tf_lu_method_neighborsDepth.setToolTipText("");
        this.tf_lu_method_perimeterRadius.setToolTipText("");
        this.tf_lu_method_perimeterRadiusInc.setToolTipText("");
        this.cb_lu_computePermutation.setToolTipText(this.cb_computePermutation.getToolTipText());
        this.cb_lu_uphillMovesAllowed.setToolTipText(this.cb_uphillMovesAllowed.getToolTipText());
        this.cb_lu_useNodeDistribution.setToolTipText(this.cb_useNodeDistribution.getToolTipText());
        this.cb_lu_useBorderline.setToolTipText(this.cb_useBorderline.getToolTipText());
        this.cb_lu_useEdgeLength.setToolTipText(this.cb_useEdgeLength.getToolTipText());
        this.cb_lu_useEdgeCrossing.setToolTipText(this.cb_useEdgeCrossing.getToolTipText());
        this.cb_lu_useEdgeDistribution.setToolTipText(this.cb_useEdgeDistribution.getToolTipText());
        this.cb_lu_useNodeDistance.setToolTipText(this.cb_useNodeDistance.getToolTipText());
        this.button_lu_takeViewportSize.setToolTipText(this.button_takeViewportSize.getToolTipText());
        this.comb_lu_Method.setToolTipText("choose a method for Layout Updating. This method determines, which of the Neighbors around the inserted Vertices are also new layouted in order to make place for the Layout of the inserted Vertices.");
        this.tf_lu_method_neighborsDepth.setToolTipText("Neighbors are once again layouted if their distance to the inserted vertices is lower or equal this value");
        this.tf_lu_method_perimeterRadius.setToolTipText("Neighbors within this radius around the initial position of inserted vertices are once again layouted in order to make place for the Layout of the inserted Vertices");
        this.tf_lu_method_perimeterRadiusInc.setToolTipText("If more than one Vertice is inserted and has the same initial Position as another the perimeter radius is increase by this value");
        this.tf_lu_clustering_factor.setToolTipText("Factor the creation of clusters. A lower value leads to more clusters, with smaller size, a higher value to fewer, bigger clusters");
        this.tf_lu_clustering_moveScale.setToolTipText("Scales the movement of clusters. Possible values are between 0.0 and 1.0. A small value ensures, that clusters move slow and over short distances.");
    }

    protected void action_CheckBoxSwitch() {
        this.tf_lambdaNodeDistribution.setEnabled(this.cb_useNodeDistribution.isSelected());
        this.tf_lambdaBorderline.setEnabled(this.cb_useBorderline.isSelected());
        this.button_takeViewportSize.setEnabled(this.cb_useBorderline.isSelected());
        this.tf_boundsWidth.setEnabled(this.cb_useBorderline.isSelected());
        this.tf_boundsHeight.setEnabled(this.cb_useBorderline.isSelected());
        this.tf_lambdaEdgeLength.setEnabled(this.cb_useEdgeLength.isSelected());
        this.tf_lambdaEdgeCrossing.setEnabled(this.cb_useEdgeCrossing.isSelected());
        this.tf_lambdaEdgeDistribution.setEnabled(this.cb_useEdgeDistribution.isSelected());
        this.tf_lambdaNodeDistance.setEnabled(this.cb_useNodeDistance.isSelected());
        this.tf_lu_lambdaNodeDistribution.setEnabled(this.cb_lu_useNodeDistribution.isSelected());
        this.tf_lu_lambdaBorderline.setEnabled(this.cb_lu_useBorderline.isSelected());
        this.button_lu_takeViewportSize.setEnabled(this.cb_lu_useBorderline.isSelected());
        this.tf_lu_boundsWidth.setEnabled(this.cb_lu_useBorderline.isSelected());
        this.tf_lu_boundsHeight.setEnabled(this.cb_lu_useBorderline.isSelected());
        this.tf_lu_lambdaEdgeLength.setEnabled(this.cb_lu_useEdgeLength.isSelected());
        this.tf_lu_lambdaEdgeCrossing.setEnabled(this.cb_lu_useEdgeCrossing.isSelected());
        this.tf_lu_lambdaEdgeDistribution.setEnabled(this.cb_lu_useEdgeDistribution.isSelected());
        this.tf_lu_lambdaNodeDistance.setEnabled(this.cb_lu_useNodeDistance.isSelected());
        this.tf_lu_clustering_factor.setEnabled(this.cb_lu_clustering_enable.isSelected());
        this.tf_lu_clustering_moveScale.setEnabled(this.cb_lu_clustering_enable.isSelected());
        String string = (String)this.comb_lu_Method.getSelectedItem();
        if (KEY_LAYOUT_UPDATE_METHOD_NEIGHBORS_ONLY.equals(string)) {
            this.tf_lu_method_neighborsDepth.setEnabled(true);
            this.tf_lu_method_perimeterRadius.setEnabled(false);
            this.tf_lu_method_perimeterRadiusInc.setEnabled(false);
        } else if (KEY_LAYOUT_UPDATE_METHOD_PERIMETER.equals(string)) {
            this.tf_lu_method_neighborsDepth.setEnabled(true);
            this.tf_lu_method_perimeterRadius.setEnabled(true);
            this.tf_lu_method_perimeterRadiusInc.setEnabled(true);
        }
    }

    protected boolean assertDouble(String string, String string2, ArrayList arrayList) {
        String string3 = string2 + " is NOT a double value!";
        try {
            Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            arrayList.add(string3);
            return false;
        }
        return true;
    }

    protected boolean assertInteger(String string, String string2, ArrayList arrayList) {
        String string3 = string2 + " is NOT a integer value!";
        try {
            Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            arrayList.add(string3);
            return false;
        }
        return true;
    }

    protected boolean assertRange(String string, double d, double d2, boolean bl, boolean bl2, String string2, ArrayList arrayList) {
        double d3 = Double.parseDouble(string);
        boolean bl3 = true;
        bl3 = bl ? (bl3 &= d3 >= d) : (bl3 &= d3 > d);
        if (bl3) {
            bl3 = bl2 ? (bl3 &= d3 <= d2) : (bl3 &= d3 < d2);
        }
        if (bl3) {
            return true;
        }
        String string3 = string2 + " is out the interval ";
        string3 = string3 + (bl ? "[" : "]");
        string3 = string3 + d + ";" + d2;
        string3 = string3 + (bl2 ? "]" : "[");
        arrayList.add(string3);
        return false;
    }

    protected boolean assertRange(String string, int n, int n2, boolean bl, boolean bl2, String string2, ArrayList arrayList) {
        double d = Integer.parseInt(string);
        boolean bl3 = true;
        bl3 = bl ? (bl3 &= d >= (double)n) : (bl3 &= d > (double)n);
        if (bl3) {
            bl3 = bl2 ? (bl3 &= d <= (double)n2) : (bl3 &= d < (double)n2);
        }
        if (bl3) {
            return true;
        }
        String string3 = string2 + " is out the interval ";
        string3 = string3 + (bl ? "[" : "]");
        string3 = string3 + n + ";" + n2;
        string3 = string3 + (bl2 ? "]" : "[");
        arrayList.add(string3);
        return false;
    }

    protected boolean assertDoublePositiveSign(String string, boolean bl, String string2, ArrayList arrayList) {
        double d = Double.parseDouble(string);
        boolean bl2 = true;
        if (bl) {
            bl2 = d >= 0.0;
        } else {
            boolean bl3 = bl2 = d > 0.0;
        }
        if (!bl2) {
            String string3 = string2;
            string3 = bl ? string3 + " has to be equal or bigger than 0.0" : string3 + " has to be bigger than 0.0";
            arrayList.add(string3);
            return false;
        }
        return bl2;
    }

    protected boolean assertIntegerPositiveSign(String string, boolean bl, String string2, ArrayList arrayList) {
        int n = Integer.parseInt(string);
        boolean bl2 = true;
        if (bl) {
            bl2 = n >= 0;
        } else {
            boolean bl3 = bl2 = n > 0;
        }
        if (!bl2) {
            String string3 = string2;
            string3 = bl ? string3 + " has to be equal or bigger than 0" : string3 + " has to be bigger than 0";
            arrayList.add(arrayList);
            return false;
        }
        return bl2;
    }

    public double getInitTemperature() {
        return Double.parseDouble(this.tf_initTemperature.getText());
    }

    public void setInitTemperature(double d) {
        this.tf_initTemperature.setText(String.valueOf(d));
    }

    public double getMinTemperature() {
        return Double.parseDouble(this.tf_minTemperature.getText());
    }

    public void setMinTemperature(double d) {
        this.tf_minTemperature.setText(String.valueOf(d));
    }

    public double getMinDistance() {
        return Double.parseDouble(this.tf_minDistance.getText());
    }

    public void setMinDistance(double d) {
        this.tf_minDistance.setText(String.valueOf(d));
    }

    public double getTemperatureScaleFactor() {
        return Double.parseDouble(this.tf_tempScaleFactor.getText());
    }

    public void setTemperatureScaleFactor(double d) {
        this.tf_tempScaleFactor.setText(String.valueOf(d));
    }

    public int getMaxRounds() {
        return Integer.parseInt(this.tf_maxRounds.getText());
    }

    public void setMaxRounds(int n) {
        this.tf_maxRounds.setText(String.valueOf(n));
    }

    public int getTriesPerCell() {
        return Integer.parseInt(this.tf_triesPerCell.getText());
    }

    public void setTriesPerCell(int n) {
        this.tf_triesPerCell.setText(String.valueOf(n));
    }

    public int getCostFunctionConfiguration() {
        int n = 0;
        if (this.cb_useNodeDistance.isSelected()) {
            n |= 0x20;
        }
        if (this.cb_useNodeDistribution.isSelected()) {
            n |= 0x10;
        }
        if (this.cb_useBorderline.isSelected()) {
            n |= 8;
        }
        if (this.cb_useEdgeLength.isSelected()) {
            n |= 4;
        }
        if (this.cb_useEdgeCrossing.isSelected()) {
            n |= 2;
        }
        if (this.cb_useEdgeDistribution.isSelected()) {
            n |= 1;
        }
        return n |= this.getAdditionalCostFunctionConfiguration();
    }

    protected int getAdditionalCostFunctionConfiguration() {
        return 0;
    }

    public void setCostFunctionConfiguration(int n) {
        this.cb_useNodeDistance.setSelected((n & 0x20) != 0);
        this.cb_useNodeDistribution.setSelected((n & 0x10) != 0);
        this.cb_useBorderline.setSelected((n & 8) != 0);
        this.cb_useEdgeLength.setSelected((n & 4) != 0);
        this.cb_useEdgeCrossing.setSelected((n & 2) != 0);
        this.cb_useEdgeDistribution.setSelected((n & 1) != 0);
        this.setAdditionalCostFunctionConfiguration(n);
    }

    protected void setAdditionalCostFunctionConfiguration(int n) {
    }

    public ArrayList getLambda() {
        ArrayList arrayList = new ArrayList();
        arrayList.add(new Double(this.tf_lambdaNodeDistribution.getText()));
        arrayList.add(new Double(this.tf_lambdaBorderline.getText()));
        arrayList.add(new Double(this.tf_lambdaEdgeLength.getText()));
        arrayList.add(new Double(this.tf_lambdaEdgeCrossing.getText()));
        arrayList.add(new Double(this.tf_lambdaEdgeDistribution.getText()));
        arrayList.add(new Double(this.tf_lambdaNodeDistance.getText()));
        arrayList = this.getAdditionalLambda(arrayList);
        return arrayList;
    }

    protected ArrayList getAdditionalLambda(ArrayList arrayList) {
        return arrayList;
    }

    public void setLambda(ArrayList arrayList) {
        this.tf_lambdaNodeDistribution.setText(String.valueOf((Double)arrayList.get(0)));
        this.tf_lambdaBorderline.setText(String.valueOf((Double)arrayList.get(1)));
        this.tf_lambdaEdgeLength.setText(String.valueOf((Double)arrayList.get(2)));
        this.tf_lambdaEdgeCrossing.setText(String.valueOf((Double)arrayList.get(3)));
        this.tf_lambdaEdgeDistribution.setText(String.valueOf((Double)arrayList.get(4)));
        this.tf_lambdaNodeDistance.setText(String.valueOf((Double)arrayList.get(5)));
        this.setAdditionalLambda(arrayList);
    }

    protected void setAdditionalLambda(ArrayList arrayList) {
    }

    public boolean getUphillMovesAllowed() {
        return this.cb_uphillMovesAllowed.isSelected();
    }

    public void setUphillMovesAllowed(boolean bl) {
        this.cb_uphillMovesAllowed.setSelected(bl);
    }

    public boolean getComputePermutation() {
        return this.cb_computePermutation.isSelected();
    }

    public void setComputePermutation(boolean bl) {
        this.cb_computePermutation.setSelected(bl);
    }

    public Rectangle getResultBounds() {
        int n = 0;
        int n2 = 0;
        int n3 = Integer.parseInt(this.tf_boundsWidth.getText());
        int n4 = Integer.parseInt(this.tf_boundsHeight.getText());
        return new Rectangle(n, n2, n3, n4);
    }

    public void setResultBounds(Rectangle rectangle) {
        this.tf_boundsWidth.setText(String.valueOf((int)rectangle.getWidth()));
        this.tf_boundsHeight.setText(String.valueOf((int)rectangle.getHeight()));
    }

    public double getLayoutUpdateInitTemperature() {
        return Double.parseDouble(this.tf_lu_initTemperature.getText());
    }

    public void setLayoutUpdateInitTemperature(double d) {
        this.tf_lu_initTemperature.setText(String.valueOf(d));
    }

    public double getLayoutUpdateMinTemperature() {
        return Double.parseDouble(this.tf_lu_minTemperature.getText());
    }

    public void setLayoutUpdateMinTemperature(double d) {
        this.tf_lu_minTemperature.setText(String.valueOf(d));
    }

    public double getLayoutUpdateMinDistance() {
        return Double.parseDouble(this.tf_lu_minDistance.getText());
    }

    public void setLayoutUpdateMinDistance(double d) {
        this.tf_lu_minDistance.setText(String.valueOf(d));
    }

    public double getLayoutUpdateTemperatureScaleFactor() {
        return Double.parseDouble(this.tf_lu_tempScaleFactor.getText());
    }

    public void setLayoutUpdateTemperatureScaleFactor(double d) {
        this.tf_lu_tempScaleFactor.setText(String.valueOf(d));
    }

    public int getLayoutUpdateMaxRounds() {
        return Integer.parseInt(this.tf_lu_maxRounds.getText());
    }

    public void setLayoutUpdateMaxRounds(int n) {
        this.tf_lu_maxRounds.setText(String.valueOf(n));
    }

    public void setLayoutUpdateTriesPerCell(int n) {
        this.tf_lu_triesPerCell.setText(String.valueOf(n));
    }

    public int getLayoutUpdateTriesPerCell() {
        return Integer.parseInt(this.tf_lu_triesPerCell.getText());
    }

    public int getLayoutUpdateCostFunctionConfiguration() {
        int n = 0;
        if (this.cb_lu_useNodeDistance.isSelected()) {
            n |= 0x20;
        }
        if (this.cb_lu_useNodeDistribution.isSelected()) {
            n |= 0x10;
        }
        if (this.cb_lu_useBorderline.isSelected()) {
            n |= 8;
        }
        if (this.cb_lu_useEdgeLength.isSelected()) {
            n |= 4;
        }
        if (this.cb_lu_useEdgeCrossing.isSelected()) {
            n |= 2;
        }
        if (this.cb_lu_useEdgeDistribution.isSelected()) {
            n |= 1;
        }
        return n |= this.getLayoutUpdateAdditionalCostFunctionConfiguration();
    }

    protected int getLayoutUpdateAdditionalCostFunctionConfiguration() {
        return 0;
    }

    public void setLayoutUpdateCostFunctionConfiguration(int n) {
        this.cb_lu_useNodeDistance.setSelected((n & 0x20) != 0);
        this.cb_lu_useNodeDistribution.setSelected((n & 0x10) != 0);
        this.cb_lu_useBorderline.setSelected((n & 8) != 0);
        this.cb_lu_useEdgeLength.setSelected((n & 4) != 0);
        this.cb_lu_useEdgeCrossing.setSelected((n & 2) != 0);
        this.cb_lu_useEdgeDistribution.setSelected((n & 1) != 0);
        this.setLayoutUpdateAdditionalCostFunctionConfiguration(n);
    }

    protected void setLayoutUpdateAdditionalCostFunctionConfiguration(int n) {
    }

    public ArrayList getLayoutUpdateLambda() {
        ArrayList arrayList = new ArrayList();
        arrayList.add(new Double(this.tf_lu_lambdaNodeDistribution.getText()));
        arrayList.add(new Double(this.tf_lu_lambdaBorderline.getText()));
        arrayList.add(new Double(this.tf_lu_lambdaEdgeLength.getText()));
        arrayList.add(new Double(this.tf_lu_lambdaEdgeCrossing.getText()));
        arrayList.add(new Double(this.tf_lu_lambdaEdgeDistribution.getText()));
        arrayList.add(new Double(this.tf_lu_lambdaNodeDistance.getText()));
        arrayList = this.getLayoutUpdateAdditionalLambda(arrayList);
        return arrayList;
    }

    protected ArrayList getLayoutUpdateAdditionalLambda(ArrayList arrayList) {
        return arrayList;
    }

    public void setLayoutUpdateLambda(ArrayList arrayList) {
        this.tf_lu_lambdaNodeDistribution.setText(String.valueOf((Double)arrayList.get(0)));
        this.tf_lu_lambdaBorderline.setText(String.valueOf((Double)arrayList.get(1)));
        this.tf_lu_lambdaEdgeLength.setText(String.valueOf((Double)arrayList.get(2)));
        this.tf_lu_lambdaEdgeCrossing.setText(String.valueOf((Double)arrayList.get(3)));
        this.tf_lu_lambdaEdgeDistribution.setText(String.valueOf((Double)arrayList.get(4)));
        this.tf_lu_lambdaNodeDistance.setText(String.valueOf((Double)arrayList.get(5)));
        this.setLayoutUpdateAdditionalLambda(arrayList);
    }

    protected void setLayoutUpdateAdditionalLambda(ArrayList arrayList) {
    }

    public boolean getLayoutUpdateUphillMovesAllowed() {
        return this.cb_lu_uphillMovesAllowed.isSelected();
    }

    public void setLayoutUpdateUphillMovesAllowed(boolean bl) {
        this.cb_lu_uphillMovesAllowed.setSelected(bl);
    }

    public boolean getLayoutUpdateComputePermutation() {
        return this.cb_lu_computePermutation.isSelected();
    }

    public void setLayoutUpdateComputePermutation(boolean bl) {
        this.cb_lu_computePermutation.setSelected(bl);
    }

    public Rectangle getLayoutUpdateResultBounds() {
        int n = 0;
        int n2 = 0;
        int n3 = Integer.parseInt(this.tf_lu_boundsWidth.getText());
        int n4 = Integer.parseInt(this.tf_lu_boundsHeight.getText());
        return new Rectangle(n, n2, n3, n4);
    }

    public void setLayoutUpdateResultBounds(Rectangle rectangle) {
        this.tf_lu_boundsWidth.setText(String.valueOf((int)rectangle.getWidth()));
        this.tf_lu_boundsHeight.setText(String.valueOf((int)rectangle.getHeight()));
    }

    public void setLayoutUpdateEnabled(boolean bl) {
        this.cb_enableLayoutUpdate.setSelected(bl);
        this.switchLayoutUpdatePanel();
    }

    public boolean getLayoutUpdateEnabled() {
        return this.cb_enableLayoutUpdate.isSelected();
    }

    public void setLayoutUpdateMethod(String string) {
        this.comb_lu_Method.setSelectedItem(string);
    }

    public String getLayoutUpdateMethod() {
        return (String)this.comb_lu_Method.getSelectedItem();
    }

    public void setLayoutUpdateMethodNeighborsDepth(int n) {
        this.tf_lu_method_neighborsDepth.setText(String.valueOf(n));
    }

    public int getLayoutUpdateMethodNeighborsDepth() {
        return Integer.parseInt(this.tf_lu_method_neighborsDepth.getText());
    }

    public void setLayoutUpdateMethodPerimeterRadius(double d) {
        this.tf_lu_method_perimeterRadius.setText(String.valueOf(d));
    }

    public double getLayoutUpdateMethodPerimeterRadius() {
        return Double.parseDouble(this.tf_lu_method_perimeterRadius.getText());
    }

    public void setLayoutUpdateMethodPerimeterRadiusIncrease(double d) {
        this.tf_lu_method_perimeterRadiusInc.setText(String.valueOf(d));
    }

    public double getLayoutUpdateMethodPerimeterRadiusIncrease() {
        return Double.parseDouble(this.tf_lu_method_perimeterRadiusInc.getText());
    }

    public void setLayoutUpdateClusteringEnabled(boolean bl) {
        this.cb_lu_clustering_enable.setSelected(bl);
    }

    public boolean getLayoutUpdateClusteringEnabled() {
        return this.cb_lu_clustering_enable.isSelected();
    }

    public void setLayoutUpdateClusteringFactor(double d) {
        this.tf_lu_clustering_factor.setText(String.valueOf(d));
    }

    public double getLayoutUpdateClusteringFactor() {
        return Double.parseDouble(this.tf_lu_clustering_factor.getText());
    }

    public void setLayoutUpdateClusteringMoveScaleFactor(double d) {
        this.tf_lu_clustering_moveScale.setText(String.valueOf(d));
    }

    public double getLayoutUpdateClusteringMoveScaleFactor() {
        return Double.parseDouble(this.tf_lu_clustering_moveScale.getText());
    }
}

