/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.layout;

import java.awt.Point;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.jgraph.JGraph;
import org.jgraph.graph.CellView;
import org.jgraph.graph.EdgeView;
import org.jgraph.graph.GraphModel;
import org.jgraph.graph.PortView;
import org.jgraph.graph.VertexView;
import org.jgraph.layout.JGraphLayoutAlgorithm;
import org.jgraph.layout.JGraphLayoutSettings;
import org.jgraph.layout.MoenLayoutSettings;

public class MoenLayoutAlgorithm
extends JGraphLayoutAlgorithm {
    public static final Object CELL_WRAPPER = new Object();
    public static final int LEFT_TO_RIGHT = 0;
    public static final int UP_TO_DOWN = 1;
    public static final int DEFAULT_ORIENTATION = 0;
    JGraph jgraph;
    protected int orientation;
    protected int childParentDistance;

    public MoenLayoutAlgorithm() {
        this.setChildParentDistance(30);
        this.setLayoutOrientation(0);
    }

    public String toString() {
        return "Moen's Tree";
    }

    public String getHint() {
        return "Select a root node";
    }

    public JGraphLayoutSettings createSettings() {
        return new MoenLayoutSettings(this);
    }

    public void setLayoutOrientation(int n) {
        if (n < 0 && n > 1) {
            n = 0;
        } else {
            this.orientation = n;
        }
    }

    public void setChildParentDistance(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Distance has to be positive integer " + n);
        }
        this.childParentDistance = n;
    }

    protected void layout(TreeLayoutNode treeLayoutNode) {
        if (treeLayoutNode == null) {
            return;
        }
        TreeLayoutNode treeLayoutNode2 = treeLayoutNode.child;
        while (treeLayoutNode2 != null) {
            this.layout(treeLayoutNode2);
            treeLayoutNode2 = treeLayoutNode2.sibling;
        }
        if (treeLayoutNode.child != null) {
            this.attachParent(treeLayoutNode, this.join(treeLayoutNode));
        } else {
            this.layoutLeaf(treeLayoutNode);
        }
    }

    protected void attachParent(TreeLayoutNode treeLayoutNode, int n) {
        int n2 = treeLayoutNode.border + this.childParentDistance;
        int n3 = (n - treeLayoutNode.height) / 2 - treeLayoutNode.border;
        int n4 = n3 + treeLayoutNode.height + 2 * treeLayoutNode.border - n;
        treeLayoutNode.child.offset.x = n2 + treeLayoutNode.width;
        treeLayoutNode.child.offset.y = n4;
        treeLayoutNode.contour.upper_head = new PolyLine(treeLayoutNode.width, 0, new PolyLine(n2, n4, treeLayoutNode.contour.upper_head));
        treeLayoutNode.contour.lower_head = new PolyLine(treeLayoutNode.width, 0, new PolyLine(n2, n3, treeLayoutNode.contour.lower_head));
    }

    protected void layoutLeaf(TreeLayoutNode treeLayoutNode) {
        treeLayoutNode.contour.upper_head = treeLayoutNode.contour.upper_tail = new PolyLine(treeLayoutNode.width + 2 * treeLayoutNode.border, 0, null);
        treeLayoutNode.contour.lower_tail = new PolyLine(0, -treeLayoutNode.height - 2 * treeLayoutNode.border, null);
        treeLayoutNode.contour.lower_head = new PolyLine(treeLayoutNode.width + 2 * treeLayoutNode.border, 0, treeLayoutNode.contour.lower_tail);
    }

    protected int join(TreeLayoutNode treeLayoutNode) {
        int n;
        TreeLayoutNode treeLayoutNode2 = treeLayoutNode.child;
        treeLayoutNode.contour = treeLayoutNode2.contour;
        int n2 = n = treeLayoutNode2.height + 2 * treeLayoutNode2.border;
        treeLayoutNode2 = treeLayoutNode2.sibling;
        while (treeLayoutNode2 != null) {
            int n3 = this.merge(treeLayoutNode.contour, treeLayoutNode2.contour);
            treeLayoutNode2.offset.y = n3 + n;
            treeLayoutNode2.offset.x = 0;
            n = treeLayoutNode2.height + 2 * treeLayoutNode2.border;
            n2 += n3 + n;
            treeLayoutNode2 = treeLayoutNode2.sibling;
        }
        return n2;
    }

    protected int merge(Polygon polygon, Polygon polygon2) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        PolyLine polyLine = polygon.lower_head;
        PolyLine polyLine2 = polygon2.upper_head;
        while (polyLine2 != null && polyLine != null) {
            int n4 = this.offset(n3, n2, polyLine2.dx, polyLine2.dy, polyLine.dx, polyLine.dy);
            n2 += n4;
            n += n4;
            if (n3 + polyLine2.dx <= polyLine.dx) {
                n2 += polyLine2.dy;
                n3 += polyLine2.dx;
                polyLine2 = polyLine2.link;
                continue;
            }
            n2 -= polyLine.dy;
            n3 -= polyLine.dx;
            polyLine = polyLine.link;
        }
        if (polyLine2 != null) {
            PolyLine polyLine3 = this.bridge(polygon.upper_tail, 0, 0, polyLine2, n3, n2);
            polygon.upper_tail = polyLine3.link != null ? polygon2.upper_tail : polyLine3;
            polygon.lower_tail = polygon2.lower_tail;
        } else {
            PolyLine polyLine4 = this.bridge(polygon2.lower_tail, n3, n2, polyLine, 0, 0);
            if (polyLine4.link == null) {
                polygon.lower_tail = polyLine4;
            }
        }
        polygon.lower_head = polygon2.lower_head;
        return n;
    }

    protected int offset(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7;
        if (n5 <= n || n + n3 <= 0) {
            return 0;
        }
        int n8 = n5 * n4 - n3 * n6;
        if (n8 > 0) {
            if (n < 0) {
                int n9 = n * n4;
                n7 = n9 / n3 - n2;
            } else if (n > 0) {
                int n10 = n * n6;
                n7 = n10 / n5 - n2;
            } else {
                n7 = -n2;
            }
        } else if (n5 < n + n3) {
            int n11 = (n5 - n) * n4;
            n7 = n6 - (n2 + n11 / n3);
        } else if (n5 > n + n3) {
            int n12 = (n3 + n) * n6;
            n7 = n12 / n5 - (n2 + n4);
        } else {
            n7 = n6 - (n2 + n4);
        }
        if (n7 > 0) {
            return n7;
        }
        return 0;
    }

    protected PolyLine bridge(PolyLine polyLine, int n, int n2, PolyLine polyLine2, int n3, int n4) {
        int n5;
        int n6 = n3 + polyLine2.dx - n;
        if (polyLine2.dx == 0) {
            n5 = polyLine2.dy;
        } else {
            int n7 = n6 * polyLine2.dy;
            n5 = n7 / polyLine2.dx;
        }
        PolyLine polyLine3 = new PolyLine(n6, n5, polyLine2.link);
        polyLine.link = new PolyLine(0, n4 + polyLine2.dy - n5 - n2, polyLine3);
        return polyLine3;
    }

    protected void leftRightNodeLayout(TreeLayoutNode treeLayoutNode, int n, int n2) {
        treeLayoutNode.pos.translate(n + treeLayoutNode.offset.x, n2 + treeLayoutNode.offset.y);
        TreeLayoutNode treeLayoutNode2 = treeLayoutNode.child;
        if (treeLayoutNode2 != null) {
            this.leftRightNodeLayout(treeLayoutNode2, treeLayoutNode.pos.x, treeLayoutNode.pos.y);
            TreeLayoutNode treeLayoutNode3 = treeLayoutNode2.sibling;
            int n3 = treeLayoutNode.pos.y + treeLayoutNode2.offset.y;
            while (treeLayoutNode3 != null) {
                this.leftRightNodeLayout(treeLayoutNode3, treeLayoutNode.pos.x + treeLayoutNode2.offset.x, n3);
                n3 += treeLayoutNode3.offset.y;
                treeLayoutNode3 = treeLayoutNode3.sibling;
            }
        }
    }

    protected void upDownNodeLayout(TreeLayoutNode treeLayoutNode, int n, int n2) {
        treeLayoutNode.pos.translate(n + -1 * treeLayoutNode.offset.y, n2 + treeLayoutNode.offset.x);
        TreeLayoutNode treeLayoutNode2 = treeLayoutNode.child;
        if (treeLayoutNode2 != null) {
            this.upDownNodeLayout(treeLayoutNode2, treeLayoutNode.pos.x, treeLayoutNode.pos.y);
            TreeLayoutNode treeLayoutNode3 = treeLayoutNode2.sibling;
            int n3 = treeLayoutNode.pos.x - treeLayoutNode2.offset.y;
            while (treeLayoutNode3 != null) {
                this.upDownNodeLayout(treeLayoutNode3, n3, treeLayoutNode.pos.y + treeLayoutNode2.offset.x);
                n3 -= treeLayoutNode3.offset.y;
                treeLayoutNode3 = treeLayoutNode3.sibling;
            }
        }
    }

    public void run(JGraph jGraph, Object[] objectArray, int n) {
        this.jgraph = jGraph;
        ArrayList arrayList = this.getRootVertices(new Object[]{objectArray[0]});
        this.buildLayoutHelperTree(arrayList);
        this.layoutTrees(arrayList);
        this.display(arrayList);
    }

    protected ArrayList getRootVertices(Object[] objectArray) {
        HashSet<CellView> hashSet = new HashSet<CellView>();
        HashSet<CellView> hashSet2 = new HashSet<CellView>();
        int n = 0;
        while (n < objectArray.length) {
            CellView cellView = this.jgraph.getGraphLayoutCache().getMapping(objectArray[n], false);
            if (cellView instanceof VertexView) {
                if (!hashSet2.contains(cellView)) {
                    hashSet.add(cellView);
                }
            } else if (cellView instanceof EdgeView) {
                CellView cellView2 = ((EdgeView)cellView).getTarget();
                CellView cellView3 = cellView2.getParentView();
                hashSet.remove(cellView3);
                hashSet2.add(cellView3);
            } else if (!(cellView instanceof PortView)) {
                throw new RuntimeException("Cell is other than Vertex or Edge.");
            }
            ++n;
        }
        return new ArrayList(hashSet);
    }

    protected List getChildren(VertexView vertexView) {
        ArrayList<VertexView> arrayList = new ArrayList<VertexView>();
        Object object = vertexView.getCell();
        GraphModel graphModel = this.jgraph.getModel();
        int n = graphModel.getChildCount(object);
        int n2 = 0;
        while (n2 < n) {
            Object object2 = graphModel.getChild(object, n2);
            Iterator iterator = graphModel.edges(object2);
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (object2 != graphModel.getSource(e)) continue;
                Object object3 = graphModel.getTarget(e);
                Object object4 = graphModel.getParent(object3);
                VertexView vertexView2 = (VertexView)this.jgraph.getGraphLayoutCache().getMapping(object4, false);
                arrayList.add(vertexView2);
            }
            ++n2;
        }
        return arrayList;
    }

    protected void layoutTrees(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            VertexView vertexView = (VertexView)iterator.next();
            TreeLayoutNode treeLayoutNode = this.getTreeLayoutNode(vertexView);
            this.layout(treeLayoutNode);
            Rectangle2D rectangle2D = vertexView.getBounds();
            Point point = new Point((int)rectangle2D.getX(), (int)rectangle2D.getY());
            switch (this.orientation) {
                case 0: {
                    this.leftRightNodeLayout(treeLayoutNode, point.x, point.y);
                    break;
                }
                case 1: {
                    this.upDownNodeLayout(treeLayoutNode, point.x, point.y);
                    break;
                }
                default: {
                    this.leftRightNodeLayout(treeLayoutNode, point.x, point.y);
                }
            }
        }
    }

    protected void buildLayoutHelperTree(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            VertexView vertexView = (VertexView)iterator.next();
            this.decorateNode(vertexView);
        }
    }

    protected void decorateNode(VertexView vertexView) {
        List list = this.getChildren(vertexView);
        TreeLayoutNode treeLayoutNode = this.getTreeLayoutNode(vertexView);
        if (list.size() > 0) {
            int n = 0;
            while (n < list.size()) {
                VertexView vertexView2 = (VertexView)list.get(n);
                TreeLayoutNode treeLayoutNode2 = this.getTreeLayoutNode(vertexView2);
                if (n == 0) {
                    treeLayoutNode.child = treeLayoutNode2;
                } else {
                    VertexView vertexView3 = (VertexView)list.get(n - 1);
                    TreeLayoutNode treeLayoutNode3 = this.getTreeLayoutNode(vertexView3);
                    treeLayoutNode3.sibling = treeLayoutNode2;
                }
                treeLayoutNode2.parent = treeLayoutNode;
                this.decorateNode(vertexView2);
                ++n;
            }
        }
    }

    protected TreeLayoutNode getTreeLayoutNode(VertexView vertexView) {
        return this.getTreeLayoutNode(vertexView, true);
    }

    protected TreeLayoutNode getTreeLayoutNode(VertexView vertexView, boolean bl) {
        TreeLayoutNode treeLayoutNode = (TreeLayoutNode)vertexView.getAttributes().get(CELL_WRAPPER);
        if (treeLayoutNode == null && bl) {
            TreeLayoutNode treeLayoutNode2 = new TreeLayoutNode(vertexView);
            vertexView.getAttributes().put(CELL_WRAPPER, (Object)treeLayoutNode2);
            return treeLayoutNode2;
        }
        return treeLayoutNode;
    }

    protected void display(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            VertexView vertexView = (VertexView)iterator.next();
            this.displayHelper(vertexView);
        }
    }

    protected void displayHelper(VertexView vertexView) {
        TreeLayoutNode treeLayoutNode = this.getTreeLayoutNode(vertexView);
        Rectangle2D rectangle2D = vertexView.getBounds();
        rectangle2D.setFrame(treeLayoutNode.pos.x, treeLayoutNode.pos.y, treeLayoutNode.width, treeLayoutNode.height);
        List list = this.getChildren(vertexView);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            VertexView vertexView2 = (VertexView)iterator.next();
            this.displayHelper(vertexView2);
        }
        vertexView.getAttributes().remove(CELL_WRAPPER);
    }

    private static class PolyLine {
        final int dx;
        final int dy;
        PolyLine link;

        PolyLine(int n, int n2, PolyLine polyLine) {
            this.dx = n;
            this.dy = n2;
            this.link = polyLine;
        }
    }

    private static class Polygon {
        PolyLine lower_head;
        PolyLine lower_tail;
        PolyLine upper_head;
        PolyLine upper_tail;

        private Polygon() {
        }
    }

    private class TreeLayoutNode {
        TreeLayoutNode parent;
        TreeLayoutNode child;
        TreeLayoutNode sibling;
        final int width;
        final int height;
        final int border;
        final Point pos;
        final Point offset;
        Polygon contour;

        public TreeLayoutNode(VertexView vertexView) {
            this.width = (int)vertexView.getBounds().getWidth();
            this.height = (int)vertexView.getBounds().getHeight();
            this.border = 5;
            this.pos = new Point();
            this.offset = new Point();
            this.contour = new Polygon();
        }
    }
}

