/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.layout;

import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jgraph.layout.JGraphLayoutSettings;
import org.jgraph.layout.MoenLayoutAlgorithm;

public class MoenLayoutSettings
extends JPanel
implements JGraphLayoutSettings {
    protected MoenLayoutAlgorithm layout;
    private JComboBox orientationCombo = new JComboBox<Object>(new Object[]{"West-East", "North-South"});
    private JTextField nodeDistanceTextField = new JTextField();

    public MoenLayoutSettings(MoenLayoutAlgorithm moenLayoutAlgorithm) {
        this.layout = moenLayoutAlgorithm;
        JPanel jPanel = new JPanel(new GridLayout(2, 2, 4, 4));
        jPanel.add(new JLabel("Orientation"));
        jPanel.add(this.orientationCombo);
        jPanel.add(new JLabel("Node Distance"));
        jPanel.add(this.nodeDistanceTextField);
        this.add((Component)jPanel, "Center");
        this.revert();
    }

    public void revert() {
        this.setOrientation(this.layout.orientation);
        this.nodeDistanceTextField.setText(String.valueOf(this.layout.childParentDistance));
    }

    private void check() {
        try {
            Integer.parseInt(this.nodeDistanceTextField.getText());
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(exception.getMessage());
        }
    }

    public void apply() {
        this.check();
        this.layout.orientation = this.getOrientation();
        this.layout.childParentDistance = Integer.parseInt(this.nodeDistanceTextField.getText());
    }

    public int getOrientation() {
        int n = 0;
        switch (this.orientationCombo.getSelectedIndex()) {
            case 1: {
                n = 1;
            }
        }
        return n;
    }

    public void setOrientation(int n) {
        int n2 = 0;
        switch (n) {
            case 1: {
                n2 = 1;
            }
        }
        this.orientationCombo.setSelectedIndex(n2);
    }
}

