/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.layout;

import java.awt.Component;
import java.awt.GridLayout;
import java.util.Properties;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jgraph.layout.JGraphLayoutSettings;
import org.jgraph.layout.RadialTreeLayoutAlgorithm;

public class RadialTreeLayoutSettings
extends JPanel
implements JGraphLayoutSettings {
    protected RadialTreeLayoutAlgorithm layout;
    private JTextField widthTextField = new JTextField();
    private JTextField heightTextField = new JTextField();
    private JTextField radiusXTextField = new JTextField();
    private JTextField radiusYTextField = new JTextField();
    private JTextField centerXTextField = new JTextField();
    private JTextField centerYTextField = new JTextField();

    public RadialTreeLayoutSettings(RadialTreeLayoutAlgorithm radialTreeLayoutAlgorithm) {
        this.layout = radialTreeLayoutAlgorithm;
        JPanel jPanel = new JPanel(new GridLayout(6, 2, 4, 4));
        jPanel.add(new JLabel("Width"));
        jPanel.add(this.widthTextField);
        jPanel.add(new JLabel("Height"));
        jPanel.add(this.heightTextField);
        jPanel.add(new JLabel("Radius X"));
        jPanel.add(this.radiusXTextField);
        jPanel.add(new JLabel("Radius Y"));
        jPanel.add(this.radiusYTextField);
        jPanel.add(new JLabel("Center X"));
        jPanel.add(this.centerXTextField);
        jPanel.add(new JLabel("Center Y"));
        jPanel.add(this.centerYTextField);
        this.add((Component)jPanel, "Center");
        this.revert();
    }

    public void revert() {
        this.widthTextField.setText(String.valueOf(this.layout.WIDTH));
        this.heightTextField.setText(String.valueOf(this.layout.HEIGHT));
        if (this.layout.WIDTH == 0.0) {
            this.centerXTextField.setText(String.valueOf(this.layout.ROOTX));
            this.radiusXTextField.setText(String.valueOf(this.layout.RADIUSX));
        } else {
            this.centerXTextField.setText("0");
            this.radiusXTextField.setText("0");
        }
        if (this.layout.HEIGHT == 0.0) {
            this.centerYTextField.setText(String.valueOf(this.layout.ROOTY));
            this.radiusYTextField.setText(String.valueOf(this.layout.RADIUSY));
        } else {
            this.centerYTextField.setText("0");
            this.radiusYTextField.setText("0");
        }
    }

    private void check() {
        try {
            Double.parseDouble(this.widthTextField.getText());
            Double.parseDouble(this.heightTextField.getText());
            Double.parseDouble(this.centerXTextField.getText());
            Double.parseDouble(this.centerYTextField.getText());
            Double.parseDouble(this.radiusXTextField.getText());
            Double.parseDouble(this.radiusYTextField.getText());
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(exception.getMessage());
        }
    }

    public void apply() {
        this.check();
        Properties properties = new Properties();
        properties.put("Width", this.widthTextField.getText());
        properties.put("Height", this.heightTextField.getText());
        properties.put("CentreX", this.centerXTextField.getText());
        properties.put("CentreY", this.centerYTextField.getText());
        properties.put("RadiusX", this.radiusXTextField.getText());
        properties.put("RadiusY", this.radiusYTextField.getText());
        this.layout.setConfiguration(properties);
    }
}

