/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.util;

import java.awt.AlphaComposite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.color.ColorSpace;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.jgraph.JGraph;
import org.jgraph.algebra.CostFunction;
import org.jgraph.algebra.DefaultCostFunction;
import org.jgraph.algebra.PriorityQueue;
import org.jgraph.algebra.UnionFind;
import org.jgraph.graph.CellView;
import org.jgraph.graph.ConnectionSet;
import org.jgraph.graph.DefaultGraphCell;
import org.jgraph.graph.DefaultGraphModel;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphLayoutCache;
import org.jgraph.graph.GraphModel;
import org.jgraph.graph.ParentMap;
import org.jgraph.layout.JGraphLayoutAlgorithm;

public class JGraphUtilities {
    public static final int ALIGN_LEFT = 2;
    public static final int ALIGN_RIGHT = 4;
    public static final int ALIGN_TOP = 1;
    public static final int ALIGN_BOTTOM = 3;
    public static final int ALIGN_CENTER = 0;
    public static final int ALIGN_MIDDLE = 12;

    public static BufferedImage toImage(JGraph jGraph, int n) {
        Object[] objectArray = jGraph.getRoots();
        if (objectArray.length > 0) {
            Rectangle2D rectangle2D = jGraph.getCellBounds(objectArray);
            jGraph.toScreen(rectangle2D);
            ColorSpace colorSpace = ColorSpace.getInstance(1000);
            ComponentColorModel componentColorModel = new ComponentColorModel(colorSpace, false, true, 1, 0);
            BufferedImage bufferedImage = new BufferedImage((int)rectangle2D.getWidth() + 2 * n, (int)rectangle2D.getHeight() + 2 * n, 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            if (jGraph.isOpaque()) {
                graphics2D.setColor(jGraph.getBackground());
                graphics2D.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
            } else {
                graphics2D.setComposite(AlphaComposite.getInstance(1, 0.0f));
                graphics2D.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
                graphics2D.setComposite(AlphaComposite.SrcOver);
            }
            graphics2D.translate((int)(-rectangle2D.getX() + (double)n), (int)(-rectangle2D.getY() + (double)n));
            boolean bl = jGraph.isDoubleBuffered();
            jGraph.setDoubleBuffered(false);
            jGraph.paint((Graphics)graphics2D);
            jGraph.setDoubleBuffered(bl);
            return bufferedImage;
        }
        return null;
    }

    public static Object[] getAll(JGraph jGraph) {
        return jGraph.getDescendants(jGraph.getRoots());
    }

    public static Object[] getVertices(JGraph jGraph, Object[] objectArray) {
        if (objectArray != null) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            GraphModel graphModel = jGraph.getModel();
            int n = 0;
            while (n < objectArray.length) {
                if (!(graphModel.isPort(objectArray[n]) || graphModel.isEdge(objectArray[n]) || JGraphUtilities.isGroup(jGraph, objectArray[n]))) {
                    arrayList.add(objectArray[n]);
                }
                ++n;
            }
            return arrayList.toArray();
        }
        return null;
    }

    public static Object[] getEdges(JGraph jGraph) {
        Object[] objectArray = jGraph.getDescendants(jGraph.getRoots());
        if (objectArray != null) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            GraphModel graphModel = jGraph.getModel();
            int n = 0;
            while (n < objectArray.length) {
                if (graphModel.isEdge(objectArray[n])) {
                    arrayList.add(objectArray[n]);
                }
                ++n;
            }
            return arrayList.toArray();
        }
        return null;
    }

    public static Object[] getEdges(JGraph jGraph, Object[] objectArray) {
        if (objectArray != null) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            GraphModel graphModel = jGraph.getModel();
            int n = 0;
            while (n < objectArray.length) {
                if (graphModel.isEdge(objectArray[n])) {
                    arrayList.add(objectArray[n]);
                }
                ++n;
            }
            return arrayList.toArray();
        }
        return null;
    }

    public static Object getNeighbour(JGraph jGraph, Object object, Object object2) {
        Object object3 = JGraphUtilities.getSourceVertex(jGraph, object);
        if (object2 == object3) {
            return JGraphUtilities.getTargetVertex(jGraph, object);
        }
        return object3;
    }

    public static Object getSourceVertex(JGraph jGraph, Object object) {
        Object object2 = jGraph.getModel().getSource(object);
        return jGraph.getModel().getParent(object2);
    }

    public static Object getTargetVertex(JGraph jGraph, Object object) {
        Object object2 = jGraph.getModel().getTarget(object);
        return jGraph.getModel().getParent(object2);
    }

    public static boolean isVertex(JGraph jGraph, Object object) {
        return !jGraph.getModel().isEdge(object) && !jGraph.getModel().isPort(object) && !JGraphUtilities.isGroup(jGraph, object);
    }

    public static boolean isGroup(JGraph jGraph, Object object) {
        CellView cellView = jGraph.getGraphLayoutCache().getMapping(object, false);
        if (cellView != null) {
            return !cellView.isLeaf();
        }
        return false;
    }

    public static boolean isVertex(GraphModel graphModel, Object object) {
        return !graphModel.isEdge(object) && !graphModel.isPort(object) && !JGraphUtilities.isGroup(graphModel, object);
    }

    public static boolean isGroup(GraphModel graphModel, Object object) {
        int n = 0;
        while (n < graphModel.getChildCount(object)) {
            if (!graphModel.isPort(graphModel.getChild(object, n))) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static void connect(JGraph jGraph, DefaultGraphCell defaultGraphCell, Object[] objectArray) {
        Object[] objectArray2 = JGraphUtilities.getVertices(jGraph, objectArray);
        if (objectArray2 != null && objectArray2.length < 20) {
            ConnectionSet connectionSet = new ConnectionSet();
            int n = 0;
            while (n < objectArray2.length) {
                int n2 = n + 1;
                while (n2 < objectArray2.length) {
                    if (!JGraphUtilities.isNeighbour(jGraph, objectArray2[n], objectArray2[n2])) {
                        Object object = defaultGraphCell.clone();
                        Object object2 = jGraph.getModel().getChild(objectArray2[n], 0);
                        Object object3 = jGraph.getModel().getChild(objectArray2[n2], 0);
                        connectionSet.connect(object, object2, object3);
                    }
                    ++n2;
                }
                ++n;
            }
            if (!connectionSet.isEmpty()) {
                jGraph.getGraphLayoutCache().insert(connectionSet.getChangedEdges().toArray(), null, connectionSet, null, null);
            }
        } else {
            throw new IllegalArgumentException("Too many cells selected");
        }
    }

    public static boolean isNeighbour(JGraph jGraph, Object object, Object object2) {
        Object[] objectArray = JGraphUtilities.getEdgesBetween(jGraph, object, object2);
        return objectArray != null && objectArray.length > 0;
    }

    public static Object[] getEdgesBetween(JGraph jGraph, Object object, Object object2) {
        return JGraphUtilities.getEdgesBetween(jGraph, object, object2, false);
    }

    public static Object[] getEdgesBetween(JGraph jGraph, Object object, Object object2, boolean bl) {
        ArrayList arrayList = new ArrayList();
        Set set = DefaultGraphModel.getEdges((GraphModel)jGraph.getModel(), (Object[])new Object[]{object});
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            Object object3 = JGraphUtilities.getSourceVertex(jGraph, e);
            Object object4 = JGraphUtilities.getTargetVertex(jGraph, e);
            if ((object3 != object || object4 != object2) && (bl || object3 != object2 || object4 != object)) continue;
            arrayList.add(e);
        }
        return arrayList.toArray();
    }

    public static Object[] getEdgesBetweenPorts(JGraph jGraph, Object object, Object object2) {
        return JGraphUtilities.getEdgesBetweenPorts(jGraph, object, object2, false);
    }

    public static Object[] getEdgesBetweenPorts(JGraph jGraph, Object object, Object object2, boolean bl) {
        ArrayList arrayList = new ArrayList();
        Set set = DefaultGraphModel.getEdges((GraphModel)jGraph.getModel(), (Object[])new Object[]{object});
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            Object object3 = jGraph.getModel().getSource(e);
            Object object4 = jGraph.getModel().getTarget(e);
            if ((object3 != object || object4 != object2) && (bl || object3 != object2 || object4 != object)) continue;
            arrayList.add(e);
        }
        return arrayList.toArray();
    }

    public static Object[] getFanIn(JGraph jGraph, Object object) {
        ArrayList arrayList = new ArrayList();
        GraphModel graphModel = jGraph.getModel();
        Set set = DefaultGraphModel.getEdges((GraphModel)graphModel, (Object[])new Object[]{object});
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            Object object2 = graphModel.getTarget(e);
            Object object3 = graphModel.getParent(object2);
            if (object2 != object && object3 != object) continue;
            arrayList.add(e);
        }
        return arrayList.toArray();
    }

    public static Object[] getFanOut(JGraph jGraph, Object object) {
        ArrayList arrayList = new ArrayList();
        GraphModel graphModel = jGraph.getModel();
        Set set = DefaultGraphModel.getEdges((GraphModel)graphModel, (Object[])new Object[]{object});
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            Object object2 = graphModel.getSource(e);
            Object object3 = graphModel.getParent(object2);
            if (object2 != object && object3 != object) continue;
            arrayList.add(e);
        }
        return arrayList.toArray();
    }

    public static CostFunction createDefaultCostFunction() {
        return new DefaultCostFunction();
    }

    public static UnionFind getComponents(JGraph jGraph) {
        UnionFind unionFind = new UnionFind();
        Object[] objectArray = JGraphUtilities.getVertices(jGraph, JGraphUtilities.getAll(jGraph));
        int n = 0;
        while (n < objectArray.length) {
            unionFind.find(objectArray[n]);
            ++n;
        }
        Object[] objectArray2 = JGraphUtilities.getEdges(jGraph);
        int n2 = 0;
        while (n2 < objectArray2.length) {
            Object object = JGraphUtilities.getSourceVertex(jGraph, objectArray2[n2]);
            Object object2 = JGraphUtilities.getTargetVertex(jGraph, objectArray2[n2]);
            unionFind.union(unionFind.find(object), unionFind.find(object2));
            ++n2;
        }
        return unionFind;
    }

    public static Object[] getShortestPath(JGraph jGraph, Object object, Object object2, CostFunction costFunction) {
        Object object3;
        if (costFunction == null) {
            costFunction = JGraphUtilities.createDefaultCostFunction();
        }
        GraphModel graphModel = jGraph.getModel();
        PriorityQueue priorityQueue = new PriorityQueue();
        Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>();
        priorityQueue.setPrio(object, 0.0);
        int n = JGraphUtilities.getVertices(jGraph, JGraphUtilities.getAll(jGraph)).length;
        int n2 = 0;
        while (n2 < n) {
            double d = priorityQueue.getPrio();
            object3 = priorityQueue.pop();
            if (object3 == object2) break;
            Object[] objectArray = new Object[]{object3};
            Object[] objectArray2 = DefaultGraphModel.getEdges((GraphModel)graphModel, (Object[])objectArray).toArray();
            if (objectArray2 != null) {
                int n3 = 0;
                while (n3 < objectArray2.length) {
                    Object object4 = JGraphUtilities.getNeighbour(jGraph, objectArray2[n3], object3);
                    double d2 = d + costFunction.getCost(jGraph, objectArray2[n3]);
                    if (object4 != null && object4 != object3 && d2 < priorityQueue.getPrio(object4)) {
                        hashtable.put(object4, objectArray2[n3]);
                        priorityQueue.setPrio(object4, d2);
                    }
                    ++n3;
                }
            }
            if (priorityQueue.isEmpty()) break;
            ++n2;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Object object5 = object2;
        while (object5 != null) {
            arrayList.add(object5);
            object3 = hashtable.get(object5);
            if (object3 != null) {
                arrayList.add(object3);
                object5 = JGraphUtilities.getNeighbour(jGraph, object3, object5);
                continue;
            }
            object5 = null;
        }
        return arrayList.toArray();
    }

    public static Object[] getSpanningTree(JGraph jGraph, CostFunction costFunction) {
        Object object;
        Object object2;
        Object object3;
        if (costFunction == null) {
            costFunction = JGraphUtilities.createDefaultCostFunction();
        }
        SortedSet sortedSet = JGraphUtilities.sort(jGraph, JGraphUtilities.getEdges(jGraph), costFunction);
        UnionFind unionFind = new UnionFind();
        HashSet<Object> hashSet = new HashSet<Object>();
        while (!sortedSet.isEmpty()) {
            object3 = sortedSet.first();
            sortedSet.remove(object3);
            object2 = unionFind.find(JGraphUtilities.getSourceVertex(jGraph, object3));
            object = unionFind.find(JGraphUtilities.getTargetVertex(jGraph, object3));
            if (object2 != null && object != null && object2 == object) continue;
            unionFind.union(object2, object);
            hashSet.add(object3);
        }
        object3 = new HashSet();
        object2 = hashSet.iterator();
        while (object2.hasNext()) {
            object = object2.next();
            Object object4 = JGraphUtilities.getSourceVertex(jGraph, object);
            Object object5 = JGraphUtilities.getTargetVertex(jGraph, object);
            if (object4 != null) {
                ((HashSet)object3).add(object4);
            }
            if (object5 == null) continue;
            ((HashSet)object3).add(object5);
        }
        object = new Object[hashSet.size() + ((HashSet)object3).size()];
        System.arraycopy(hashSet.toArray(), 0, object, 0, hashSet.size());
        System.arraycopy(((HashSet)object3).toArray(), 0, object, hashSet.size(), ((HashSet)object3).size());
        return object;
    }

    public static SortedSet sort(final JGraph jGraph, Object[] objectArray, final CostFunction costFunction) {
        TreeSet<Object> treeSet = new TreeSet<Object>(new Comparator(){

            public int compare(Object object, Object object2) {
                Double d = new Double(costFunction.getCost(jGraph, object));
                Double d2 = new Double(costFunction.getCost(jGraph, object2));
                return d.compareTo(d2);
            }
        });
        int n = 0;
        while (n < objectArray.length) {
            treeSet.add(objectArray[n]);
            ++n;
        }
        return treeSet;
    }

    public static void editCells(JGraph jGraph, Object[] objectArray, Map map) {
        if (jGraph != null && map != null && objectArray != null && objectArray.length > 0) {
            Hashtable<Object, Map> hashtable = new Hashtable<Object, Map>();
            int n = 0;
            while (n < objectArray.length) {
                hashtable.put(objectArray[n], map);
                ++n;
            }
            if (!hashtable.isEmpty()) {
                jGraph.getGraphLayoutCache().edit(hashtable, null, null, null);
            }
        }
    }

    public static void removeCells(JGraph jGraph, Object[] objectArray) {
        if (jGraph != null && objectArray != null && objectArray.length > 0) {
            objectArray = jGraph.getDescendants(objectArray);
            jGraph.getGraphLayoutCache().remove(objectArray);
        }
    }

    public static void group(JGraph jGraph, Object object, Object[] objectArray) {
        objectArray = jGraph.getGraphLayoutCache().order(objectArray);
        if (objectArray != null && objectArray.length > 0) {
            ParentMap parentMap = new ParentMap();
            int n = objectArray.length - 1;
            while (n >= 0) {
                parentMap.addEntry(objectArray[n], object);
                --n;
            }
            jGraph.getGraphLayoutCache().insert(new Object[]{object}, null, null, parentMap, null);
        }
    }

    public static void ungroup(JGraph jGraph, Object[] objectArray) {
        if (objectArray != null && objectArray.length > 0) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            int n = 0;
            while (n < objectArray.length) {
                arrayList.add(objectArray[n]);
                boolean bl = false;
                int n2 = 0;
                while (n2 < jGraph.getModel().getChildCount(objectArray[n])) {
                    Object object = jGraph.getModel().getChild(objectArray[n], n2);
                    if (!jGraph.getModel().isPort(object)) {
                        arrayList2.add(object);
                        bl = true;
                    }
                    ++n2;
                }
                if (bl) {
                    arrayList.add(objectArray[n]);
                }
                ++n;
            }
            jGraph.getGraphLayoutCache().remove(arrayList.toArray());
            jGraph.setSelectionCells(arrayList2.toArray());
        }
    }

    public static void alignCells(JGraph jGraph, Object[] objectArray, int n) {
        Rectangle2D rectangle2D = jGraph.getCellBounds(objectArray);
        GraphLayoutCache graphLayoutCache = jGraph.getGraphLayoutCache();
        Hashtable hashtable = new Hashtable();
        int n2 = 0;
        while (n2 < objectArray.length) {
            CellView cellView = graphLayoutCache.getMapping(objectArray[n2], false);
            Rectangle2D rectangle2D2 = GraphConstants.getBounds((Map)cellView.getAllAttributes());
            if (rectangle2D != null && rectangle2D2 != null) {
                Hashtable hashtable2 = new Hashtable();
                Rectangle2D rectangle2D3 = JGraphUtilities.align(n, (Rectangle2D)rectangle2D2.clone(), rectangle2D);
                GraphConstants.setBounds(hashtable2, (Rectangle2D)rectangle2D3);
                hashtable.put(cellView.getCell(), hashtable2);
            }
            ++n2;
        }
        if (!hashtable.isEmpty()) {
            graphLayoutCache.edit(hashtable, null, null, null);
        }
    }

    public static Rectangle2D align(int n, Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        switch (n) {
            case 2: {
                rectangle2D.setFrame(rectangle2D2.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
                break;
            }
            case 1: {
                rectangle2D.setFrame(rectangle2D.getX(), rectangle2D2.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
                break;
            }
            case 4: {
                rectangle2D.setFrame(rectangle2D2.getX() + rectangle2D2.getWidth() - rectangle2D.getWidth(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
                break;
            }
            case 3: {
                rectangle2D.setFrame(rectangle2D.getX(), rectangle2D2.getY() + rectangle2D2.getHeight() - rectangle2D.getHeight(), rectangle2D.getWidth(), rectangle2D.getHeight());
                break;
            }
            case 0: {
                double d = rectangle2D2.getWidth() / 2.0;
                rectangle2D.setFrame(rectangle2D2.getX() + d - rectangle2D.getWidth() / 2.0, rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
                break;
            }
            case 12: {
                double d = rectangle2D2.getHeight() / 2.0;
                rectangle2D.setFrame(rectangle2D.getX(), rectangle2D2.getY() + d - rectangle2D.getHeight() / 2.0, rectangle2D.getWidth(), rectangle2D.getHeight());
            }
        }
        return rectangle2D;
    }

    public static void applyLayout(JGraph jGraph, JGraphLayoutAlgorithm jGraphLayoutAlgorithm) {
        Object[] objectArray = jGraph.isSelectionEmpty() ? JGraphUtilities.getAll(jGraph) : jGraph.getSelectionCells();
        JGraphLayoutAlgorithm.applyLayout(jGraph, objectArray, jGraphLayoutAlgorithm);
    }

    public static void collapseGroups(JGraph jGraph, Object[] objectArray) {
        if (objectArray != null) {
            Set set = DefaultGraphModel.getDescendants((GraphModel)jGraph.getModel(), (Object[])objectArray);
            int n = 0;
            while (n < objectArray.length) {
                set.remove(objectArray[n]);
                CellView cellView = jGraph.getGraphLayoutCache().getMapping(objectArray[n], false);
                ++n;
            }
            int n2 = 0;
            while (n2 < objectArray.length) {
                int n3 = 0;
                while (n3 < jGraph.getModel().getChildCount(objectArray[n2])) {
                    Object object = jGraph.getModel().getChild(objectArray[n2], n3);
                    if (jGraph.getModel().isPort(object)) {
                        set.remove(object);
                    }
                    ++n3;
                }
                ++n2;
            }
            jGraph.getGraphLayoutCache().setVisible(set.toArray(), false);
            jGraph.setSelectionCells(objectArray);
        }
    }

    public static void expandGroups(JGraph jGraph, Object[] objectArray) {
        GraphModel graphModel = jGraph.getModel();
        HashSet<Object> hashSet = new HashSet<Object>();
        if (objectArray != null) {
            int n = 0;
            while (n < objectArray.length) {
                int n2 = 0;
                while (n2 < graphModel.getChildCount(objectArray[n])) {
                    hashSet.add(graphModel.getChild(objectArray[n], n2));
                    ++n2;
                }
                ++n;
            }
            jGraph.getGraphLayoutCache().setVisible(hashSet.toArray(), true);
            jGraph.setSelectionCells(objectArray);
        }
    }
}

