/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.demos;

import java.io.Serializable;
import java.util.StringTokenizer;
import javax.swing.tree.DefaultMutableTreeNode;

class MyNode
extends DefaultMutableTreeNode {
    String name = "<unnamed>";

    MyNode(String name) {
        this.name = name;
    }

    MyNode(String name, Serializable user_obj) {
        super(user_obj);
        this.name = name;
    }

    void add(String fqn) {
        this.add(fqn, null);
    }

    public void add(String fqn, Serializable user_obj) {
        if (fqn == null) {
            return;
        }
        MyNode curr = this;
        StringTokenizer tok = new StringTokenizer(fqn, "/");
        while (tok.hasMoreTokens()) {
            String child_name = tok.nextToken();
            MyNode n = curr.findChild(child_name);
            if (n == null) {
                n = new MyNode(child_name, user_obj);
                curr.add(n);
            }
            curr = n;
        }
        curr.userObject = user_obj;
    }

    void modify(String fqn, Serializable new_element) {
        if (fqn == null || new_element == null) {
            return;
        }
        MyNode n = this.findNode(fqn);
        if (n != null) {
            n.userObject = new_element;
        }
    }

    void remove(String fqn) {
        System.out.println("MyNode.remove(" + fqn + ')');
        this.removeFromParent();
    }

    public MyNode findNode(String fqn) {
        if (fqn == null) {
            return null;
        }
        MyNode curr = this;
        StringTokenizer tok = new StringTokenizer(fqn, "/");
        while (tok.hasMoreTokens()) {
            String child_name = tok.nextToken();
            MyNode n = curr.findChild(child_name);
            if (n == null) {
                return null;
            }
            curr = n;
        }
        return curr;
    }

    MyNode findChild(String relative_name) {
        if (relative_name == null || this.getChildCount() == 0) {
            return null;
        }
        for (int i = 0; i < this.getChildCount(); ++i) {
            MyNode child = (MyNode)this.getChildAt(i);
            if (child.name == null) {
                System.err.println("MyNode.findChild(" + relative_name + "): child.name is null");
                continue;
            }
            if (!child.name.equals(relative_name)) continue;
            return child;
        }
        return null;
    }

    String print(int indent) {
        int i;
        StringBuffer sb = new StringBuffer();
        for (i = 0; i < indent; ++i) {
            sb.append(' ');
        }
        if (!this.isRoot()) {
            if (this.name == null) {
                sb.append("/<unnamed>");
            } else {
                sb.append('/' + this.name);
                if (this.userObject != null) {
                    sb.append(" --> " + this.userObject);
                }
            }
        }
        sb.append('\n');
        if (this.getChildCount() > 0) {
            indent = this.isRoot() ? 0 : (indent += 4);
            for (i = 0; i < this.getChildCount(); ++i) {
                sb.append(((MyNode)this.getChildAt(i)).print(indent));
            }
        }
        return sb.toString();
    }

    public String toString() {
        return this.name;
    }
}

