/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import EDU.oswego.cs.dl.util.concurrent.LinkedQueue;
import EDU.oswego.cs.dl.util.concurrent.WaitFreeQueue;
import java.util.LinkedList;
import org.jgroups.util.Queue;
import org.jgroups.util.Queue2;
import org.jgroups.util.QueueClosedException;

public class QueueTest2 {
    Queueable q = null;
    long start;
    long stop;
    long NUM = 1000000L;

    void start(Queueable q, String msg) throws Exception {
        this.q = q;
        System.out.println("-- starting test with " + q.getClass() + " (" + msg + ')');
        this.start = System.currentTimeMillis();
        Adder adder = new Adder();
        Remover remover = new Remover();
        remover.start();
        adder.start();
        adder.join();
        remover.join();
        System.out.println("-- done with " + q.getClass());
        System.out.println(" total time for " + this.NUM + " elements: " + (this.stop - this.start) + " msecs\n\n");
    }

    public static void main(String[] args) {
        try {
            QueueTest2 qt = new QueueTest2();
            Queueable q = new JgQueue();
            qt.start(q, "based on org.jgroups.util.Queue");
            q = new JgQueue2();
            qt.start(q, "based on org.jgroups.util.Queue2 (using util.concurrent Mutexes and CondVars)");
            q = new MyQueue();
            qt.start(q, "based on java.util.LinkedList");
            q = new MyLinkedQueue();
            qt.start(q, "based on EDU.oswego.cs.dl.util.concurrent.LinkedQueue");
            q = new MyWaitFreeQueue();
            qt.start(q, "based on EDU.oswego.cs.dl.util.concurrent.WaitFreeQueue");
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static class MyWaitFreeQueue
    extends WaitFreeQueue
    implements Queueable {
        public void addElement(Object o) {
            try {
                super.put(o);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

        public Object removeElement() {
            try {
                return super.take();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return null;
            }
        }
    }

    public static class MyLinkedQueue
    extends LinkedQueue
    implements Queueable {
        public void addElement(Object o) {
            try {
                super.put(o);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

        public Object removeElement() {
            try {
                return super.take();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return null;
            }
        }
    }

    public static class MyQueue
    extends LinkedList
    implements Queueable {
        Object mutex = new Object();
        boolean waiting = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addElement(Object o) {
            Object object = this.mutex;
            synchronized (object) {
                super.add(o);
                if (this.waiting) {
                    this.mutex.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object removeElement() {
            Object object = this.mutex;
            synchronized (object) {
                Object e;
                if (this.size() > 0) {
                    return this.removeFirst();
                }
                this.waiting = true;
                try {
                    this.mutex.wait();
                    e = this.removeFirst();
                    this.waiting = false;
                }
                catch (InterruptedException e2) {
                    Object var3_4;
                    try {
                        e2.printStackTrace();
                        var3_4 = null;
                        this.waiting = false;
                    }
                    catch (Throwable throwable) {
                        this.waiting = false;
                        throw throwable;
                    }
                    return var3_4;
                }
                return e;
            }
        }
    }

    public static class JgQueue2
    extends Queue2
    implements Queueable {
        public void addElement(Object o) {
            try {
                this.add(o);
            }
            catch (QueueClosedException e) {
                e.printStackTrace();
            }
        }

        public Object removeElement() {
            try {
                return this.remove();
            }
            catch (QueueClosedException e) {
                e.printStackTrace();
                return null;
            }
        }
    }

    public static class JgQueue
    extends Queue
    implements Queueable {
        public void addElement(Object o) {
            try {
                this.add(o);
            }
            catch (QueueClosedException e) {
                e.printStackTrace();
            }
        }

        public Object removeElement() {
            try {
                return this.remove();
            }
            catch (QueueClosedException e) {
                e.printStackTrace();
                return null;
            }
        }
    }

    class Remover
    extends Thread {
        int i = 0;

        Remover() {
        }

        public void run() {
            do {
                try {
                    QueueTest2.this.q.removeElement();
                    ++this.i;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } while ((long)this.i < QueueTest2.this.NUM);
            QueueTest2.this.stop = System.currentTimeMillis();
        }
    }

    class Adder
    extends Thread {
        Adder() {
        }

        public void run() {
            int i = 0;
            while ((long)i < QueueTest2.this.NUM) {
                try {
                    QueueTest2.this.q.addElement(new Integer(i));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++i;
            }
        }
    }

    public static interface Queueable {
        public void addElement(Object var1);

        public Object removeElement();
    }
}

