/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.jgroups.JChannel;
import org.jgroups.Message;

public class SendAndReceiveTest
extends TestCase {
    JChannel channel;
    final int NUM_MSGS = 1000;
    final long TIMEOUT = 30000L;
    String props1 = "UDP(loopback=true;mcast_addr=228.8.8.8;mcast_port=27000;ip_ttl=1;mcast_send_buf_size=64000;mcast_recv_buf_size=64000):PING(timeout=2000;num_initial_members=3):MERGE2(min_interval=5000;max_interval=10000):FD_SOCK:VERIFY_SUSPECT(timeout=1500):pbcast.NAKACK(max_xmit_size=8096;gc_lag=50;retransmit_timeout=300,600,1200,2400,4800):UNICAST(timeout=600,1200,2400,4800):pbcast.STABLE(desired_avg_gossip=20000):FRAG(frag_size=8096;down_thread=false;up_thread=false):pbcast.GMS(join_timeout=5000;join_retry_timeout=2000;shun=false;print_local_addr=true)";
    String props2 = "UDP(loopback=false;mcast_addr=228.8.8.8;mcast_port=27000;ip_ttl=1;mcast_send_buf_size=64000;mcast_recv_buf_size=64000):PING(timeout=2000;num_initial_members=3):MERGE2(min_interval=5000;max_interval=10000):FD_SOCK:VERIFY_SUSPECT(timeout=1500):pbcast.NAKACK(max_xmit_size=8096;gc_lag=50;retransmit_timeout=300,600,1200,2400,4800):UNICAST(timeout=600,1200,2400,4800):pbcast.STABLE(desired_avg_gossip=20000):FRAG(frag_size=8096;down_thread=false;up_thread=false):pbcast.GMS(join_timeout=5000;join_retry_timeout=2000;shun=false;print_local_addr=true)";
    String props3 = "LOOPBACK:PING(timeout=2000;num_initial_members=3):MERGE2(min_interval=5000;max_interval=10000):FD_SOCK:VERIFY_SUSPECT(timeout=1500):pbcast.NAKACK(max_xmit_size=8096;gc_lag=50;retransmit_timeout=300,600,1200,2400,4800):UNICAST(timeout=600,1200,2400,4800):pbcast.STABLE(desired_avg_gossip=20000):FRAG(frag_size=8096;down_thread=false;up_thread=false):pbcast.GMS(join_timeout=5000;join_retry_timeout=2000;shun=false;print_local_addr=true)";
    static /* synthetic */ Class class$org$jgroups$tests$SendAndReceiveTest;

    public SendAndReceiveTest(String n) {
        super(n);
    }

    public void setUp(String props) {
        try {
            this.channel = new JChannel(props);
            this.channel.connect("test1");
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
            SendAndReceiveTest.fail((String)"channel could not be created");
        }
    }

    public void tearDown() {
        if (this.channel != null) {
            this.channel.close();
            this.channel = null;
        }
    }

    public void testSendAndReceiveWithDefaultUDP_Loopback() {
        this.setUp(this.props1);
        this.sendMessages(1000);
        int received_msgs = this.receiveMessages(1000, 30000L);
        SendAndReceiveTest.assertTrue((received_msgs >= 1000 ? 1 : 0) != 0);
    }

    public void testSendAndReceiveWithDefaultUDP_NoLoopback() {
        this.setUp(this.props2);
        this.sendMessages(1000);
        int received_msgs = this.receiveMessages(1000, 30000L);
        SendAndReceiveTest.assertTrue((received_msgs >= 1000 ? 1 : 0) != 0);
    }

    public void testSendAndReceiveWithLoopback() {
        this.setUp(this.props3);
        this.sendMessages(1000);
        int received_msgs = this.receiveMessages(1000, 30000L);
        SendAndReceiveTest.assertTrue((received_msgs >= 1000 ? 1 : 0) != 0);
    }

    private void sendMessages(int num) {
        for (int i = 0; i < num; ++i) {
            try {
                Message msg = new Message();
                this.channel.send(msg);
                System.out.print(i + " ");
                continue;
            }
            catch (Throwable t) {
                SendAndReceiveTest.fail((String)("could not send message #" + i));
            }
        }
    }

    private int receiveMessages(int num, long timeout) {
        long current;
        long wait_time;
        int received = 0;
        if (timeout <= 0L) {
            timeout = 5000L;
        }
        long start = System.currentTimeMillis();
        while ((wait_time = timeout - ((current = System.currentTimeMillis()) - start)) > 0L) {
            try {
                Object msg = this.channel.receive(wait_time);
                if (msg instanceof Message) {
                    System.out.print("+" + ++received + ' ');
                }
                if (received < num) continue;
                break;
            }
            catch (Throwable t) {
                SendAndReceiveTest.fail((String)"failed receiving message");
            }
        }
        return received;
    }

    public static void main(String[] args) {
        String[] testCaseName = new String[]{(class$org$jgroups$tests$SendAndReceiveTest == null ? (class$org$jgroups$tests$SendAndReceiveTest = SendAndReceiveTest.class$("org.jgroups.tests.SendAndReceiveTest")) : class$org$jgroups$tests$SendAndReceiveTest).getName()};
        TestRunner.main((String[])testCaseName);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

