/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.Event;
import org.jgroups.protocols.PingRsp;
import org.jgroups.protocols.PingSender;
import org.jgroups.stack.Protocol;

public class PingWaiter
implements Runnable {
    Thread t = null;
    final List rsps = new LinkedList();
    long timeout = 3000L;
    int num_rsps = 3;
    Protocol parent = null;
    PingSender ping_sender;
    protected final Log log = LogFactory.getLog(this.getClass());
    private boolean trace = this.log.isTraceEnabled();

    public PingWaiter(long timeout, int num_rsps, Protocol parent, PingSender ping_sender) {
        this.timeout = timeout;
        this.num_rsps = num_rsps;
        this.parent = parent;
        this.ping_sender = ping_sender;
    }

    void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    void setNumRsps(int num) {
        this.num_rsps = num;
    }

    public synchronized void start() {
        if (this.t == null || !this.t.isAlive()) {
            this.t = new Thread((Runnable)this, "PingWaiter");
            this.t.setDaemon(true);
            this.t.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop() {
        if (this.ping_sender != null) {
            this.ping_sender.stop();
        }
        if (this.t != null) {
            this.t = null;
            List list = this.rsps;
            synchronized (list) {
                this.rsps.notifyAll();
            }
        }
    }

    public synchronized boolean isRunning() {
        return this.t != null && this.t.isAlive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResponse(PingRsp rsp) {
        if (rsp != null) {
            List list = this.rsps;
            synchronized (list) {
                if (this.rsps.contains(rsp)) {
                    this.rsps.remove(rsp);
                }
                this.rsps.add(rsp);
                this.rsps.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearResponses() {
        List list = this.rsps;
        synchronized (list) {
            this.rsps.clear();
            this.rsps.notifyAll();
        }
    }

    public List getResponses() {
        return this.rsps;
    }

    public void run() {
        Vector responses = this.findInitialMembers();
        if (this.parent != null) {
            this.parent.passUp(new Event(13, responses));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector findInitialMembers() {
        List list = this.rsps;
        synchronized (list) {
            Vector vector;
            block14: {
                if (this.rsps.size() > 0) {
                    this.rsps.clear();
                }
                this.ping_sender.start();
                long start_time = System.currentTimeMillis();
                long time_to_wait = this.timeout;
                try {
                    while (this.rsps.size() < this.num_rsps && time_to_wait > 0L && this.t != null) {
                        if (this.trace) {
                            this.log.trace((Object)new StringBuffer("waiting for initial members: time_to_wait=").append(time_to_wait).append(", got ").append(this.rsps.size()).append(" rsps"));
                        }
                        try {
                            this.rsps.wait(time_to_wait);
                        }
                        catch (InterruptedException intex) {
                        }
                        catch (Exception e) {
                            this.log.error((Object)"got an exception waiting for responses", (Throwable)e);
                        }
                        time_to_wait = this.timeout - (System.currentTimeMillis() - start_time);
                    }
                    if (this.trace) {
                        this.log.trace((Object)new StringBuffer("initial mbrs are ").append(this.rsps));
                    }
                    vector = new Vector(this.rsps);
                    if (this.ping_sender == null) break block14;
                    this.ping_sender.stop();
                }
                catch (Throwable throwable) {
                    if (this.ping_sender != null) {
                        this.ping_sender.stop();
                    }
                    throw throwable;
                }
            }
            return vector;
        }
    }
}

