/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.stack;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.Event;
import org.jgroups.stack.Protocol;
import org.jgroups.stack.ProtocolObserver;
import org.jgroups.util.Queue;
import org.jgroups.util.QueueClosedException;
import org.jgroups.util.Util;

class UpHandler
extends Thread {
    private Queue mq = null;
    private Protocol handler = null;
    private ProtocolObserver observer = null;
    protected final Log log = LogFactory.getLog(this.getClass());

    public UpHandler(Queue mq, Protocol handler, ProtocolObserver observer) {
        super(Util.getGlobalThreadGroup(), "UpHandler");
        this.mq = mq;
        this.handler = handler;
        this.observer = observer;
        if (handler != null) {
            this.setName("UpHandler (" + handler.getName() + ')');
        } else {
            this.setName("UpHandler");
        }
        this.setDaemon(true);
    }

    public void setObserver(ProtocolObserver observer) {
        this.observer = observer;
    }

    public void run() {
        while (!this.mq.closed()) {
            try {
                Event evt = (Event)this.mq.remove();
                if (evt == null) {
                    if (!this.log.isWarnEnabled()) continue;
                    this.log.warn((Object)"removed null event");
                    continue;
                }
                if (this.observer != null && !this.observer.up(evt, this.mq.size())) {
                    return;
                }
                this.handler.up(evt);
            }
            catch (QueueClosedException queue_closed) {
                break;
            }
            catch (Throwable e) {
                if (!this.log.isErrorEnabled()) continue;
                this.log.error((Object)(this.getName() + " caught exception"), e);
            }
        }
    }
}

