package jin.collection.core;

import java.util.*;

/*
 * Created on 19-mar-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */

/**
 * Fornisce le operazioni di iterazione su una collection
 * 
 * Nonostante questa sia la classe principale del package non dovrebbe quasi mai
 * essere usata direttamente, per lo meno non con delle classi anonime. In
 * pratica bisognerebbe sempre nasconderla dietro a classi tipo Sum o GroupBy o
 * generare i criteria con classi tipo NumberCriteriaFactory o
 * PropertyCriteriaFactory
 * 
 * @author Administrator
 * 
 * TODO To change the template for this generated type comment go to Window -
 * Preferences - Java - Code Style - Code Templates
 */
public class Iter {

   /**
    * This one break convention that the returned Collection is of the same
    * concrete type of the one passed as a parameter cause it is not possible to
    * deduce the Collection type from its iterator
    * 
    * @param iter
    * @param op
    */
   public static void forEach(Iterator iter, final Operation op) {
      Collection result = new ArrayList();

      Iter.chain(iter, result, new ChainedOperation() {
         public Object execute(Object element, Object currValue) {
            op.execute(element);
            return null;
         }
      });
   }

   public static Collection collect(Iterator iter, final ReadAccessor accessor) {
      final Collection result = new ArrayList();
      Iter.forEach(iter, new Operation() {
         public void execute(Object element) {
            result.add(accessor.getValue(element));
         }
      });
      return result;
   }

   public static void forEach(Collection elements, final Operation op) {

      Collection result = CollectionFactory.newInstance(elements);
      forEach(elements, result, op);
   }

   public static void forEach(Collection elements, Collection result, final Operation op) {
      Iter.chain(elements, result, new ChainedOperation() {
         public Object execute(Object element, Object currValue) {
            op.execute(element);
            return null;
         }
      });
   }

   public static Collection extract(Collection elements, final Criteria includeCriteria) {

      final Collection result = CollectionFactory.newInstance(elements);

      return (Collection) Iter.chain(elements, result, new ChainedOperation() {
         public Object execute(Object element, Object currValue) {

            if (includeCriteria.match(element)) {
               List list = (List) currValue;
               list.add(element);
            }
            return currValue;
         }
      });
   }

   public static Collection filter(Collection elements, Criteria excludeCriteria) {
      return extract(elements, new NegateCriteria(excludeCriteria));
   }

   /**
    * Simile al forEach, ma durante tutta l'iterazione e' disponibile un
    * elemento (currValue) che viene passato da un'iterazione a quella
    * successiva.
    */
   public static Object chain(Collection elements, Object firstValue, ChainedOperation cOp) {

      return chain(elements.iterator(), firstValue, cOp);
   }

   public static Object chain(Iterator iterator, Object firstValue, ChainedOperation cOp) {
      Object currValue = firstValue;
      for (Iterator iter = iterator; iter.hasNext();) {
         Object element = iter.next();
         currValue = cOp.execute(element, currValue);
      }
      return currValue;
   }

   /**
    * Caso particolare di forEach in cui si vuole produrre una nuova lista
    * basata sugli elementi della lista passata (E' giusto il nome rispetto a
    * SmallTalk?)
    */
   public static Collection collect(Collection elements, final ReadAccessor accessor) {
      return collect(elements, accessor, true);
   }

   public static Collection collect(Collection elements, final ReadAccessor accessor, boolean guessListType) {
      final Collection result = initResultList(elements, guessListType);

      Iter.forEach(elements, result, new Operation() {
         public void execute(Object element) {
            result.add(accessor.getValue(element));
         }
      });
      return result;
   }

   private static Collection initResultList(Collection elements, boolean guessListType) {
      final Collection result;
      if (guessListType) {
         result = CollectionFactory.newInstance(elements);
      } else {
         result = new ArrayList();
      }
      return result;
   }

   /**
    * Used when from a collection it is needed to extract more element from a
    * single one of the original collection Ex: collectMany(artists, new
    * ArtistToPicturesAccessor()). Each artists has_many pictures.
    * 
    * @param guessListType
    */
   public static Collection collectMany(Collection elements, final HasManyReadAccessor accessor,
         boolean guessListType) {
      final Collection result = initResultList(elements, guessListType);

      Iter.forEach(elements, result, new Operation() {
         public void execute(Object element) {
            result.addAll(accessor.getValue(element));
         }
      });
      return result;
   }
}

/**
* Copyright 2007, Lorenzo Bolzani
* 
* The contents of this file are subject to the Mozilla Public
* License Version 1.1 (the "License"); you may not use this file
* except in compliance with the License. You may obtain a copy of
* the License at http://www.mozilla.org/MPL/MPL-1.1.html
**/
