package jin.collection.util;

import java.lang.reflect.Constructor;
import java.util.Collection;

import jin.collection.core.CollectionFactory;
import jin.collection.core.Iter;
import jin.collection.core.ReadAccessor;


public class Wrap {

	private final Class clazz;

	public Wrap(Class clazz) {
		this.clazz = clazz;
	}

	public Collection runOn(Collection list) {
		
		if (list.isEmpty())
			return CollectionFactory.newInstance(list);
		
		Class paramType = list.iterator().next().getClass();
		final Constructor c;
		try {
			c = clazz.getConstructor(new Class[]{paramType});
		} catch (Exception e) {
			throw new RuntimeException(e.toString());
		}
		
		return Iter.collect(list, new ReadAccessor() {
			public Object getValue(Object element) {
				try {
					return c.newInstance(new Object[]{element});
				} catch (Exception e) {
					throw new RuntimeException(e.toString());
				}
			}
		});
	}
}


/**
* Copyright 2007, Lorenzo Bolzani
* 
* The contents of this file are subject to the Mozilla Public
* License Version 1.1 (the "License"); you may not use this file
* except in compliance with the License. You may obtain a copy of
* the License at http://www.mozilla.org/MPL/MPL-1.1.html
**/
