/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.packet;

import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smack.util.StringUtils;

public abstract class Packet {
    public static final String ID_NOT_AVAILABLE = "ID_NOT_AVAILABLE";
    private static String prefix = StringUtils.randomString(5) + "-";
    private static long id = 0L;
    private String packetID = null;
    private String to = null;
    private String from = null;
    private List packetExtensions = null;
    private Map properties = null;
    private XMPPError error = null;

    private static synchronized String nextID() {
        return prefix + Long.toString(id++);
    }

    public String getPacketID() {
        if (ID_NOT_AVAILABLE.equals(this.packetID)) {
            return null;
        }
        if (this.packetID == null) {
            this.packetID = Packet.nextID();
        }
        return this.packetID;
    }

    public void setPacketID(String packetID) {
        this.packetID = packetID;
    }

    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public XMPPError getError() {
        return this.error;
    }

    public void setError(XMPPError error) {
        this.error = error;
    }

    public synchronized Iterator getExtensions() {
        if (this.packetExtensions == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return Collections.unmodifiableList(new ArrayList(this.packetExtensions)).iterator();
    }

    public synchronized PacketExtension getExtension(String elementName, String namespace) {
        if (this.packetExtensions == null || elementName == null || namespace == null) {
            return null;
        }
        Iterator i = this.packetExtensions.iterator();
        while (i.hasNext()) {
            PacketExtension ext = (PacketExtension)i.next();
            if (!elementName.equals(ext.getElementName()) || !namespace.equals(ext.getNamespace())) continue;
            return ext;
        }
        return null;
    }

    public synchronized void addExtension(PacketExtension extension) {
        if (this.packetExtensions == null) {
            this.packetExtensions = new ArrayList();
        }
        this.packetExtensions.add(extension);
    }

    public synchronized void removeExtension(PacketExtension extension) {
        if (this.packetExtensions != null) {
            this.packetExtensions.remove(extension);
        }
    }

    public synchronized Object getProperty(String name) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(name);
    }

    public void setProperty(String name, int value) {
        this.setProperty(name, new Integer(value));
    }

    public void setProperty(String name, long value) {
        this.setProperty(name, new Long(value));
    }

    public void setProperty(String name, float value) {
        this.setProperty(name, new Float(value));
    }

    public void setProperty(String name, double value) {
        this.setProperty(name, new Double(value));
    }

    public void setProperty(String name, boolean value) {
        this.setProperty(name, new Boolean(value));
    }

    public synchronized void setProperty(String name, Object value) {
        if (!(value instanceof Serializable)) {
            throw new IllegalArgumentException("Value must be serialiazble");
        }
        if (this.properties == null) {
            this.properties = new HashMap();
        }
        this.properties.put(name, value);
    }

    public synchronized void deleteProperty(String name) {
        if (this.properties == null) {
            return;
        }
        this.properties.remove(name);
    }

    public synchronized Iterator getPropertyNames() {
        if (this.properties == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return this.properties.keySet().iterator();
    }

    public abstract String toXML();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized String getExtensionsXML() {
        StringBuffer buf = new StringBuffer();
        Iterator extensions = this.getExtensions();
        while (extensions.hasNext()) {
            PacketExtension extension = (PacketExtension)extensions.next();
            buf.append(extension.toXML());
        }
        if (this.properties != null && !this.properties.isEmpty()) {
            buf.append("<properties xmlns=\"http://www.jivesoftware.com/xmlns/xmpp/properties\">");
            Iterator i = this.getPropertyNames();
            while (i.hasNext()) {
                String name = (String)i.next();
                Object value = this.getProperty(name);
                buf.append("<property>");
                buf.append("<name>").append(StringUtils.escapeForXML(name)).append("</name>");
                buf.append("<value type=\"");
                if (value instanceof Integer) {
                    buf.append("integer\">").append(value).append("</value>");
                } else if (value instanceof Long) {
                    buf.append("long\">").append(value).append("</value>");
                } else if (value instanceof Float) {
                    buf.append("float\">").append(value).append("</value>");
                } else if (value instanceof Double) {
                    buf.append("double\">").append(value).append("</value>");
                } else if (value instanceof Boolean) {
                    buf.append("boolean\">").append(value).append("</value>");
                } else if (value instanceof String) {
                    buf.append("string\">");
                    buf.append(StringUtils.escapeForXML((String)value));
                    buf.append("</value>");
                } else {
                    ByteArrayOutputStream byteStream = null;
                    ObjectOutputStream out = null;
                    try {
                        byteStream = new ByteArrayOutputStream();
                        out = new ObjectOutputStream(byteStream);
                        out.writeObject(value);
                        buf.append("java-object\">");
                        String encodedVal = StringUtils.encodeBase64(byteStream.toByteArray());
                        buf.append(encodedVal).append("</value>");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    finally {
                        if (out != null) {
                            try {
                                out.close();
                            }
                            catch (Exception e) {}
                        }
                        if (byteStream != null) {
                            try {
                                byteStream.close();
                            }
                            catch (Exception e) {}
                        }
                    }
                }
                buf.append("</property>");
            }
            buf.append("</properties>");
        }
        return buf.toString();
    }
}

