/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.comm;

import com.sun.jdmk.MBeanServerForwarder;
import com.sun.jdmk.Trace;
import com.sun.jdmk.comm.ClientHandler;
import com.sun.jdmk.comm.CommunicationException;
import com.sun.jdmk.comm.CommunicatorServerMBean;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Vector;
import javax.management.AttributeChangeNotification;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;

public abstract class CommunicatorServer
implements Runnable,
Serializable,
MBeanRegistration,
NotificationBroadcaster,
CommunicatorServerMBean {
    public static final int ONLINE = 0;
    public static final int OFFLINE = 1;
    public static final int STOPPING = 2;
    public static final int STARTING = 3;
    public static final int RMI_TYPE = 1;
    public static final int HTTP_TYPE = 2;
    public static final int HTML_TYPE = 3;
    public static final int SNMP_TYPE = 4;
    public static final int HTTPS_TYPE = 5;
    volatile transient int state = 1;
    ObjectName objectName;
    MBeanServer topMBS;
    MBeanServer bottomMBS;
    transient String dbgTag = null;
    int maxActiveClientCount = 1;
    transient int servedClientCount = 0;
    String host = null;
    int port = -1;
    private transient Object stateLock = new Object();
    private transient Vector clientHandlerVector = new Vector();
    private transient Thread fatherThread = Thread.currentThread();
    private transient Thread mainThread = null;
    private volatile boolean stopRequested = false;
    private boolean interrupted = false;
    private transient long notifCount = 0L;
    private transient NotificationBroadcasterSupport notifBroadcaster = new NotificationBroadcasterSupport();
    private transient MBeanNotificationInfo[] notifInfos = null;
    int infoType;
    static /* synthetic */ Class class$javax$management$AttributeChangeNotification;

    public CommunicatorServer(int n) throws IllegalArgumentException {
        switch (n) {
            case 1: {
                this.infoType = 256;
                break;
            }
            case 2: {
                this.infoType = 512;
                break;
            }
            case 3: {
                this.infoType = 16;
                break;
            }
            case 4: {
                this.infoType = 1024;
                break;
            }
            case 5: {
                this.infoType = 2048;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid connector Type");
            }
        }
        this.dbgTag = this.makeDebugTag();
    }

    public void addNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws IllegalArgumentException {
        if (this.isDebugOn()) {
            this.debug("addNotificationListener", "Adding listener " + notificationListener + " with filter " + notificationFilter + " and handback " + object);
        }
        this.notifBroadcaster.addNotificationListener(notificationListener, notificationFilter, object);
    }

    void changeState(int n) {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == n) {
                Object var4_3 = null;
                return;
            }
            int n2 = this.state;
            this.state = n;
            this.stateLock.notifyAll();
            this.sendStateChangeNotification(n2, n);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    void debug(String string, String string2) {
        this.debug(this.dbgTag, string, string2);
    }

    void debug(String string, String string2, String string3) {
        Trace.send(2, this.infoType, string, string2, string3);
    }

    void debug(String string, String string2, Throwable throwable) {
        Trace.send(2, this.infoType, string, string2, throwable);
    }

    void debug(String string, Throwable throwable) {
        this.debug(this.dbgTag, string, throwable);
    }

    protected abstract void doBind() throws CommunicationException, InterruptedException;

    protected abstract void doError(Exception var1) throws CommunicationException;

    protected abstract void doProcess() throws CommunicationException, InterruptedException;

    protected abstract void doReceive() throws CommunicationException, InterruptedException;

    protected abstract void doUnbind() throws CommunicationException, InterruptedException;

    int getActiveClientCount() {
        int n = this.clientHandlerVector.size();
        return n;
    }

    public String getHost() {
        try {
            this.host = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            this.host = "Unknown host";
        }
        return this.host;
    }

    public synchronized MBeanServer getMBeanServer() {
        return this.topMBS;
    }

    int getMaxActiveClientCount() {
        return this.maxActiveClientCount;
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        if (this.notifInfos == null) {
            this.notifInfos = new MBeanNotificationInfo[1];
            String[] stringArray = new String[]{AttributeChangeNotification.ATTRIBUTE_CHANGE};
            this.notifInfos[0] = new MBeanNotificationInfo(stringArray, (class$javax$management$AttributeChangeNotification != null ? class$javax$management$AttributeChangeNotification : (class$javax$management$AttributeChangeNotification = CommunicatorServer.class$("javax.management.AttributeChangeNotification"))).getName(), "Sent to notify that the value of the State attribute of this CommunicatorServer instance has changed.");
        }
        return this.notifInfos;
    }

    ObjectName getObjectName() {
        return this.objectName;
    }

    public int getPort() {
        return this.port;
    }

    public abstract String getProtocol();

    int getServedClientCount() {
        return this.servedClientCount;
    }

    public int getState() {
        return this.state;
    }

    public String getStateString() {
        return CommunicatorServer.getStringForState(this.state);
    }

    private static String getStringForState(int n) {
        switch (n) {
            case 0: {
                return "ONLINE";
            }
            case 3: {
                return "STARTING";
            }
            case 1: {
                return "OFFLINE";
            }
            case 2: {
                return "STOPPING";
            }
        }
        return "UNDEFINED";
    }

    public boolean isActive() {
        return this.state == 0;
    }

    boolean isDebugOn() {
        return Trace.isSelected(2, this.infoType);
    }

    boolean isTraceOn() {
        return Trace.isSelected(1, this.infoType);
    }

    String makeDebugTag() {
        return "CommunicatorServer[" + this.getProtocol() + ":" + this.getPort() + "]";
    }

    String makeThreadName() {
        String string = this.objectName == null ? "CommunicatorServer" : this.objectName.toString();
        return string;
    }

    void notifyClientHandlerCreated(ClientHandler clientHandler) {
        this.clientHandlerVector.addElement(clientHandler);
    }

    synchronized void notifyClientHandlerDeleted(ClientHandler clientHandler) {
        this.clientHandlerVector.removeElement(clientHandler);
        this.notifyAll();
    }

    public void postDeregister() {
    }

    public void postRegister(Boolean bl) {
        if (!bl.booleanValue()) {
            CommunicatorServer communicatorServer = this;
            synchronized (communicatorServer) {
                this.bottomMBS = null;
                this.topMBS = null;
            }
        }
    }

    public void preDeregister() throws Exception {
        CommunicatorServer communicatorServer = this;
        synchronized (communicatorServer) {
            this.bottomMBS = null;
            this.topMBS = null;
        }
        this.objectName = null;
        if (this.state == 0 || this.state == 3) {
            this.stop();
        }
    }

    public ObjectName preRegister(MBeanServer mBeanServer, ObjectName objectName) throws Exception {
        this.objectName = objectName;
        CommunicatorServer communicatorServer = this;
        synchronized (communicatorServer) {
            if (this.bottomMBS != null) {
                throw new IllegalArgumentException("connector already registered in an MBean server");
            }
            this.topMBS = this.bottomMBS = mBeanServer;
        }
        this.dbgTag = this.makeDebugTag();
        return objectName;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.stateLock = new Object();
        this.state = 1;
        this.stopRequested = false;
        this.servedClientCount = 0;
        this.clientHandlerVector = new Vector();
        this.fatherThread = Thread.currentThread();
        this.mainThread = null;
        this.notifCount = 0L;
        this.notifInfos = null;
        this.notifBroadcaster = new NotificationBroadcasterSupport();
        this.dbgTag = this.makeDebugTag();
    }

    public void removeNotificationListener(NotificationListener notificationListener) throws ListenerNotFoundException {
        if (this.isDebugOn()) {
            this.debug("removeNotificationListener", "Removing listener " + notificationListener);
        }
        this.notifBroadcaster.removeNotificationListener(notificationListener);
    }

    /*
     * Exception decompiling
     */
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [20[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void sendStateChangeNotification(int n, int n2) {
        String string = CommunicatorServer.getStringForState(n);
        String string2 = CommunicatorServer.getStringForState(n2);
        String string3 = this.dbgTag + " The value of attribute State has changed from " + n + " (" + string + ") to " + n2 + " (" + string2 + ").";
        ++this.notifCount;
        AttributeChangeNotification attributeChangeNotification = new AttributeChangeNotification(this, this.notifCount, System.currentTimeMillis(), string3, "State", "int", new Integer(n), new Integer(n2));
        if (this.isDebugOn()) {
            this.debug("sendStateChangeNotification", "Sending AttributeChangeNotification #" + this.notifCount + " with message: " + string3);
        }
        this.notifBroadcaster.sendNotification(attributeChangeNotification);
    }

    public synchronized void setMBeanServer(MBeanServer mBeanServer) throws IllegalArgumentException, IllegalStateException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == 0 || this.state == 3) {
                throw new IllegalStateException("Stop server before carrying out this operation");
            }
        }
        object = "MBeanServer argument must be MBean server where this server is registered, or an MBeanServerForwarder leading to that server";
        Vector<MBeanServer> vector = new Vector<MBeanServer>();
        MBeanServer mBeanServer2 = mBeanServer;
        while (mBeanServer2 != this.bottomMBS) {
            if (!(mBeanServer2 instanceof MBeanServerForwarder)) {
                throw new IllegalArgumentException("MBeanServer argument must be MBean server where this server is registered, or an MBeanServerForwarder leading to that server");
            }
            if (vector.contains(mBeanServer2)) {
                throw new IllegalArgumentException("MBeanServerForwarder loop");
            }
            vector.addElement(mBeanServer2);
            mBeanServer2 = ((MBeanServerForwarder)mBeanServer2).getMBeanServer();
        }
        this.topMBS = mBeanServer;
    }

    void setMaxActiveClientCount(int n) throws IllegalStateException {
        if (this.state == 0 || this.state == 3) {
            throw new IllegalStateException("Stop server before carrying out this operation");
        }
        this.maxActiveClientCount = n;
    }

    public void setPort(int n) throws IllegalStateException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == 0 || this.state == 3) {
                throw new IllegalStateException("Stop server before carrying out this operation");
            }
            this.port = n;
            this.dbgTag = this.makeDebugTag();
        }
    }

    public void start() {
        boolean bl;
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == 2) {
                this.waitState(1, 60000L);
            }
            boolean bl2 = bl = this.state == 1;
            if (bl) {
                this.changeState(3);
                this.stopRequested = false;
                this.interrupted = false;
            }
        }
        if (!bl) {
            if (this.isTraceOn()) {
                this.trace("start", "Connector is not OFFLINE");
            }
            return;
        }
        if (this.isTraceOn()) {
            this.trace("start", "--> Start connector ");
        }
        this.mainThread = new Thread((Runnable)this, this.makeThreadName());
        if (Thread.currentThread().getPriority() < 10) {
            this.mainThread.setPriority(Thread.currentThread().getPriority() + 1);
        }
        this.mainThread.start();
    }

    public void stop() {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == 1 || this.state == 2) {
                if (this.isTraceOn()) {
                    this.trace("stop", "Connector is not ONLINE");
                }
                Object var2_2 = null;
                return;
            }
            this.changeState(2);
            if (this.isTraceOn()) {
                this.trace("stop", "Interrupt main thread");
            }
            this.stopRequested = true;
            if (!this.interrupted) {
                this.interrupted = true;
                this.mainThread.interrupt();
            }
        }
        if (this.isTraceOn()) {
            this.trace("stop", "terminateAllClient");
        }
        this.terminateAllClient();
        if (this.state == 3) {
            this.changeState(1);
        }
    }

    private void terminateAllClient() {
        int n = this.clientHandlerVector.size();
        if (this.isTraceOn() && n >= 1) {
            this.trace("terminateAllClient", "Interrupting " + n + " clients");
        }
        Enumeration enumeration = this.clientHandlerVector.elements();
        while (enumeration.hasMoreElements()) {
            ClientHandler clientHandler = (ClientHandler)enumeration.nextElement();
            clientHandler.interrupt();
        }
    }

    void trace(String string, String string2) {
        this.trace(this.dbgTag, string, string2);
    }

    void trace(String string, String string2, String string3) {
        Trace.send(1, this.infoType, string, string2, string3);
    }

    private void waitClientTermination() {
        int n = this.clientHandlerVector.size();
        if (this.isTraceOn() && n >= 1) {
            this.trace("waitClientTermination", "waiting for " + n + " clients to terminate");
        }
        Enumeration enumeration = this.clientHandlerVector.elements();
        while (enumeration.hasMoreElements()) {
            ClientHandler clientHandler = (ClientHandler)enumeration.nextElement();
            clientHandler.join();
        }
        if (this.isTraceOn() && n >= 1) {
            this.trace("waitClientTermination", "Ok, let's go...");
        }
    }

    private synchronized void waitIfTooManyClients() throws InterruptedException {
        while (this.getActiveClientCount() >= this.maxActiveClientCount) {
            if (this.isTraceOn()) {
                this.trace("waitIfTooManyClients", "Waiting for a client to terminate");
            }
            this.wait();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public boolean waitState(int n, long l) {
        if (this.isTraceOn()) {
            this.trace("waitState", String.valueOf(n) + "(0on,1off,2st) TO=" + l + " ; current state = " + this.getStateString());
        }
        long l2 = 0L;
        if (l > 0L) {
            l2 = System.currentTimeMillis() + l;
        }
        Object object = this.stateLock;
        // MONITORENTER : object
        while (true) {
            if (this.state == n) {
                if (this.isTraceOn()) {
                    this.trace("waitState", "returning in desired state");
                }
                break;
            }
            if (l < 0L) {
                if (this.isTraceOn()) {
                    this.trace("waitState", "timeOut < 0, return without wait");
                }
                boolean bl = false;
                Object var8_10 = null;
                // MONITOREXIT : object
                return bl;
            }
            try {
                if (l > 0L) {
                    long l3 = l2 - System.currentTimeMillis();
                    if (l3 <= 0L) {
                        if (this.isTraceOn()) {
                            this.trace("waitState", "timed out");
                        }
                        boolean bl = false;
                        Object var8_11 = null;
                        // MONITOREXIT : object
                        return bl;
                    }
                    this.stateLock.wait(l3);
                    continue;
                }
                this.stateLock.wait();
            }
            catch (InterruptedException interruptedException) {
                if (this.isTraceOn()) {
                    this.trace("waitState", "wait interrupted");
                }
                boolean bl = this.state == n;
                Object var8_12 = null;
                // MONITOREXIT : object
                return bl;
            }
        }
        boolean bl = true;
        Object var8_13 = null;
        // MONITOREXIT : object
        return bl;
    }
}

