/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.comm;

import com.sun.jdmk.GenericProxy;
import com.sun.jdmk.OperationContext;
import com.sun.jdmk.Proxy;
import com.sun.jdmk.ProxyMBeanInstantiationException;
import com.sun.jdmk.Trace;
import com.sun.jdmk.comm.ClientNotificationDispatcher;
import com.sun.jdmk.comm.ClientNotificationHandlerInternal;
import com.sun.jdmk.comm.CommunicationException;
import com.sun.jdmk.comm.ConnectorAddress;
import com.sun.jdmk.comm.DefaultMapper;
import com.sun.jdmk.comm.HeartBeatClientHandler;
import com.sun.jdmk.comm.HeartBeatClientHandlerImpl;
import com.sun.jdmk.comm.HeartBeatInternalClientHandler;
import com.sun.jdmk.comm.Mapper;
import com.sun.jdmk.comm.RemoteMBeanServer;
import com.sun.jdmk.comm.RemoteRuntimeException;
import com.sun.jdmk.comm.RmiConnectorAddress;
import com.sun.jdmk.comm.RmiConnectorServer;
import com.sun.jdmk.comm.RmiConnectorServerObject;
import com.sun.jdmk.comm.RmiConnectorServerObjectV2;
import com.sun.jdmk.comm.RmiNotificationReceiverImpl;
import java.lang.reflect.Constructor;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.ServerRuntimeException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.JMRuntimeException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;

public class RmiConnectorClient
implements RemoteMBeanServer,
HeartBeatClientHandler {
    private int infoType = 256;
    private String localClassName;
    private String dbgTag = this.localClassName = "com.sun.jdmk.comm.RmiConnectorClient";
    private OperationContext operationContext = null;
    private transient boolean isConnected = false;
    private transient RmiConnectorAddress connectorAddress = null;
    private transient RmiConnectorServerObject connectorServerV1 = null;
    private transient RmiConnectorServerObjectV2 connectorServerV2 = null;
    private transient String MBeanServerId = null;
    private transient ClassLoader classLoader = null;
    private transient Mapper mapper = null;
    private transient Mapper defaultMapper = null;
    private ClientNotificationDispatcher notificationClientHandler = null;
    private RmiNotificationReceiverImpl rmiNotificationReceiver = null;
    private HeartBeatClientHandlerImpl heartbeatClientHandler = null;
    private transient Hashtable proxyHandles = new Hashtable();
    private transient Hashtable genericHandles = new Hashtable();
    static /* synthetic */ Class class$com$sun$jdmk$comm$RmiConnectorAddress;

    public RmiConnectorClient() {
        this.mapper = this.defaultMapper = new DefaultMapper();
        this.notificationClientHandler = new ClientNotificationDispatcher(new NotificationHandlerInternal(this));
        this.heartbeatClientHandler = new HeartBeatClientHandlerImpl(new HeartBeatInternalClientHandlerImpl(this), this.notificationClientHandler);
    }

    public void addHeartBeatNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) {
        if (this.isTraceOn()) {
            this.trace("addHeartBeatNotificationListener", "addHeartBeatNotificationListener");
        }
        this.heartbeatClientHandler.addHeartBeatNotificationListener(notificationListener, notificationFilter, object);
    }

    public void addNotificationListener(ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws InstanceNotFoundException {
        this.stopIfNotConnected("addNotificationListener()");
        this.notificationClientHandler.addNotificationListener(objectName, notificationListener, notificationFilter, object);
    }

    public void addProxy(Proxy proxy) {
        if (proxy == null) {
            throw new IllegalArgumentException("Cannot add null proxy reference");
        }
        ObjectName objectName = proxy.getMBeanObjectInstance().getObjectName();
        if (proxy instanceof GenericProxy) {
            this.genericHandles.put(objectName, proxy);
        } else {
            this.proxyHandles.put(objectName, proxy);
        }
        proxy.setRemoteMBeanServer(this);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void clearCache() {
        this.stopIfNotConnected("clearCache()");
        this.notificationClientHandler.clearCache();
    }

    public String connect(ConnectorAddress connectorAddress) {
        Object object;
        Registry registry;
        if (!(connectorAddress instanceof RmiConnectorAddress)) {
            String string = "Invalid ConnectorAddress class: Expected '" + (class$com$sun$jdmk$comm$RmiConnectorAddress != null ? class$com$sun$jdmk$comm$RmiConnectorAddress : (class$com$sun$jdmk$comm$RmiConnectorAddress = RmiConnectorClient.class$("com.sun.jdmk.comm.RmiConnectorAddress"))) + "', got'" + connectorAddress.getClass().getName() + "'";
            if (this.isTraceOn()) {
                this.trace("connect", string);
            }
            throw new IllegalArgumentException(string);
        }
        if (this.isConnected) {
            String string = "ConnectorClient already connected to RemoteMBeanServer";
            if (this.isTraceOn()) {
                this.trace("connect", "ConnectorClient already connected to RemoteMBeanServer");
            }
            throw new CommunicationException("ConnectorClient already connected to RemoteMBeanServer");
        }
        this.connectorAddress = (RmiConnectorAddress)connectorAddress;
        String string = this.connectorAddress.getHost();
        int n = this.connectorAddress.getPort();
        String string2 = this.connectorAddress.getName();
        Object var6_7 = null;
        try {
            registry = LocateRegistry.getRegistry(string, n);
        }
        catch (Exception exception) {
            String string3 = "Can't contact RMI registry at " + string + ":" + n;
            if (this.isTraceOn()) {
                this.trace("connect", string3);
            }
            throw new CommunicationException(exception, string3);
        }
        try {
            try {
                object = RmiConnectorServer.serviceNameForVersion(string2, 2);
                this.connectorServerV2 = (RmiConnectorServerObjectV2)registry.lookup((String)object);
            }
            catch (NotBoundException notBoundException) {
                object = RmiConnectorServer.serviceNameForVersion(string2, 1);
                this.connectorServerV1 = (RmiConnectorServerObject)registry.lookup((String)object);
            }
        }
        catch (Exception exception) {
            String string4 = "Can't contact RMI Connector Server with name " + string2;
            if (this.isTraceOn()) {
                this.trace("connect", string4);
            }
            throw new CommunicationException(exception, string4);
        }
        String string5 = null;
        try {
            object = new ObjectName("JMImplementation:type=MBeanServerDelegate");
            string5 = this.connectorServerV2 != null ? (String)this.connectorServerV2.getAttribute((ObjectName)object, "MBeanServerId", this.operationContext) : (String)this.connectorServerV1.getAttribute((ObjectName)object, "MBeanServerId");
        }
        catch (CommunicationException communicationException) {
            String string6 = "Can't contact RMI Connector Server to get MBeanServerId";
            if (this.isTraceOn()) {
                this.trace("connect", "Can't contact RMI Connector Server to get MBeanServerId");
            }
            throw communicationException;
        }
        catch (Exception exception) {
            String string7 = "Can't contact RMI Connector Server to get MBeanServerId";
            if (this.isTraceOn()) {
                this.trace("connect", "Can't contact RMI Connector Server to get MBeanServerId");
            }
            throw new CommunicationException(exception, "Can't contact RMI Connector Server to get MBeanServerId");
        }
        if (this.MBeanServerId != null && !this.MBeanServerId.equals(string5)) {
            String string8 = "Invalid MBeanServerId";
            if (this.isTraceOn()) {
                this.trace("connect", "Invalid MBeanServerId");
            }
            throw new IllegalArgumentException("Invalid MBeanServerId");
        }
        this.MBeanServerId = string5;
        this.heartbeatClientHandler.notifyConnectionEstablished();
        this.heartbeatClientHandler.startPinging();
        this.isConnected = true;
        this.dbgTag = this.makeDebugTag();
        if (this.isTraceOn()) {
            this.trace("connect", "Connection Ok");
        }
        return this.MBeanServerId;
    }

    public ObjectInstance createMBean(String string, ObjectName objectName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        ObjectInstance objectInstance;
        this.stopIfNotConnected("createMBean(className,name)");
        if (this.isTraceOn()) {
            this.trace("createMBean(className,name)", "MBean class name = " + string + " ; MBean name = " + objectName);
        }
        try {
            objectInstance = this.connectorServerV2 != null ? this.connectorServerV2.createMBean(string, objectName, this.operationContext) : this.connectorServerV1.createMBean(string, objectName);
        }
        catch (ServerRuntimeException serverRuntimeException) {
            throw (JMRuntimeException)serverRuntimeException.detail;
        }
        catch (RemoteException remoteException) {
            throw new CommunicationException(remoteException);
        }
        return objectInstance;
    }

    public ObjectInstance createMBean(String string, ObjectName objectName, ObjectName objectName2) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        ObjectInstance objectInstance;
        this.stopIfNotConnected("createMBean(className,name,loaderName)");
        if (this.isTraceOn()) {
            this.trace("createMBean(className,name,loaderName)", "MBean class name = " + string + " ; MBean name = " + objectName);
        }
        try {
            objectInstance = this.connectorServerV2 != null ? this.connectorServerV2.createMBean(string, objectName, objectName2, this.operationContext) : this.connectorServerV1.createMBean(string, objectName, objectName2);
        }
        catch (ServerRuntimeException serverRuntimeException) {
            throw (JMRuntimeException)serverRuntimeException.detail;
        }
        catch (RemoteException remoteException) {
            throw new CommunicationException(remoteException);
        }
        return objectInstance;
    }

    public ObjectInstance createMBean(String string, ObjectName objectName, ObjectName objectName2, Object[] objectArray, String[] stringArray) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        ObjectInstance objectInstance;
        this.stopIfNotConnected("createMBean(className,name,loaderName,params,signature)");
        if (this.isTraceOn()) {
            this.trace("createMBean(className,name,loaderName,params,signature)", "MBean class name = " + string + " ; MBean name = " + objectName);
        }
        try {
            objectInstance = this.connectorServerV2 != null ? this.connectorServerV2.createMBean(string, objectName, objectName2, objectArray, stringArray, this.operationContext) : this.connectorServerV1.createMBean(string, objectName, objectName2, objectArray, stringArray);
        }
        catch (ServerRuntimeException serverRuntimeException) {
            throw (JMRuntimeException)serverRuntimeException.detail;
        }
        catch (RemoteException remoteException) {
            throw new CommunicationException(remoteException);
        }
        return objectInstance;
    }

    public ObjectInstance createMBean(String string, ObjectName objectName, Object[] objectArray, String[] stringArray) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        ObjectInstance objectInstance;
        this.stopIfNotConnected("createMBean(className,name,params,signature)");
        if (this.isTraceOn()) {
            this.trace("createMBean(className,name,params,signature)", "MBean class name = " + string + " ; MBean name = " + objectName);
        }
        try {
            objectInstance = this.connectorServerV2 != null ? this.connectorServerV2.createMBean(string, objectName, objectArray, stringArray, this.operationContext) : this.connectorServerV1.createMBean(string, objectName, objectArray, stringArray);
        }
        catch (ServerRuntimeException serverRuntimeException) {
            throw (JMRuntimeException)serverRuntimeException.detail;
        }
        catch (RemoteException remoteException) {
            throw new CommunicationException(remoteException);
        }
        return objectInstance;
    }

    private void debug(String string, String string2) {
        this.debug(this.localClassName, string, string2);
    }

    private void debug(String string, String string2, String string3) {
        Trace.send(2, this.infoType, string, string2, string3);
    }

    public void disconnect() {
        if (this.isConnected) {
            this.notificationClientHandler.stopListening();
            this.heartbeatClientHandler.stopPinging(-1);
            this.heartbeatClientHandler.notifyConnectionTerminated();
            this.connectorServerV1 = null;
            this.connectorServerV2 = null;
            this.connectorAddress = null;
            this.dbgTag = this.localClassName;
            if (this.isTraceOn()) {
                this.trace("connect", "Disconnection Ok");
            }
            this.isConnected = false;
        }
    }

    public Object getAttribute(ObjectName objectName, String string) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException {
        this.stopIfNotConnected("getAttribute(name,attribute)");
        if (this.isTraceOn()) {
            this.trace("getAttribute(name,attribute)", "MBean object name = " + objectName + " ; attribute name = " + string);
        }
        try {
            if (this.connectorServerV2 != null) {
                return this.connectorServerV2.getAttribute(objectName, string, this.operationContext);
            }
            return this.connectorServerV1.getAttribute(objectName, string);
        }
        catch (ServerRuntimeException serverRuntimeException) {
            throw (JMRuntimeException)serverRuntimeException.detail;
        }
        catch (RemoteException remoteException) {
            throw new CommunicationException(remoteException);
        }
    }

    public AttributeList getAttributes(ObjectName objectName, String[] stringArray) throws InstanceNotFoundException, ReflectionException {
        this.stopIfNotConnected("getAttributes(name,attributes)");
        if (this.isTraceOn()) {
            this.trace("getAttribute(name,attributes)", "MBean object name = " + objectName);
        }
        try {
            if (this.connectorServerV2 != null) {
                return this.connectorServerV2.getAttributes(objectName, stringArray, this.operationContext);
            }
            return this.connectorServerV1.getAttributes(objectName, stringArray);
        }
        catch (ServerRuntimeException serverRuntimeException) {
            throw (JMRuntimeException)serverRuntimeException.detail;
        }
        catch (RemoteException remoteException) {
            throw new CommunicationException(remoteException);
        }
    }

    public int getCacheSize() {
        this.stopIfNotConnected("getCacheSize()");
        return this.notificationClientHandler.getCacheSize();
    }

    public String getClassForProxyMBean(ObjectInstance objectInstance) throws ProxyMBeanInstantiationException {
        if (objectInstance == null) {
            throw new IllegalArgumentException("ObjectInstance cannot be null");
        }
        return this.mapper.getClassForProxyMBean(objectInstance);
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public String getDefaultDomain() {
        this.stopIfNotConnected("getDefaultDomain()");
        if (this.isTraceOn()) {
            this.trace("getDefaultDomain()", "");
        }
        try {
            if (this.connectorServerV2 != null) {
                return this.connectorServerV2.getDefaultDomain(this.operationContext);
            }
            return this.connectorServerV1.getDefaultDomain();
        }
        catch (ServerRuntimeException serverRuntimeException) {
            throw (JMRuntimeException)serverRuntimeException.detail;
        }
        catch (RemoteException remoteException) {
            throw new CommunicationException(remoteException);
        }
    }

    public Set getGenericProxies(Set set) {
        if (set == null) {
            throw new IllegalArgumentException("Set of ObjectInstance cannot be null");
        }
        if (this.isTraceOn()) {
            this.trace("getGenericProxies(instances)", "");
        }
        HashSet<GenericProxy> hashSet = new HashSet<GenericProxy>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            ObjectInstance objectInstance = (ObjectInstance)iterator.next();
            hashSet.add(this.getGenericProxy(objectInstance));
        }
        return hashSet;
    }

    public GenericProxy getGenericProxy(ObjectInstance objectInstance) {
        GenericProxy genericProxy;
        if (objectInstance == null) {
            throw new IllegalArgumentException("ObjectInstance cannot be null");
        }
        String string = objectInstance.getClassName();
        ObjectName objectName = objectInstance.getObjectName();
        if (this.isTraceOn()) {
            this.trace("getGenericProxy(instance)", "class = " + string + " ; name = " + objectName);
        }
        if ((genericProxy = (GenericProxy)this.genericHandles.get(objectName)) != null) {
            if (this.isTraceOn()) {
                this.trace("getGenericProxy(instance)", "Object already in cache");
            }
            return genericProxy;
        }
        genericProxy = new GenericProxy(objectInstance);
        genericProxy.bind(this);
        return genericProxy;
    }

    public int getHeartBeatPeriod() {
        if (this.isTraceOn()) {
            this.trace("getHeartBeatPeriod", "getHeartBeatPeriod");
        }
        return this.heartbeatClientHandler.getHeartBeatPeriod();
    }

    public int getHeartBeatRetries() {
        if (this.isTraceOn()) {
            this.trace("getHeartBeatRetries", "getHeartBeatRetries");
        }
        return this.heartbeatClientHandler.getHeartBeatRetries();
    }

    public Integer getMBeanCount() {
        this.stopIfNotConnected("getMBeanCount()");
        if (this.isTraceOn()) {
            this.trace("getMBeanCount()", "");
        }
        try {
            if (this.connectorServerV2 != null) {
                return this.connectorServerV2.getMBeanCount(this.operationContext);
            }
            return this.connectorServerV1.getMBeanCount();
        }
        catch (ServerRuntimeException serverRuntimeException) {
            throw (JMRuntimeException)serverRuntimeException.detail;
        }
        catch (RemoteException remoteException) {
            throw new CommunicationException(remoteException);
        }
    }

    public MBeanInfo getMBeanInfo(ObjectName objectName) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        this.stopIfNotConnected("getMBeanInfo(name)");
        if (this.isTraceOn()) {
            this.trace("getMBeanInfo(name)", "");
        }
        try {
            if (this.connectorServerV2 != null) {
                return this.connectorServerV2.getMBeanInfo(objectName, this.operationContext);
            }
            return this.connectorServerV1.getMBeanInfo(objectName);
        }
        catch (ServerRuntimeException serverRuntimeException) {
            throw (JMRuntimeException)serverRuntimeException.detail;
        }
        catch (RemoteException remoteException) {
            throw new CommunicationException(remoteException);
        }
    }

    public ConnectorAddress getMBeanServerAddress() {
        return this.connectorAddress;
    }

    public String getMBeanServerId() {
        return this.MBeanServerId;
    }

    public Mapper getMapper() {
        if (this.mapper == this.defaultMapper) {
            return null;
        }
        return this.mapper;
    }

    public int getMode() {
        this.stopIfNotConnected("getMode()");
        return this.notificationClientHandler.getMode();
    }

    public void getNotifications() {
        this.stopIfNotConnected("getNotifications()");
        this.notificationClientHandler.getNotifications();
    }

    public ObjectInstance getObjectInstance(ObjectName objectName) throws InstanceNotFoundException {
        this.stopIfNotConnected("getObjectInstance(name)");
        if (this.isTraceOn()) {
            this.trace("getObjectInstance(name)", "MBean object name = " + objectName);
        }
        try {
            if (this.connectorServerV2 != null) {
                return this.connectorServerV2.getObjectInstance(objectName, this.operationContext);
            }
            return this.connectorServerV1.getObjectInstance(objectName);
        }
        catch (ServerRuntimeException serverRuntimeException) {
            throw (JMRuntimeException)serverRuntimeException.detail;
        }
        catch (RemoteException remoteException) {
            throw new CommunicationException(remoteException);
        }
    }

    public OperationContext getOperationContext() {
        return this.operationContext;
    }

    public int getOverflowCount() {
        this.stopIfNotConnected("getOverflowCount()");
        return this.notificationClientHandler.getOverflowCount();
    }

    public int getOverflowMode() {
        this.stopIfNotConnected("getOverflowMode()");
        return this.notificationClientHandler.getOverflowMode();
    }

    public int getPeriod() {
        this.stopIfNotConnected("getPeriod()");
        return this.notificationClientHandler.getPeriod();
    }

    public Proxy getProxyMBean(ObjectInstance objectInstance) throws ProxyMBeanInstantiationException {
        Proxy proxy;
        if (objectInstance == null) {
            throw new IllegalArgumentException("ObjectInstance cannot be null");
        }
        String string = objectInstance.getClassName();
        ObjectName objectName = objectInstance.getObjectName();
        if (this.isTraceOn()) {
            this.trace("getProxyMBean(instance)", "class = " + string + " ; name = " + objectName);
        }
        if ((proxy = (Proxy)this.proxyHandles.get(objectName)) != null) {
            if (this.isTraceOn()) {
                this.trace("getProxyMBean(instance)", "Object already in cache");
            }
            return proxy;
        }
        String string2 = this.getClassForProxyMBean(objectInstance);
        if (this.isDebugOn()) {
            this.debug("getProxyMBean(instance)", "Try to instanciate " + string2);
        }
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (this.classLoader == null) {
                throw new ProxyMBeanInstantiationException(classNotFoundException);
            }
            try {
                clazz = this.classLoader.loadClass(string2);
            }
            catch (ClassNotFoundException classNotFoundException2) {
                throw new ProxyMBeanInstantiationException(classNotFoundException2);
            }
        }
        try {
            Class[] classArray = new Class[]{Class.forName("javax.management.ObjectInstance")};
            Constructor<?> constructor = clazz.getConstructor(classArray);
            Object[] objectArray = new Object[]{objectInstance};
            proxy = (Proxy)constructor.newInstance(objectArray);
        }
        catch (Exception exception) {
            throw new ProxyMBeanInstantiationException(exception);
        }
        proxy.bind(this);
        return proxy;
    }

    public Set getProxyMBeans(Set set) throws ProxyMBeanInstantiationException {
        if (set == null) {
            throw new IllegalArgumentException("Set of ObjectInstance cannot be null");
        }
        if (this.isTraceOn()) {
            this.trace("getProxyMBeans(instances)", "");
        }
        HashSet<Proxy> hashSet = new HashSet<Proxy>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            ObjectInstance objectInstance = (ObjectInstance)iterator.next();
            hashSet.add(this.getProxyMBean(objectInstance));
        }
        return hashSet;
    }

    public Object invoke(ObjectName objectName, String string, Object[] objectArray, String[] stringArray) throws InstanceNotFoundException, MBeanException, ReflectionException {
        this.stopIfNotConnected("invoke(name,methodName,arguments,signature)");
        if (this.isTraceOn()) {
            this.trace("invoke(name,methodName,arguments,signature)", "");
        }
        try {
            if (this.connectorServerV2 != null) {
                return this.connectorServerV2.invoke(objectName, string, objectArray, stringArray, this.operationContext);
            }
            return this.connectorServerV1.invoke(objectName, string, objectArray, stringArray);
        }
        catch (ServerRuntimeException serverRuntimeException) {
            throw (JMRuntimeException)serverRuntimeException.detail;
        }
        catch (RemoteException remoteException) {
            throw new CommunicationException(remoteException);
        }
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    private boolean isDebugOn() {
        return Trace.isSelected(2, this.infoType);
    }

    public boolean isInstanceOf(ObjectName objectName, String string) throws InstanceNotFoundException {
        this.stopIfNotConnected("isInstanceOf(name)");
        if (this.isTraceOn()) {
            this.trace("isInstanceOf(name)", "MBean object name = " + objectName + " class name = " + string);
        }
        try {
            if (this.connectorServerV2 != null) {
                return this.connectorServerV2.isInstanceOf(objectName, string, this.operationContext);
            }
            String string2 = "isInstanceOf unsupported with this server";
            throw new IllegalArgumentException("isInstanceOf unsupported with this server");
        }
        catch (ServerRuntimeException serverRuntimeException) {
            throw (JMRuntimeException)serverRuntimeException.detail;
        }
        catch (RemoteException remoteException) {
            throw new CommunicationException(remoteException);
        }
    }

    public boolean isRegistered(ObjectName objectName) {
        this.stopIfNotConnected("isRegistered(name)");
        if (this.isTraceOn()) {
            this.trace("isRegistered(name)", "Call remote MBean server");
        }
        try {
            if (this.connectorServerV2 != null) {
                return this.connectorServerV2.isRegistered(objectName, this.operationContext);
            }
            return this.connectorServerV1.isRegistered(objectName);
        }
        catch (ServerRuntimeException serverRuntimeException) {
            throw (JMRuntimeException)serverRuntimeException.detail;
        }
        catch (RemoteException remoteException) {
            throw new CommunicationException(remoteException);
        }
    }

    private boolean isTraceOn() {
        return Trace.isSelected(1, this.infoType);
    }

    private String makeDebugTag() {
        if (this.connectorAddress != null) {
            return String.valueOf(this.localClassName) + "[" + this.connectorAddress.getPort() + ":" + this.connectorAddress.getName() + "]";
        }
        return this.localClassName;
    }

    String pingHeartBeatServer(String string, int n, int n2, Long l) {
        if (this.isTraceOn()) {
            this.debug("pingHeartBeatServer", "pingHeartBeatServer");
        }
        try {
            if (this.connectorServerV2 != null) {
                return this.connectorServerV2.pingHeartBeatServer(string, n, n2, l, this.operationContext);
            }
            return this.connectorServerV1.pingHeartBeatServer(string, n, n2, l);
        }
        catch (ServerRuntimeException serverRuntimeException) {
            throw (JMRuntimeException)serverRuntimeException.detail;
        }
        catch (RemoteException remoteException) {
            throw new CommunicationException(remoteException);
        }
    }

    public Set queryMBeans(ObjectName objectName, QueryExp queryExp) {
        this.stopIfNotConnected("queryMBeans(name,query)");
        if (this.isTraceOn()) {
            this.trace("queryMBeans(name,query)", "MBean name = " + objectName);
        }
        try {
            if (this.connectorServerV2 != null) {
                return this.connectorServerV2.queryMBeans(objectName, queryExp, this.operationContext);
            }
            return this.connectorServerV1.queryMBeans(objectName, queryExp);
        }
        catch (ServerRuntimeException serverRuntimeException) {
            throw (JMRuntimeException)serverRuntimeException.detail;
        }
        catch (RemoteException remoteException) {
            throw new CommunicationException(remoteException);
        }
    }

    public Set queryNames(ObjectName objectName, QueryExp queryExp) {
        this.stopIfNotConnected("queryNames(name,query)");
        if (this.isTraceOn()) {
            this.trace("queryNames(name,query)", "Call remote MBean server");
        }
        try {
            if (this.connectorServerV2 != null) {
                return this.connectorServerV2.queryNames(objectName, queryExp, this.operationContext);
            }
            return this.connectorServerV1.queryNames(objectName, queryExp);
        }
        catch (ServerRuntimeException serverRuntimeException) {
            throw (JMRuntimeException)serverRuntimeException.detail;
        }
        catch (RemoteException remoteException) {
            throw new CommunicationException(remoteException);
        }
    }

    Object[] remoteRequest(int n, Object[] objectArray) throws Exception {
        this.stopIfNotConnected("createMBean(className,name)");
        if (this.isTraceOn()) {
            this.debug("remoteRequest(opType,params)", "");
        }
        try {
            if (this.connectorServerV2 != null) {
                return this.connectorServerV2.remoteRequest(n, objectArray, this.operationContext);
            }
            return this.connectorServerV1.remoteRequest(n, objectArray);
        }
        catch (ServerRuntimeException serverRuntimeException) {
            serverRuntimeException.detail.fillInStackTrace();
            if (serverRuntimeException.detail instanceof RuntimeOperationsException) {
                throw (RuntimeOperationsException)serverRuntimeException.detail;
            }
            if (serverRuntimeException.detail instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)serverRuntimeException.detail;
            }
            if (serverRuntimeException.detail instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)serverRuntimeException.detail;
            }
            throw serverRuntimeException;
        }
        catch (RemoteException remoteException) {
            throw new CommunicationException(remoteException);
        }
    }

    public void removeHeartBeatNotificationListener(NotificationListener notificationListener) {
        if (this.isTraceOn()) {
            this.trace("removeHeartBeatNotificationListener", "removeHeartBeatNotificationListener");
        }
        this.heartbeatClientHandler.removeHeartBeatNotificationListener(notificationListener);
    }

    public void removeNotificationListener(ObjectName objectName, NotificationListener notificationListener) throws InstanceNotFoundException, ListenerNotFoundException {
        this.stopIfNotConnected("removeNotificationListener()");
        this.notificationClientHandler.removeNotificationListener(objectName, notificationListener);
    }

    public void removeProxy(Proxy proxy) {
        if (proxy == null) {
            throw new IllegalArgumentException("Cannot remove null proxy reference");
        }
        ObjectName objectName = proxy.getMBeanObjectInstance().getObjectName();
        if (proxy instanceof GenericProxy) {
            this.genericHandles.remove(objectName);
        } else {
            this.proxyHandles.remove(objectName);
        }
    }

    public void setAttribute(ObjectName objectName, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        this.stopIfNotConnected("setAttribute(name,attribute)");
        if (this.isTraceOn() && attribute != null) {
            this.trace("setAttribute(name,attribute)", "MBean object name = " + objectName + " ; attribute name = " + attribute.getName());
        }
        try {
            if (this.connectorServerV2 != null) {
                this.connectorServerV2.setAttribute(objectName, attribute, this.operationContext);
            } else {
                this.connectorServerV1.setAttribute(objectName, attribute);
            }
        }
        catch (ServerRuntimeException serverRuntimeException) {
            throw (JMRuntimeException)serverRuntimeException.detail;
        }
        catch (RemoteException remoteException) {
            throw new CommunicationException(remoteException);
        }
    }

    public AttributeList setAttributes(ObjectName objectName, AttributeList attributeList) throws InstanceNotFoundException, ReflectionException {
        this.stopIfNotConnected("setAttributes(name,attributes)");
        if (this.isTraceOn()) {
            this.trace("setAttribute(name,attributes)", "MBean object name = " + objectName);
        }
        try {
            if (this.connectorServerV2 != null) {
                return this.connectorServerV2.setAttributes(objectName, attributeList, this.operationContext);
            }
            return this.connectorServerV1.setAttributes(objectName, attributeList);
        }
        catch (ServerRuntimeException serverRuntimeException) {
            throw (JMRuntimeException)serverRuntimeException.detail;
        }
        catch (RemoteException remoteException) {
            throw new CommunicationException(remoteException);
        }
    }

    public int setCacheSize(int n, boolean bl) {
        this.stopIfNotConnected("setCacheSize()");
        return this.notificationClientHandler.setCacheSize(n, bl);
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setHeartBeatPeriod(int n) {
        if (this.isTraceOn()) {
            this.trace("setHeartBeatPeriod", "setHeartBeatPeriod");
        }
        this.heartbeatClientHandler.setHeartBeatPeriod(n);
    }

    public void setHeartBeatRetries(int n) {
        if (this.isTraceOn()) {
            this.trace("setHeartBeatRetries", "setHeartBeatRetries");
        }
        this.heartbeatClientHandler.setHeartBeatRetries(n);
    }

    public void setMapper(Mapper mapper) {
        if (mapper != null) {
            this.mapper = mapper;
        } else {
            mapper = this.defaultMapper;
        }
    }

    public void setMode(int n) throws IllegalArgumentException {
        this.stopIfNotConnected("setMode()");
        this.notificationClientHandler.setMode(n);
    }

    public void setOperationContext(OperationContext operationContext) {
        try {
            this.operationContext = (OperationContext)operationContext.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new CommunicationException(cloneNotSupportedException);
        }
    }

    public void setOverflowCount(int n) {
        this.stopIfNotConnected("setOverflowCount()");
        this.notificationClientHandler.setOverflowCount(n);
    }

    public void setOverflowMode(int n) throws IllegalArgumentException {
        this.stopIfNotConnected("setOverflowMode()");
        this.notificationClientHandler.setOverflowMode(n);
    }

    public void setPeriod(int n) {
        this.stopIfNotConnected("setPeriod()");
        this.notificationClientHandler.setPeriod(n);
    }

    ConnectorAddress startPush() {
        this.stopIfNotConnected("startPush()");
        if (this.rmiNotificationReceiver == null) {
            try {
                if (this.isDebugOn()) {
                    this.debug("startPush", "Create new RmiNotificationReceiverImpl");
                }
                this.rmiNotificationReceiver = new RmiNotificationReceiverImpl(this, this.connectorAddress, this.notificationClientHandler);
            }
            catch (ServerRuntimeException serverRuntimeException) {
                throw (JMRuntimeException)serverRuntimeException.detail;
            }
            catch (RemoteException remoteException) {
                throw new CommunicationException(remoteException);
            }
        }
        if (this.isDebugOn()) {
            this.debug("startPush", "start listening");
        }
        this.rmiNotificationReceiver.startListening();
        return this.rmiNotificationReceiver.getAddress();
    }

    private void stopIfNotConnected(String string) throws CommunicationException {
        if (!this.isConnected) {
            if (this.isTraceOn()) {
                this.trace("methodName", " Not connected");
            }
            throw new CommunicationException("ConnectorClient not connected to RMI Connector Server");
        }
    }

    void stopPush() {
        this.stopIfNotConnected("stopPush()");
        if (this.rmiNotificationReceiver != null) {
            this.rmiNotificationReceiver.stopListening();
        }
    }

    private void trace(String string, String string2) {
        this.trace(this.localClassName, string, string2);
    }

    private void trace(String string, String string2, String string3) {
        Trace.send(1, this.infoType, string, string2, string3);
    }

    public void unregisterMBean(ObjectName objectName) throws InstanceNotFoundException, MBeanRegistrationException {
        this.stopIfNotConnected("unregisterMBean(name)");
        if (this.isTraceOn()) {
            this.trace("unregisterMBean", "Remove ProxyMBean and GenericProxy, if required, for name " + objectName);
        }
        if (this.isTraceOn()) {
            this.trace("unregisterMBean(name)", "Remove MBean with name " + objectName);
        }
        try {
            if (this.connectorServerV2 != null) {
                this.connectorServerV2.unregisterMBean(objectName, this.operationContext);
            } else {
                this.connectorServerV1.unregisterMBean(objectName);
            }
        }
        catch (ServerRuntimeException serverRuntimeException) {
            throw (JMRuntimeException)serverRuntimeException.detail;
        }
        catch (RemoteException remoteException) {
            throw new CommunicationException(remoteException);
        }
        this.proxyHandles.remove(objectName);
        this.genericHandles.remove(objectName);
    }

    private class NotificationHandlerInternal
    implements ClientNotificationHandlerInternal {
        private RmiConnectorClient connector;

        public NotificationHandlerInternal(RmiConnectorClient rmiConnectorClient2) {
            this.connector = rmiConnectorClient2;
        }

        public Object[] remoteRequest(int n, Object[] objectArray) throws CommunicationException, Exception {
            return this.connector.remoteRequest(n, objectArray);
        }

        public ConnectorAddress startPush() throws CommunicationException, RemoteRuntimeException {
            return this.connector.startPush();
        }

        public void stopPush(ConnectorAddress connectorAddress) {
            this.connector.stopPush();
        }
    }

    private class HeartBeatInternalClientHandlerImpl
    implements HeartBeatInternalClientHandler {
        private RmiConnectorClient connector;

        public HeartBeatInternalClientHandlerImpl(RmiConnectorClient rmiConnectorClient2) {
            this.connector = rmiConnectorClient2;
        }

        public RemoteMBeanServer getRemoteMBeanServer() {
            return this.connector;
        }

        public String pingHeartBeatServer(String string, int n, int n2, Long l) {
            return this.connector.pingHeartBeatServer(string, n, n2, l);
        }
    }
}

