/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.contrib.hibernate;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.hibernate.HibernateException;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.usertype.EnhancedUserType;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistentLocalTimeAsTimestamp
implements EnhancedUserType,
Serializable {
    public static final PersistentLocalTimeAsTimestamp INSTANCE = new PersistentLocalTimeAsTimestamp();
    private static final int[] SQL_TYPES = new int[]{93};

    public Object assemble(Serializable serializable, Object object) throws HibernateException {
        return serializable;
    }

    public Object deepCopy(Object object) throws HibernateException {
        return object;
    }

    public Serializable disassemble(Object object) throws HibernateException {
        return (Serializable)object;
    }

    public boolean equals(Object object, Object object2) throws HibernateException {
        if (object == object2) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        LocalTime localTime = (LocalTime)object;
        LocalTime localTime2 = (LocalTime)object2;
        return localTime.equals((Object)localTime2);
    }

    public Object fromXMLString(String string) {
        return new LocalTime((Object)string);
    }

    public int hashCode(Object object) throws HibernateException {
        return object.hashCode();
    }

    public boolean isMutable() {
        return false;
    }

    public Object nullSafeGet(ResultSet resultSet, String string) throws SQLException {
        Object object = StandardBasicTypes.TIMESTAMP.nullSafeGet(resultSet, string);
        if (object == null) {
            return null;
        }
        return new LocalTime(object, DateTimeZone.UTC);
    }

    public Object nullSafeGet(ResultSet resultSet, String[] stringArray, Object object) throws HibernateException, SQLException {
        return this.nullSafeGet(resultSet, stringArray[0]);
    }

    public void nullSafeSet(PreparedStatement preparedStatement, Object object, int n) throws HibernateException, SQLException {
        if (object == null) {
            StandardBasicTypes.TIMESTAMP.nullSafeSet(preparedStatement, null, n);
        } else {
            LocalTime localTime = (LocalTime)object;
            Timestamp timestamp = new Timestamp(localTime.getMillisOfDay());
            StandardBasicTypes.TIMESTAMP.nullSafeSet(preparedStatement, (Object)timestamp, n);
        }
    }

    public String objectToSQLString(Object object) {
        throw new UnsupportedOperationException();
    }

    public Object replace(Object object, Object object2, Object object3) throws HibernateException {
        return object;
    }

    public Class<?> returnedClass() {
        return LocalTime.class;
    }

    public int[] sqlTypes() {
        return SQL_TYPES;
    }

    public String toXMLString(Object object) {
        return object.toString();
    }
}

