/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import org.apache.batik.bridge.Messages;
import org.apache.batik.gvt.GraphicsNode;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGDocument;

public class BridgeException
extends RuntimeException {
    protected Element e;
    protected String code;
    protected Object[] params;
    protected int line;
    protected GraphicsNode node;

    public BridgeException(Element e, String code, Object[] params) {
        this.e = e;
        this.code = code;
        this.params = params;
    }

    public Element getElement() {
        return this.e;
    }

    public void setLineNumber(int line) {
        this.line = line;
    }

    public void setGraphicsNode(GraphicsNode node) {
        this.node = node;
    }

    public GraphicsNode getGraphicsNode() {
        return this.node;
    }

    public String getMessage() {
        String uri = ((SVGDocument)this.e.getOwnerDocument()).getURL();
        Object[] fullparams = new Object[this.params.length + 3];
        fullparams[0] = uri;
        fullparams[1] = new Integer(this.line);
        fullparams[2] = this.e.getLocalName();
        int i = 0;
        while (i < this.params.length) {
            fullparams[i + 3] = this.params[i];
            ++i;
        }
        return Messages.formatMessage(this.code, fullparams);
    }

    public String getCode() {
        return this.code;
    }
}

