/*
 * Decompiled with CFR 0.152.
 */
package org.josso.tc55.agent.jaas;

import java.io.IOException;
import java.security.Principal;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.josso.Lookup;
import org.josso.gateway.identity.SSORole;
import org.josso.gateway.identity.SSOUser;
import org.josso.gateway.identity.exceptions.SSOIdentityException;
import org.josso.gateway.identity.service.SSOIdentityManager;

public class SSOGatewayLoginModule
implements LoginModule {
    private static final Log logger = LogFactory.getLog(SSOGatewayLoginModule.class);
    private Subject _subject;
    private CallbackHandler _callbackHandler;
    protected boolean _succeeded;
    protected boolean commitSucceeded;
    protected SSOUser _ssoUserPrincipal;
    protected SSORole[] _ssoRolePrincipals;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this._subject = subject;
        this._callbackHandler = callbackHandler;
    }

    public boolean login() throws LoginException {
        String ssoSessionId;
        if (this._callbackHandler == null) {
            throw new LoginException("Error: no CallbackHandler available to garner authentication information from the user");
        }
        Callback[] callbacks = new Callback[]{new NameCallback("JOSSO Session Identifier"), new PasswordCallback("password", false)};
        String ssoSessionId2 = null;
        try {
            this._callbackHandler.handle(callbacks);
            ssoSessionId = ((NameCallback)callbacks[0]).getName();
            if (((PasswordCallback)callbacks[1]).getPassword() != null) {
                ssoSessionId2 = String.valueOf(((PasswordCallback)callbacks[1]).getPassword());
            }
        }
        catch (IOException ioe) {
            throw new LoginException(ioe.toString());
        }
        catch (UnsupportedCallbackException uce) {
            throw new LoginException("Error: " + uce.getCallback().toString() + " not available to garner authentication information " + "from the user");
        }
        logger.debug((Object)("Session requested authentication to gateway : " + ssoSessionId + "/" + ssoSessionId2));
        try {
            if (ssoSessionId2 != null && !ssoSessionId2.equals(ssoSessionId)) {
                ssoSessionId = ssoSessionId2;
            }
            if (ssoSessionId == null) {
                logger.debug((Object)("Session authentication failed : " + ssoSessionId));
                this._succeeded = false;
                return false;
            }
            SSOIdentityManager im = Lookup.getInstance().lookupSSOAgent().getSSOIdentityManager();
            SSOUser ssoUser = im.findUserInSession(ssoSessionId);
            logger.debug((Object)("Session authentication succeeded : " + ssoSessionId));
            this._ssoUserPrincipal = ssoUser;
            this._succeeded = true;
        }
        catch (SSOIdentityException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)e.getMessage());
            }
            this._succeeded = false;
            return false;
        }
        catch (Exception e) {
            logger.error((Object)("Session authentication failed : " + ssoSessionId), (Throwable)e);
            this._succeeded = false;
            this.clearCredentials();
            throw new FailedLoginException("Fatal error authenticating session : " + e);
        }
        return true;
    }

    public boolean commit() throws LoginException {
        if (!this._succeeded) {
            return false;
        }
        try {
            int i;
            if (!this._subject.getPrincipals().contains(this._ssoUserPrincipal)) {
                this._subject.getPrincipals().add((Principal)this._ssoUserPrincipal);
            }
            logger.debug((Object)("Added SSOUser Principal to the Subject : " + this._ssoUserPrincipal));
            this._ssoRolePrincipals = this.getRoleSets();
            for (i = 0; i < this._ssoRolePrincipals.length; ++i) {
                if (this._subject.getPrincipals().contains(this._ssoRolePrincipals[i])) continue;
                this._subject.getPrincipals().add((Principal)this._ssoRolePrincipals[i]);
                logger.debug((Object)("Added SSORole Principal to the Subject : " + this._ssoRolePrincipals[i]));
            }
            this.commitSucceeded = true;
            i = 1;
            return i != 0;
        }
        catch (Exception e) {
            logger.error((Object)("Session login failed for Principal : " + this._ssoUserPrincipal), (Throwable)e);
            throw new LoginException("Session login failed for Principal : " + this._ssoUserPrincipal);
        }
        finally {
            this.clearCredentials();
        }
    }

    public boolean abort() throws LoginException {
        if (!this._succeeded) {
            return false;
        }
        if (this._succeeded && !this.commitSucceeded) {
            this._succeeded = false;
            this.clearCredentials();
        } else {
            this.logout();
        }
        return true;
    }

    public boolean logout() throws LoginException {
        this._subject.getPrincipals().remove(this._ssoUserPrincipal);
        logger.debug((Object)("Removed SSOUser Principal from Subject : " + this._ssoUserPrincipal));
        for (int i = 0; i < this._ssoRolePrincipals.length; ++i) {
            this._subject.getPrincipals().remove(this._ssoRolePrincipals[i]);
            logger.debug((Object)("Removed SSORole Principal from Subject : " + this._ssoRolePrincipals[i]));
        }
        this._succeeded = this.commitSucceeded;
        this.clearCredentials();
        return true;
    }

    private void clearCredentials() {
        this._ssoUserPrincipal = null;
        this._ssoRolePrincipals = null;
    }

    protected SSORole[] getRoleSets() throws LoginException {
        try {
            SSOIdentityManager im = Lookup.getInstance().lookupSSOAgent().getSSOIdentityManager();
            return im.findRolesByUsername(this._ssoUserPrincipal.getName());
        }
        catch (Exception e) {
            logger.error((Object)("Session login failed for Principal : " + this._ssoUserPrincipal), (Throwable)e);
            throw new LoginException("Session login failed for Principal : " + this._ssoUserPrincipal);
        }
    }
}

