/*
 * Decompiled with CFR 0.152.
 */
package jp.co.bizreach.elasticsearch4s;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.module.scala.DefaultScalaModule$;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import scala.reflect.ClassTag;

public final class JsonUtils$ {
    public static final JsonUtils$ MODULE$;
    private final ObjectMapper mapper;

    static {
        new JsonUtils$();
    }

    private ObjectMapper mapper() {
        return this.mapper;
    }

    public String serialize(Object doc) {
        return this.mapper().writeValueAsString(doc);
    }

    public <T> T deserialize(String json, ClassTag<T> c) {
        return (T)this.mapper().readValue(json, c.runtimeClass());
    }

    private JsonUtils$() {
        MODULE$ = this;
        this.mapper = new ObjectMapper();
        this.mapper().enable(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS);
        this.mapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.mapper().registerModule((Module)DefaultScalaModule$.MODULE$);
        this.mapper().registerModule((Module)new SimpleModule("MyModule", Version.unknownVersion()).addSerializer(DateTime.class, (JsonSerializer)new JsonSerializer<DateTime>(){

            public void serialize(DateTime value, JsonGenerator generator, SerializerProvider provider) {
                DateTimeFormatter formatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").withZoneUTC();
                generator.writeString(formatter.print((ReadableInstant)value));
            }
        }).addDeserializer(DateTime.class, (JsonDeserializer)new JsonDeserializer<DateTime>(){

            public DateTime deserialize(JsonParser parser, DeserializationContext context) {
                DateTimeFormatter formatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").withZoneUTC();
                return formatter.parseDateTime(parser.getValueAsString() == null ? parser.nextTextValue() : parser.getValueAsString());
            }
        }));
    }
}

