/*
 * Decompiled with CFR 0.152.
 */
package jp.co.worksap.message.decoder;

import com.sun.mail.util.BASE64DecoderStream;
import com.sun.mail.util.QPDecoderStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import javax.mail.MessagingException;

public class ContentDecoder {
    private Reader reader = null;

    public String decodeContent(InputStream in, String charset, String encoding) throws MessagingException {
        if (in == null) {
            return null;
        }
        if (encoding == null) {
            return this.decodeQPContent(in, charset);
        }
        String lowerCaseEncoding = encoding.toLowerCase();
        if (lowerCaseEncoding.equals("base64")) {
            return this.decodeBase64Content(in, charset);
        }
        if (lowerCaseEncoding.equals("quoted-printable")) {
            return this.decodeQPContent(in, charset);
        }
        return this.decode8BitContent(in, charset);
    }

    private String decodeBase64Content(InputStream in, String charset) throws MessagingException {
        if (in == null) {
            return null;
        }
        try {
            this.reader = new InputStreamReader((InputStream)new BASE64DecoderStream(in), charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new MessagingException("Failed to decode because of an unsupported encoding", (Exception)e);
        }
        return this.readContent(this.reader);
    }

    private String decodeQPContent(InputStream in, String charset) throws MessagingException {
        if (in == null) {
            return null;
        }
        try {
            this.reader = new InputStreamReader((InputStream)new QPDecoderStream(in), charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new MessagingException("Failed to decode because of an unsupported encoding", (Exception)e);
        }
        return this.readContent(this.reader);
    }

    public String decode8BitContent(InputStream in, String charset) throws MessagingException {
        if (in == null) {
            return null;
        }
        try {
            this.reader = new InputStreamReader(in, charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new MessagingException("Failed to decode because of an unsupported encoding", (Exception)e);
        }
        return this.readContent(this.reader);
    }

    private String readContent(Reader reader) throws MessagingException {
        BufferedReader br = null;
        StringBuilder sb = null;
        try {
            String line;
            br = new BufferedReader(reader);
            sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                sb.append(line);
                sb.append("\r\n");
            }
            sb.delete(sb.length() - 2, sb.length());
            String string = sb.toString();
            return string;
        }
        catch (IOException e) {
            throw new MessagingException("Failed to read data from the source", (Exception)e);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {}
            }
            if (sb != null) {
                try {
                    br.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

