/*
 * Decompiled with CFR 0.152.
 */
package jp.co.worksap.message.decoder;

import java.io.UnsupportedEncodingException;
import jp.co.worksap.message.util.CharsetUtility;
import jp.co.worksap.message.util.Encoding;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.net.QuotedPrintableCodec;
import org.apache.commons.codec.net.URLCodec;

public final class HeaderDecoder {
    private static final String SOFT_BREAK = "\\r\\n\\s*";
    private static final String STR_WITH_SPACE = "\\?=\\s=\\?";
    private static final String STR_WITHOUT_SPACE = "\\?==\\?";

    public String decodeAddress(String encodedAddress) {
        String parsedAddress = this.parse(encodedAddress);
        return this.decode(parsedAddress);
    }

    public String decodeSubject(String edcodedSubject) {
        String parsedSubject = this.parse(edcodedSubject);
        return this.decode(parsedSubject);
    }

    public String decodeFileName(String mimeHeader) {
        if (mimeHeader.toLowerCase().contains("filename")) {
            return this.getFileNameFromFileNameParameter(mimeHeader);
        }
        if (mimeHeader.toLowerCase().contains("name")) {
            return this.getFileNameFromNameParameter(mimeHeader);
        }
        return "";
    }

    private String parse(String text) {
        String transferEncoding = this.getTransferEncoding(text);
        String textWithoutSoftBreak = this.replace(text.trim(), SOFT_BREAK, "");
        String textWithoutSpace = this.replace(textWithoutSoftBreak, STR_WITH_SPACE, STR_WITHOUT_SPACE);
        if (transferEncoding == "b") {
            return textWithoutSpace;
        }
        String regex = this.createEncodingRegex();
        return this.replace(textWithoutSpace, regex, "");
    }

    private String decode(String text) {
        if (!text.contains("=?")) {
            return text;
        }
        String before = this.getBeforeFirstEncodedPart(text);
        String encoded = this.getFirstEncodedPart(text);
        String after = this.getAfterFirstEncodedPart(text);
        String decoded = "";
        try {
            decoded = this.decodeHeader(this.getEncodedText(encoded), CharsetUtility.getMappingCharSet(encoded.toLowerCase()), this.getTransferEncoding(encoded));
        }
        catch (UnsupportedEncodingException e) {
            return text;
        }
        catch (DecoderException e) {
            return text;
        }
        if (!CharsetUtility.getValidCharset(after.toLowerCase()).isEmpty()) {
            after = this.decode(after);
        }
        return before + decoded + after;
    }

    private String getFileNameFromFileNameParameter(String mimeHeader) {
        String disposition = this.getContentDisposition(mimeHeader);
        if (disposition.contains("filename")) {
            if (disposition.toLowerCase().contains("=?")) {
                String encoded = this.getFileNameByBase64(disposition);
                return encoded;
            }
            return this.getFileNameByRfc2231(disposition);
        }
        return "";
    }

    private String getFileNameFromNameParameter(String mimeHeader) {
        if (mimeHeader.toLowerCase().contains("name")) {
            String[] splitted;
            for (String s : splitted = mimeHeader.split("\\r\\n")) {
                if (!s.contains("name=")) continue;
                int begin = s.indexOf("name=");
                String substring = s.substring(begin += "name=".length());
                return this.trimDoubleQuotations(substring);
            }
        }
        return "";
    }

    private String getContentDisposition(String mimeHeader) {
        String disposition = "\r\ncontent-disposition";
        int begin = mimeHeader.toLowerCase().indexOf(disposition);
        if (begin < 0) {
            return "";
        }
        int end = mimeHeader.toLowerCase().indexOf("\r\ncontent", (begin += 2) + disposition.length());
        if (end < 0) {
            return mimeHeader.substring(begin);
        }
        return mimeHeader.substring(begin, end);
    }

    private String getFileNameByBase64(String contentDisposition) {
        String target = "filename=";
        int begin = contentDisposition.indexOf(target);
        if (begin < 0) {
            return "";
        }
        String substring = null;
        int end = contentDisposition.indexOf(";", begin += target.length());
        substring = end < 0 ? contentDisposition.substring(begin) : contentDisposition.substring(begin, end);
        String noQuotation = this.trimDoubleQuotations(substring);
        String noSoftBreak = this.replace(noQuotation, SOFT_BREAK, "");
        return this.decode(noSoftBreak);
    }

    private String getFileNameByRfc2231(String contentDisposition) {
        if (contentDisposition.contains("*0")) {
            String unitedFileName = this.getUnitedFileName(contentDisposition);
            if (contentDisposition.contains("*=")) {
                return this.decodeUrlEncodedFileName(unitedFileName);
            }
            return unitedFileName;
        }
        if (contentDisposition.contains("*=")) {
            return this.decodeUrlEncodedFileName(contentDisposition);
        }
        return this.getUnencodedFileName(contentDisposition);
    }

    private String getUnencodedFileName(String contentDisposition) {
        String target;
        String trimmed = contentDisposition.trim();
        int begin = trimmed.indexOf(target = "filename=");
        if (begin < 0) {
            return "";
        }
        String fileName = trimmed.substring(begin += target.length());
        return this.trimDoubleQuotations(fileName);
    }

    private String getUnitedFileName(String multiLine) {
        String starEqual = "*=";
        String semicolon = ";";
        String connected = "";
        int begin = 0;
        int end = 0;
        while ((begin = multiLine.indexOf(starEqual, end)) >= 0) {
            end = multiLine.indexOf(semicolon, begin += starEqual.length());
            if (end < 0) {
                return connected + multiLine.substring(begin).trim();
            }
            connected = connected + multiLine.substring(begin, end);
        }
        return connected;
    }

    private String decodeUrlEncodedFileName(String encodedFileName) {
        String trimmed = encodedFileName.trim();
        String encoding = CharsetUtility.getValidCharset(trimmed.toLowerCase());
        int indexOfFirstQuotation = trimmed.indexOf("'");
        if (indexOfFirstQuotation < 0) {
            return "";
        }
        int indexOfSecondQuotation = trimmed.indexOf("'", indexOfFirstQuotation + 1);
        if (indexOfSecondQuotation < 0) {
            return "";
        }
        String encoded = trimmed.substring(indexOfSecondQuotation + 1);
        try {
            return this.decodeTextByUrl(encoded, CharsetUtility.getMappingCharSet(encoding.toLowerCase()));
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
        catch (DecoderException e) {
            return "";
        }
    }

    private String trimDoubleQuotations(String text) {
        String trimmed = text.trim();
        if (trimmed.length() == 0) {
            return "";
        }
        if (trimmed.charAt(0) == '\"' && trimmed.charAt(trimmed.length() - 1) == '\"') {
            return trimmed.substring(1, trimmed.length() - 1);
        }
        return text;
    }

    private String replace(String text, String regex, String replacement) {
        return text.replaceAll(regex, replacement);
    }

    private String createEncodingRegex() {
        StringBuilder builder = new StringBuilder();
        String[] charSets = Encoding.VALID_CHARSETS;
        builder.append("\\?==\\?(");
        for (int i = 0; i < charSets.length; ++i) {
            builder.append("(").append(charSets[i]).append(")");
            builder.append("|");
        }
        builder.deleteCharAt(builder.lastIndexOf("|"));
        builder.append(")\\?.?\\?");
        return builder.toString();
    }

    private String getTransferEncoding(String text) {
        String lowerCaseText = text.toLowerCase();
        if (lowerCaseText.contains("?b?")) {
            return "b";
        }
        if (lowerCaseText.contains("?q?")) {
            return "q";
        }
        return "";
    }

    private String getEncodedText(String text) {
        String lowerCaseText = text.toLowerCase();
        int begin = lowerCaseText.indexOf("?b?");
        if (begin < 0) {
            begin = lowerCaseText.indexOf("?q?");
        }
        if (begin < 0) {
            return "";
        }
        int end = text.lastIndexOf("?=");
        if ((begin += 3) > end || end > text.length()) {
            return "";
        }
        return text.substring(begin, end);
    }

    private String getAfterFirstEncodedPart(String text) {
        int begin = text.indexOf("?=");
        if (begin < 0) {
            return "";
        }
        String lowerCaseText = text.toLowerCase();
        int wrong = lowerCaseText.indexOf("?q?=") + 4;
        if ((begin += 2) == wrong) {
            begin = lowerCaseText.indexOf("?=", wrong) + 2;
        }
        if (begin > text.length()) {
            return "";
        }
        return text.substring(begin);
    }

    private String getFirstEncodedPart(String text) {
        int wrong;
        int begin = text.indexOf("=?");
        int end = text.indexOf("?=") + 2;
        if (end == (wrong = text.toLowerCase().indexOf("?q?=") + 4)) {
            end = text.indexOf("?=", wrong) + 2;
        }
        if (begin < 0 || end > text.length() || begin > end) {
            return "";
        }
        return text.substring(begin, end);
    }

    private String getBeforeFirstEncodedPart(String text) {
        int end = text.indexOf("=?");
        if (end > text.length()) {
            return "";
        }
        return text.substring(0, end);
    }

    private String decodeTextByBase64(String encodedText, String charset) throws UnsupportedEncodingException {
        byte[] byteArray = encodedText.getBytes(charset);
        byte[] unbase64 = Base64.decodeBase64((byte[])byteArray);
        return new String(unbase64, charset);
    }

    private String decodeTextByQuotedPrintable(String encodedText, String charset) throws UnsupportedEncodingException, DecoderException {
        String grepped = encodedText.replaceAll("_", " ");
        QuotedPrintableCodec codec = new QuotedPrintableCodec();
        return codec.decode(grepped, charset);
    }

    private String decodeTextByUrl(String encodedText, String charset) throws UnsupportedEncodingException, DecoderException {
        URLCodec codec = new URLCodec();
        return codec.decode(encodedText, charset);
    }

    private String decodeHeader(String encodedText, String charset, String encoding) throws UnsupportedEncodingException, DecoderException {
        String lowerCaseEncoding = encoding.toLowerCase();
        if (lowerCaseEncoding.equals("b")) {
            return this.decodeTextByBase64(encodedText, charset);
        }
        if (lowerCaseEncoding.equals("q")) {
            return this.decodeTextByQuotedPrintable(encodedText, charset);
        }
        if (lowerCaseEncoding.equals("url")) {
            return this.decodeTextByUrl(encodedText, charset);
        }
        if (lowerCaseEncoding.equals("none")) {
            return new String(encodedText.getBytes(), charset);
        }
        return "";
    }
}

