/*
 * Decompiled with CFR 0.152.
 */
package jp.co.worksap.message.parser;

import com.google.common.base.Strings;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.Address;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import jp.co.worksap.message.decoder.HeaderDecoder;
import jp.co.worksap.message.util.CharsetUtility;

public class AddressParser {
    private static final Pattern IN_BRACKET_FILTER = Pattern.compile("<(.*)>", 2);
    private static final Pattern IN_DOUBLE_QUOTATION_FILTER = Pattern.compile("\"(.*)\"", 2);
    private static final Pattern OUT_OF_BRACKET_FILTER = Pattern.compile("(.*)<.*>", 2);

    public InternetAddress[] fixAddress(Address[] garble, String[] constructable) throws MessagingException {
        Address[] address;
        if (garble == null || constructable == null) {
            return new InternetAddress[0];
        }
        String[] raw = this.splitAddressString(constructable);
        if (raw.length != (address = this.resplitAddress(garble)).length) {
            InternetAddress[] fixed = new InternetAddress[raw.length];
            for (int i = 0; i < raw.length; ++i) {
                fixed[i] = this.getAddressFromRawString(raw[i]);
            }
            return fixed;
        }
        InternetAddress[] fixed = new InternetAddress[raw.length];
        for (int i = 0; i < raw.length; ++i) {
            boolean undecodableUtf8;
            String lowerCase = raw[i].toLowerCase();
            boolean bl = undecodableUtf8 = lowerCase.contains("utf-8") && raw[i].contains("\r\n");
            if (undecodableUtf8 || CharsetUtility.needsMapping(lowerCase)) {
                fixed[i] = this.getAddressFromRawString(raw[i]);
                continue;
            }
            fixed[i] = (InternetAddress)address[i];
            fixed[i].getPersonal();
        }
        return fixed;
    }

    public InternetAddress getAddressFromRawString(String text) throws MessagingException {
        HeaderDecoder decoder = new HeaderDecoder();
        String decoded = decoder.decodeAddress(text);
        String email = this.getEmail(decoded);
        String personal = null;
        personal = text.contains("\"") ? this.getPersonal(decoded) : this.getPersonalWithQuote(decoded);
        if (personal.isEmpty()) {
            try {
                return new InternetAddress(email);
            }
            catch (AddressException e) {
                throw new MessagingException("Can not get the address because its format is wrong", (Exception)((Object)e));
            }
        }
        try {
            return new InternetAddress(email, personal);
        }
        catch (UnsupportedEncodingException e) {
            throw new MessagingException("Can not get the address because of an unsupported encoding", (Exception)e);
        }
    }

    private String[] splitAddressString(String[] address) {
        ArrayList<String> list = new ArrayList<String>();
        for (String ad : address) {
            String[] splitted = ad.split(",");
            for (int i = 0; i < splitted.length; ++i) {
                if (this.isEvenNumberOfQuot(splitted[i])) {
                    list.add(splitted[i]);
                    continue;
                }
                StringBuilder sb = new StringBuilder();
                sb.append(splitted[i]);
                ++i;
                while (i < splitted.length) {
                    sb.append(",");
                    sb.append(splitted[i]);
                    if (!this.isEvenNumberOfQuot(splitted[i])) break;
                    ++i;
                }
                list.add(sb.toString());
            }
        }
        return list.toArray(new String[0]);
    }

    private Address[] resplitAddress(Address[] garble) throws MessagingException {
        ArrayList<Object> addressList = new ArrayList<Object>();
        for (Address a : garble) {
            String[] splitted = a.toString().split(",");
            if (splitted.length == 1) {
                addressList.add(a);
                continue;
            }
            for (String s : splitted) {
                try {
                    addressList.add(new InternetAddress(this.getEmail(s), this.getPersonal(s)));
                }
                catch (UnsupportedEncodingException e) {
                    throw new MessagingException("Can not split the address because of an unsupported exception", (Exception)e);
                }
            }
        }
        return (Address[])addressList.toArray(new InternetAddress[0]);
    }

    private String getEmail(String text) {
        Matcher matcher = IN_BRACKET_FILTER.matcher(text);
        if (!matcher.find()) {
            return text;
        }
        if (matcher.groupCount() < 1) {
            return text;
        }
        return matcher.group(1);
    }

    private String getPersonal(String text) {
        Matcher quotation = IN_DOUBLE_QUOTATION_FILTER.matcher(text);
        if (quotation.find() && quotation.groupCount() >= 1) {
            return quotation.group(1);
        }
        Matcher nonBracket = OUT_OF_BRACKET_FILTER.matcher(text);
        if (nonBracket.find() && nonBracket.groupCount() >= 1) {
            return nonBracket.group(1).trim();
        }
        try {
            new InternetAddress(text);
            return "";
        }
        catch (AddressException e) {
            return text;
        }
    }

    private String getPersonalWithQuote(String text) {
        Matcher nonBracket = OUT_OF_BRACKET_FILTER.matcher(text);
        if (nonBracket.find() && nonBracket.groupCount() >= 1) {
            return nonBracket.group(1).trim();
        }
        try {
            new InternetAddress(text);
            return "";
        }
        catch (AddressException e) {
            return text;
        }
    }

    private boolean isEvenNumberOfQuot(String text) {
        int count = 0;
        int indexOfQuot = -1;
        while ((indexOfQuot = text.indexOf("\"", indexOfQuot + 1)) >= 0) {
            ++count;
        }
        return count % 2 == 0;
    }

    public boolean isBlankStrings(String[] array) {
        if (array == null || array.length == 0) {
            return true;
        }
        for (String s : array) {
            if (Strings.isNullOrEmpty((String)s)) continue;
            return false;
        }
        return true;
    }
}

