/*
 * Decompiled with CFR 0.152.
 */
package jp.co.worksap.message.parser;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeMessage;
import jp.co.worksap.message.decoder.ContentDecoder;

public class ContentParser {
    private MimeMessage instance;

    public ContentParser(MimeMessage instance) {
        this.instance = instance;
    }

    public Object parseContent(String charset) throws MessagingException, IOException {
        InputStream in = this.instance.getRawInputStream();
        String encoding = this.instance.getEncoding();
        try {
            if (!charset.isEmpty()) {
                ContentDecoder decoder = new ContentDecoder();
                return decoder.decodeContent(in, charset, encoding);
            }
            return this.instance.getContent();
        }
        catch (UnsupportedEncodingException e) {
            throw new MessagingException("Can not decode the content because of an unsupported ecoding.", (Exception)e);
        }
    }

    public boolean isMimeMessageIncludingNoCharset() throws MessagingException, IOException {
        if (!this.getCharset().isEmpty()) {
            return false;
        }
        return !(this.instance.getContent() instanceof Multipart);
    }

    public boolean isQuotedPrintableShiftJisContent() throws MessagingException {
        String encoding = this.instance.getEncoding();
        if (encoding == null || !encoding.equalsIgnoreCase("quoted-printable")) {
            return false;
        }
        String charset = this.getCharset();
        return charset != null && charset.equalsIgnoreCase("shift_jis");
    }

    public String getCharset() {
        String[] elems;
        String contentType;
        String targetKey = "charset=";
        String charset = "";
        try {
            contentType = this.instance.getContentType();
        }
        catch (MessagingException e) {
            return charset;
        }
        for (String elem : elems = contentType.split(";")) {
            if (!elem.trim().startsWith(targetKey)) continue;
            charset = elem.trim().substring(targetKey.length());
        }
        charset = this.trimDoubleQuotations(charset);
        return charset;
    }

    private String trimDoubleQuotations(String quotedText) {
        String text = quotedText;
        if (text != null) {
            if (text.startsWith("\"")) {
                text = text.substring(1);
            }
            if (text.endsWith("\"")) {
                text = text.substring(0, text.length() - 1);
            }
        }
        return text;
    }
}

