/*
 * Decompiled with CFR 0.152.
 */
package jp.co.worksap.message.util;

import java.util.HashMap;
import java.util.Map;
import jp.co.worksap.message.util.Encoding;

public class CharsetUtility {
    private static final Map<String, String> CHARSET_MAP = new HashMap<String, String>(){
        private static final long serialVersionUID = 3242501372820040804L;
        {
            this.put("iso-2022-jp", "X-WINDOWS-ISO2022JP");
            this.put("iso2022jp", "X-WINDOWS-ISO2022JP");
            this.put("shift_jis", "MS932");
            this.put("cp932", "MS932");
            this.put("gb2312", "GB18030");
            this.put("iso-8859-1", "Windows-1252");
        }
    };

    public static String getMappingCharSet(String text) {
        String source = CharsetUtility.getValidCharset(text);
        if (source.isEmpty()) {
            return "";
        }
        if (CHARSET_MAP.containsKey(source)) {
            return CHARSET_MAP.get(source);
        }
        return source;
    }

    public static String getValidCharset(String text) {
        for (String charSet : Encoding.VALID_CHARSETS) {
            if (!text.contains(charSet)) continue;
            return charSet;
        }
        return "";
    }

    public static boolean needsMapping(String text) {
        for (Map.Entry<String, String> entry : CHARSET_MAP.entrySet()) {
            if (!text.contains(entry.getKey())) continue;
            return true;
        }
        return false;
    }

    public static Map<String, String> getCharsetMap() {
        return CHARSET_MAP;
    }
}

