/*
 * Decompiled with CFR 0.152.
 */
package jp.co.worksap.message.wrapper;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.mail.Header;
import jp.co.worksap.message.util.CharsetUtility;

public class CharsetGuesser {
    private static final int SIZE = 1024;

    public String guessCharset(Enumeration<?> e, InputStream input) {
        Set<String> charSets = this.guessCharset(e);
        for (String charset : charSets) {
            try {
                if (charset.equals("gb18030") || !this.canDecode(input, Charset.forName(charset))) continue;
                return charset;
            }
            catch (IOException ex) {
            }
        }
        if (charSets.contains("gb18030")) {
            return "gb18030";
        }
        return "";
    }

    private Set<String> guessCharset(Enumeration<?> e) {
        HashSet<String> charSets = new HashSet<String>();
        while (e.hasMoreElements()) {
            String value;
            String charSet;
            Object o = e.nextElement();
            if (!(o instanceof Header) || (charSet = CharsetUtility.getMappingCharSet(value = ((Header)o).getValue().toLowerCase())).isEmpty()) continue;
            charSets.add(charSet);
        }
        return charSets;
    }

    private boolean canDecode(InputStream input, Charset charset) throws IOException {
        CoderResult coderResult;
        ReadableByteChannel channel = Channels.newChannel(input);
        CharsetDecoder decoder = charset.newDecoder();
        ByteBuffer byteBuffer = ByteBuffer.allocate(2048);
        CharBuffer charBuffer = CharBuffer.allocate(1024);
        boolean endOfInput = false;
        while (!endOfInput) {
            int n = channel.read(byteBuffer);
            byteBuffer.flip();
            endOfInput = n == -1;
            CoderResult coderResult2 = decoder.decode(byteBuffer, charBuffer, endOfInput);
            if (coderResult2.isError()) {
                return false;
            }
            charBuffer.clear();
            while (coderResult2 == CoderResult.OVERFLOW) {
                coderResult2 = decoder.decode(byteBuffer, charBuffer, endOfInput);
                charBuffer.clear();
            }
            byteBuffer.compact();
        }
        while ((coderResult = decoder.flush(charBuffer)) == CoderResult.OVERFLOW) {
            charBuffer.clear();
        }
        return !coderResult.isError();
    }
}

