/*
 * Decompiled with CFR 0.152.
 */
package jp.co.worksap.message.wrapper;

import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Map;
import javax.activation.DataHandler;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.mail.Address;
import javax.mail.Flags;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import jp.co.worksap.message.decoder.ContentDecoder;
import jp.co.worksap.message.decoder.HeaderDecoder;
import jp.co.worksap.message.parser.AddressParser;
import jp.co.worksap.message.parser.AttachedFileParser;
import jp.co.worksap.message.parser.ContentParser;
import jp.co.worksap.message.util.CharsetUtility;
import jp.co.worksap.message.util.StringValidator;
import jp.co.worksap.message.wrapper.CharsetGuesser;

public class MessageWrapper
extends Message {
    private static final String REPLY_TO = "Reply-To";
    @Nonnull
    private final Message instance;
    @Nonnull
    private String UID;
    private boolean isFileNameFixed = false;

    public MessageWrapper(@Nonnull Message m) {
        this.instance = (Message)Preconditions.checkNotNull((Object)m);
    }

    public void addHeader(String headerName, String headerValue) throws MessagingException {
        this.instance.addHeader(headerName, headerValue);
    }

    public Enumeration<?> getAllHeaders() throws MessagingException {
        return this.instance.getAllHeaders();
    }

    public Address[] getAllRecipients() throws MessagingException {
        return this.instance.getAllRecipients();
    }

    public void addRecipient(Message.RecipientType type, Address address) throws MessagingException {
        this.instance.addRecipient(type, address);
    }

    public Address[] getReplyTo() throws MessagingException {
        AddressParser parser = new AddressParser();
        String[] replyTo = this.getHeader(REPLY_TO);
        if (parser.isBlankStrings(replyTo)) {
            return this.getFrom();
        }
        ArrayList<InternetAddress> addresses = new ArrayList<InternetAddress>();
        for (String t : replyTo) {
            String[] splitted;
            for (String s : splitted = t.split(",")) {
                addresses.add(parser.getAddressFromRawString(s));
            }
        }
        if (addresses.size() == 0) {
            return this.getFrom();
        }
        return addresses.toArray(new Address[0]);
    }

    public Object getContent() throws IOException, MessagingException {
        if (this.instance instanceof MimeMessage) {
            ContentParser parser = new ContentParser((MimeMessage)this.instance);
            if (parser.isMimeMessageIncludingNoCharset()) {
                CharsetGuesser guesser = new CharsetGuesser();
                String charset = guesser.guessCharset(this.instance.getAllHeaders(), ((MimeMessage)this.instance).getRawInputStream());
                return parser.parseContent(charset);
            }
            if (parser.isQuotedPrintableShiftJisContent()) {
                return parser.parseContent("ms932");
            }
        }
        Object content = null;
        try {
            content = this.getContentFromMessage();
        }
        catch (IOException e) {
            if (this.instance instanceof MimeMessage) {
                ContentParser parser = new ContentParser((MimeMessage)this.instance);
                ContentDecoder decoder = new ContentDecoder();
                return decoder.decodeContent(((MimeMessage)this.instance).getRawInputStream(), parser.getCharset(), "8bit");
            }
            throw e;
        }
        if (!(content instanceof Multipart)) {
            return this.instance.getContent();
        }
        if (!this.isFileNameFixed) {
            AttachedFileParser parser = new AttachedFileParser(this.instance);
            parser.fixFileName((Multipart)content);
            this.isFileNameFixed = true;
        }
        return content;
    }

    public String getContentType() throws MessagingException {
        return this.instance.getContentType();
    }

    public DataHandler getDataHandler() throws MessagingException {
        return this.instance.getDataHandler();
    }

    public String getDescription() throws MessagingException {
        return this.instance.getDescription();
    }

    public String getDisposition() throws MessagingException {
        return this.instance.getDisposition();
    }

    public String getFileName() throws MessagingException {
        if (this.instance instanceof MimeMessage && this.instance.isMimeType("application/*")) {
            String[] disposition = this.instance.getHeader("Content-Disposition");
            String s = null;
            if (disposition != null && disposition.length > 0) {
                s = "\r\ncontent-disposition: " + disposition[0];
            }
            if (s == null) {
                s = this.instance.getContentType();
            }
            if (s != null) {
                if (this.isFileNameFixed) {
                    return this.instance.getFileName();
                }
                return new HeaderDecoder().decodeFileName(s);
            }
        }
        return this.instance.getFileName();
    }

    public String[] getHeader(String headerName) throws MessagingException {
        return this.instance.getHeader(headerName);
    }

    public InputStream getInputStream() throws IOException, MessagingException {
        return this.instance.getInputStream();
    }

    public int getLineCount() throws MessagingException {
        return this.instance.getLineCount();
    }

    public Enumeration<?> getMatchingHeaders(String[] headerName) throws MessagingException {
        return this.instance.getMatchingHeaders(headerName);
    }

    public Enumeration<?> getNonMatchingHeaders(String[] headerName) throws MessagingException {
        return this.instance.getNonMatchingHeaders(headerName);
    }

    public int getSize() throws MessagingException {
        return this.instance.getSize();
    }

    public boolean isMimeType(String mimeType) throws MessagingException {
        return this.instance.isMimeType(mimeType);
    }

    public void removeHeader(String headerName) throws MessagingException {
        this.instance.removeHeader(headerName);
    }

    public void setContent(Multipart mp) throws MessagingException {
        this.instance.setContent(mp);
    }

    public void setContent(Object obj, String type) throws MessagingException {
        this.instance.setContent(obj, type);
    }

    public void setDataHandler(DataHandler dh) throws MessagingException {
        this.instance.setDataHandler(dh);
    }

    public void setDescription(String description) throws MessagingException {
        this.instance.setDescription(description);
    }

    public void setDisposition(String disposition) throws MessagingException {
        this.instance.setDisposition(disposition);
    }

    public void setFileName(String fileName) throws MessagingException {
        this.instance.setFileName(fileName);
    }

    public void setHeader(String headerName, String headerValue) throws MessagingException {
        this.instance.setHeader(headerName, headerValue);
    }

    public void setText(String text) throws MessagingException {
        this.instance.setText(text);
    }

    public void writeTo(OutputStream os) throws IOException, MessagingException {
        this.instance.writeTo(os);
    }

    public void addFrom(Address[] addresses) throws MessagingException {
        this.instance.addFrom(addresses);
    }

    public void addRecipients(Message.RecipientType type, Address[] addresses) throws MessagingException {
        this.instance.addRecipients(type, addresses);
    }

    public Flags getFlags() throws MessagingException {
        return this.instance.getFlags();
    }

    public InternetAddress[] getFrom() throws MessagingException {
        Address[] garble = this.instance.getFrom();
        String[] constructable = this.getHeader("from");
        try {
            AddressParser parser = new AddressParser();
            return parser.fixAddress(garble, constructable);
        }
        catch (MessagingException e) {
            return this.cast(garble);
        }
    }

    public String getSubject() throws MessagingException {
        CharsetGuesser guesser;
        String charset;
        String[] subject = this.getHeader("subject");
        if (subject == null || subject[0] == null) {
            return "";
        }
        String lower = subject[0].toLowerCase();
        if (CharsetUtility.needsMapping(lower)) {
            HeaderDecoder decoder = new HeaderDecoder();
            String decoded = decoder.decodeSubject(subject[0]);
            return decoded.replaceAll("\\r\\n", "");
        }
        String decoded = this.instance.getSubject();
        if (!StringValidator.isValid(decoded) && !(charset = (guesser = new CharsetGuesser()).guessCharset(this.instance.getAllHeaders(), new ByteArrayInputStream(subject[0].getBytes()))).isEmpty()) {
            try {
                return new String(subject[0].getBytes(), charset);
            }
            catch (UnsupportedEncodingException e) {
                throw new MessagingException("Unsupported encoding", (Exception)e);
            }
        }
        return decoded;
    }

    public Date getReceivedDate() throws MessagingException {
        return this.instance.getReceivedDate();
    }

    public InternetAddress[] getRecipients(Message.RecipientType type) throws MessagingException {
        Address[] garble = this.instance.getRecipients(type);
        String[] constructable = this.getHeader(type.toString());
        if (garble == null || constructable == null) {
            return new InternetAddress[0];
        }
        try {
            AddressParser parser = new AddressParser();
            return parser.fixAddress(garble, constructable);
        }
        catch (MessagingException e) {
            return this.cast(garble);
        }
    }

    public Date getSentDate() throws MessagingException {
        return this.instance.getSentDate();
    }

    public Message reply(boolean replyToAll) throws MessagingException {
        return this.instance.reply(replyToAll);
    }

    public void saveChanges() throws MessagingException {
        this.instance.saveChanges();
    }

    public void setFlags(Flags flag, boolean set) throws MessagingException {
        this.instance.setFlags(flag, set);
    }

    public void setFrom() throws MessagingException {
        this.instance.setFrom();
    }

    public void setFrom(Address address) throws MessagingException {
        this.instance.setFrom(address);
    }

    public void setRecipients(Message.RecipientType type, Address[] addresses) throws MessagingException {
        this.instance.setRecipients(type, addresses);
    }

    public void setSentDate(Date date) throws MessagingException {
        this.instance.setSentDate(date);
    }

    public void setSubject(@Nullable String subject) throws MessagingException {
        if (subject == null) {
            this.instance.setSubject("");
        } else {
            this.instance.setSubject(subject);
        }
    }

    @Nonnull
    public String getUID() {
        if (this.UID == null) {
            throw new IllegalStateException("UID is not set yet.");
        }
        return this.UID;
    }

    public void setUID(@Nonnull String uid) {
        this.UID = (String)Preconditions.checkNotNull((Object)uid);
    }

    private Object getContentFromMessage() throws IOException, MessagingException {
        try {
            return this.instance.getContent();
        }
        catch (UnsupportedEncodingException e) {
            String wrongCharset = e.getMessage().toLowerCase();
            for (Map.Entry<String, String> entry : CharsetUtility.getCharsetMap().entrySet()) {
                if (!wrongCharset.contains(entry.getKey())) continue;
                String contentType = this.getContentType();
                this.setHeader("Content-Type", contentType.split(";")[0] + "; charset=" + entry.getValue());
                return this.instance.getContent();
            }
            throw e;
        }
    }

    private InternetAddress[] cast(Address[] garble) {
        InternetAddress[] casted = new InternetAddress[garble.length];
        for (int i = 0; i < casted.length; ++i) {
            casted[i] = (InternetAddress)garble[i];
        }
        return casted;
    }

    static {
        System.setProperty("sun.nio.cs.map", "x-windows-iso2022jp/ISO-2022-JP");
        System.setProperty("mail.mime.contenttypehandler", "jp.co.worksap.message.util.CharsetMap");
    }
}

