package jp.gopay.sdk;

import jp.gopay.sdk.models.common.auth.AuthStrategy;
import jp.gopay.sdk.settings.AbstractSDKSettings;
import jp.gopay.sdk.utils.RequestUtils;
import retrofit2.Retrofit;

public abstract class AbstractSDK{
    protected Retrofit retrofit;
    protected AuthStrategy authStrategy;
    protected AbstractSDKSettings settings;

    public AbstractSDK(AuthStrategy authStrategy, AbstractSDKSettings settings) {
        this.authStrategy = authStrategy;
        this.settings = settings;
        this.retrofit = RequestUtils.createClient(authStrategy, settings);
    }

}
