package jp.gopay.sdk.builders;

import jp.gopay.sdk.models.common.IdempotencyKey;
import jp.gopay.sdk.models.response.GoPayResponse;
import retrofit2.Retrofit;

public abstract class IdempotentRetrofitRequestBuilder<E extends GoPayResponse, R, B>
        extends RetrofitRequestBuilder<E, R> implements IdempotentRequestBuilder<B>{

    protected IdempotencyKey idempotencyKey;

    public IdempotentRetrofitRequestBuilder(Retrofit retrofit) {
        super(retrofit);
    }

    @Override
    public B withIdempotencyKey(IdempotencyKey idempotencyKey) {
        this.idempotencyKey = idempotencyKey;
        return (B)this;
    }

    @Override
    public IdempotencyKey getIdempotencyKey() {
        return idempotencyKey;
    }
}
