package jp.gopay.sdk.builders;

import jp.gopay.sdk.models.errors.GoPayException;
import jp.gopay.sdk.models.errors.TooManyRequestsException;
import jp.gopay.sdk.utils.GoPayCallback;
import jp.gopay.sdk.utils.Sleeper;

import java.io.IOException;

public interface Request<E> {

    /**
     * Executes the request, processing asynchronously and calling the corresponding callback (response/failure)
     */
    void dispatch(GoPayCallback<E> callback);

    E dispatch() throws IOException, GoPayException, TooManyRequestsException;

    E dispatch(int maxRetry, Sleeper sleeper) throws IOException, GoPayException, TooManyRequestsException, InterruptedException;
}
